#include	<windows.h>
#include	"xserver.h"
#include	"xsdemo.h"

long FAR PASCAL WndProc( HWND , WORD , WORD , LONG );

char	string[4096];
char	command[81];
HWND	MainWindow;
HANDLE	hInst;

int PASCAL WinMain( HANDLE hInstance , HANDLE hPrevInstance ,
		    LPSTR lpCmdLine , int nCmdShow )
{
  MSG		msg;
  WNDCLASS	WndClass;
  static char	szAppName[] = "XLisp Client";
  static char	szAppCapt[] = "XLisp Client";

  hInst = hInstance;
  strcpy( string , "Request" );
  if( !hPrevInstance )
  {
    WndClass.style = CS_HREDRAW | CS_VREDRAW;
    WndClass.lpfnWndProc = WndProc;
    WndClass.cbClsExtra = 0;
    WndClass.cbWndExtra = 0;
    WndClass.hInstance = hInstance;
    WndClass.hIcon = LoadIcon( NULL,IDI_APPLICATION );
    WndClass.hCursor = LoadCursor( NULL, IDC_ARROW );
    WndClass.hbrBackground = COLOR_WINDOW+1;
    WndClass.lpszMenuName = "XC";
    WndClass.lpszClassName = szAppName;
    RegisterClass( &WndClass );
  }

  MainWindow = CreateWindow( szAppName ,
		       szAppCapt ,
		       WS_OVERLAPPEDWINDOW ,
		       CW_USEDEFAULT ,
		       CW_USEDEFAULT ,
		       CW_USEDEFAULT ,
		       CW_USEDEFAULT ,
		       NULL ,
		       NULL ,
		       hInstance ,
		       NULL );
  ShowWindow( MainWindow , nCmdShow );
  UpdateWindow( MainWindow );

  if( XDStartServer( MainWindow ) )
  {
    MessageBox( MainWindow , "Could not start server" , "Demo" ,
		MB_OK );
    return 1;
  }

  while( GetMessage(
		&msg ,
		NULL ,
		NULL ,
		NULL ))
  {
    TranslateMessage( &msg );
    DispatchMessage( &msg );
  };
  XDTerminateServer();
  return( msg.wParam );
}

/* Command dialog procedure */
BOOL FAR PASCAL CmdDlgProc( HWND hDlg , WORD message ,
				 WORD wParam , LONG lParam )
{
  char	cLastChar;
  short	nEditLen;

  switch( message )
  {
    case WM_INITDIALOG:
	SendDlgItemMessage( hDlg,IDD_FNAME,EM_LIMITTEXT,80,0L );
	return TRUE;

    case WM_COMMAND:
	switch( wParam )
	{
	  case IDD_FNAME:
		if( HIWORD(lParam) == EN_CHANGE )
			EnableWindow( GetDlgItem( hDlg,IDOK ),
			(BOOL)SendMessage(LOWORD(lParam),
			WM_GETTEXTLENGTH,0,0L) );
		return TRUE;

	  case IDOK:
		GetDlgItemText( hDlg,IDD_FNAME,command,80 );
		EndDialog( hDlg,TRUE );
		return TRUE;

	  case IDCANCEL:
		EndDialog( hDlg,FALSE );
		return TRUE;

	}	/* switch( wParam ) */
  }		/* switch( message ) */
  return FALSE;
}

/* Executes a command dialog */
int DoCmdDialog()
{
  FARPROC       lpfnDlgProc;
  int 		ErrorCode;

  lpfnDlgProc = MakeProcInstance( CmdDlgProc,hInst );
  ErrorCode = DialogBox( hInst,"Command",MainWindow,lpfnDlgProc );
  FreeProcInstance( lpfnDlgProc );
  return ErrorCode;
}

long FAR PASCAL WndProc( HWND hWnd , WORD message , WORD wParam ,
			 LONG lParam )
{
  HDC		hdc;
  PAINTSTRUCT	ps;
  RECT		rect;
  LPSTR		p;

  switch( message )
  {
    case WM_PAINT:
	hdc = BeginPaint( hWnd , &ps );
	GetClientRect( hWnd , &rect );
	DrawText( hdc , string , -1 , &rect ,
		  DT_SINGLELINE | DT_CENTER | DT_VCENTER );
	EndPaint( hWnd  , &ps );
	return 0;

    case XL_REQ:
	p = XDGetReply( MainWindow );
	xstrncpy( (LPSTR)string , p , 4095 );
	XDDeleteReply( MainWindow );
  /* Eliminate CR-LF */
	string[ strlen( string )-2 ] = 0;
	InvalidateRect( MainWindow , NULL , 1 );
	return 0;

    case XL_TRIG:
	return 0;

    case WM_DESTROY:
	PostQuitMessage( 0 );
	return 0;
/* Menu command messages */
    case WM_COMMAND:
	switch( wParam )
	{
	  case IDM_COMMAND:
		if( DoCmdDialog() )
		{
		  strcat( command , "\n" );
		  XDSendRequest( MainWindow , (LPSTR)command );
		}
		return 0;

	  case IDM_EXIT:
		SendMessage( hWnd , WM_CLOSE , 0 , 0L );
		return 0;
	}
  }
  return DefWindowProc( hWnd , message , wParam , lParam );
}
