  RETURN TO                    <REFERENCE TOPICS>                                 [BR=/I60.62/J22.20/K0.0]
  PC-BROWSE HELP[?BR.HLP]
  Introduction                Keyword Searches        Running Other Programs  
  Additional Windows          Links Between Files     Running PC-Browse       
  Bringing up PC-Browse       Loading Files           Searching From Trigger  
  Converting Cursor Word      Multiple Files          The Bookmark            
  Converting Find Text        Navigating              The Location List       
  Directory                   Normal Search           Travelling              
  File Name Patterns          Output File Name        Viewing the Main Menu   
  Foreign Characters          Pasting and Printing    Wild Cards in a Search  

          Use Tab or Arrows to highlight an entry; then press Enter
                               <INTRODUCTION>
In this section, you will learn how to:

 Get Help                                      Do a Normal Search          
 Load PC-Browse                                Do a Keyword Search         
 Exit PC-Browse                                Run other programs          
 Pop-up PC-Browse                              Bring up additional windows 
 Load a File                                   Use the location list       
 Move around                                   Paste and print 

You don't have to read this section of the manual in any particular order. 
Each subsection is self-contained, containing detailed information about a 
specific topic. 

                                                                 
Getting Help                                                               

To View the PC-Browse Help Screens: 

1. Press F1 when the main PC-Browse menu is displayed. You'll see brief 
   descriptions of the function keys, shifted function keys, cursor control 
   keys, and navigation keys. 

2. Use the normal PC-Browse viewing keys to browse the help file: 

   Scrolling          PgUp, PgDn, and their Shf and Ctl versions
   Select Topic       Arrows, Tab, Shf Tab
   Jump to Topic      Enter or Grey+
   Searching          F9, Grey+
   Begin/End          F10 or Shf Grey+, Shf F10 or Shf Grey-
   Location list      F4, Shf F4, F5, Shf F9

3. Press the Esc or F1 key to leave the Help screens. You'll return to where 
   you left off in the PC-Browse window. 

Remarks The help screens are simply the PC-Browse file BR.HLP, with links to 
the on-line tutorial file BTUT.BRS and reference file BREF.BRS. You can edit 
these files if you like. 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                             <VIEWING THE MAIN MENU> 

There are two sets of main menus, one with descriptive terms for common 
functions, the other with abbreviated terms for all functions. 

The simpler main menus are the default: 

 The simplified Main Menu is visible when you have a file loaded: 

                                                                            
 Esc:Exit  F1:Help  F4:Backtrack  F6:File  F7:Paste  F9:Find  F10:First-page 

 The simplified Shift Main Menu is visible if you hold down either shift key: 

                                                                            
 Esc:Unload      F4:View-locations      F7:Print  PgUp/Dn:more

The abbreviated main menus are turned on with the /A switch (see: Customizing):

 The abbreviated Main Menu is visible whenever you have a file loaded: 

                                                                              
Esc:Ext F1:Hlp F2:Opn F3:Op+ F4:Lc- F5:Lc+ F6:Fil F7:Pst F8:Dir F9:Fnd F10:Top

 The abbreviated Shift Main Menu is visible if you hold down either shift key: 

                                                                            
Esc:UnL       F2:Op-       F4:Lst        F6:PTo F7:Prt        F9:Lc* F10:Bot

Function keys aren't used with Ctl or Alt. Here's a preview of function key 
operations: 

   Key   Normal  Operation               Key   Shift    Operation
   Esc   Ext     Exit to application     Esc   UnL      Unload from memory 
   F1    Hlp     Browse help file        F1            
   F2    Opn     Open new window         F2    Op-      Shut current window 
   F3    Op+     Re-open a window        F3            
   F4    Lc-     To prior location       F4    Lst      Show location list 
   F5    Lc+     Re-visit location       F5            
   F6    Fil     Enter File name         F6    PTo      Enter file to print to 
   F7    Pst     Paste text              F7    Prt      Print text 
   F8    Dir     Enter directory name    F8            
   F9    Fnd     Enter Find text         F9    Lc*      Set protected location 
   F10   Top     Jump to first page      F10   Bot      Jump to last page 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                            <RUNNING PC-BROWSE>

Running PC-Browse is a two-step process. First, you load the PC-Browse program 
into your computer's memory. You usually do this only once, at the start of a 
day's work session. Then, to call PC-Browse into action, you pop it up by 
pressing its "hot key." 

PC-Browse is a pop-up program, also called a TSR (for "Terminate and Stay 
Resident," a program that stays in memory). Pop-up programs are different from 
most other programs. To use your word processor, say, you must exit the 
program you're currently using first. A pop-up program, on the other hand, is 
always loaded and ready. Even if you're working with your word processor or 
spreadsheet, you can use PC-Browse without exiting simply by "waking it up" 
with its hot key. When you're done PC-Browsing, you return to your spreadsheet 
or word processor exactly where you left off. 
                    
The only catch is you must load PC-Browse at the start of your work session 
(or, at any rate, before your word processor or spreadsheet). "Loading" a pop-
up program simply means copying it from disk into memory, and running the 
initial startup portion. You can also unload PC-Browse from memory, to get 
more memory for a large program. 

You can use one of three methods to load PC-Browse into memory: 

1. Load PC-Browse without a file. When you pop it up from DOS or another 
   program, you load the file you want to browse. 

2. Load PC-Browse along with the file you want to display. Then you can view 
   this file automatically whenever you pop up PC-Browse. 

3. Include either method in your AUTOEXEC.BAT file to automatically load PC-
   Browse each time you start your computer. 
                                                                            
To load PC-Browse only:  
                                                                             
 At the DOS prompt, type:  

       BR  <Enter> 

   The PC-Browse front screen will appear. It contains information about the 
   product. The DOS prompt is redisplayed below the message. To load PC-Browse 
   from another disk or directory, include the drive specification and path 
   before the BR command. 

Now you can run another program, a word processor, database, etc. PC-Browse 
waits in the background until you press the hot key to pop it up; the unique 
combination of keys that tells PC-Browse to become active. 
                                                                            
To load PC-Browse along with an initial file: 

 At the DOS prompt, type:   

       BR  drive:\path\filename  <Enter> 

   where drive, path, and filename define the file to be loaded into PC-
   Browse. For example, to load PC-Browse with an initial file named file.one, 
   type: 

       BR  FILE.ONE  <Enter> 

   You'll need to specify the drive and/or path if the file you want to use is 
   not in the current directory, or a PATH= or PCBROWSE= directory (see: 
   Loading a File into PC-Browse), such as: 

       BR  D:\BR2\FILE.TWO  <Enter> 

To load PC-Browse whenever you start your computer: 

1. Using PC-Write (or an ASCII text editor), modify your AUTOEXEC.BAT file.  
   This file, in the root directory of your hard disk or boot diskette, is run 
   every time you start your computer. If you don't have one, use PC-Write or 
   your text editor to create one. 

2. Add one of the following lines to the file: 

       drive:\path\BR                           (To load without a file) 
       drive:\path\BR  drive:\path\filename     (To load with a file) 

   where BR loads PC-Browse into memory and "drive:\path\filename" defines the 
   file to be loaded. The "drive" and "path" in front of BR are important, 
   since the current directory when AUTOEXEC.BAT runs is the root directory. 
   For example, if PC-Browse is in the directory PCBR on your C drive, and you 
   want to load an initial file from your PCW directory, the  AUTOEXEC.BAT 
   line might be: 

       C:\PCBR\BR  C:\PCW\MYFILE.DOC 

Remarks There are various customizing switches you can use when you load (see: 
Customizing). Two are common. The first, /C, turns on color if you have a 
color monitor. The second, /E, tells PC-Browse to load most of itself into 
expanded memory (also call EMS or LIM memory). If your computer has this kind 
of memory, and all your applications use it in the standard way (like PC-
Browse), then PC-Browse uses only 3K (instead of 60K) of normal memory. These 
switches go after the BR command, usually last on the line. For example: 

       BR AREACODE /C /E 

To unload PC-Browse from memory: 

1. If PC-Browse is not active, pop it up with Shf Ctl F1 (or any PC-Browse hot 
key). 

2. Press Shf Esc; then press F9 to confirm.  PC-Browse removes itself from 
memory. 

PC-Browse may not be able to free itself from memory. In some cases, it must 
stay to maintain an internal structure called the "Interrupt Chain." This 
happens if you load additional pop-up programs after you load PC-Browse (these 
programs must "chain" through PC-Browse to get keyboard "interrupts"). If you 
load PC-Browse after all other resident programs, you can free it with Shf 
Esc. 

Exiting PC-Browse 

When you "exit" from PC-Browse, it becomes inactive, but stays in memory until 
you need it again. To remove PC-Browse from memory, you need to "unload" it 
(above). 

To exit PC-Browse temporarily: 

 Press Esc. 
 
 Or, press Shf F2 if you have only one PC-Browse window open. 

   The PC-Browse window disappears from your screen as it becomes inactive; 
   you return to the original program you were running when you popped up PC-
   Browse. It is still in memory, waiting in the background until you need it 
   again. The Shf F2 key closes the current window, so if there's only one 
   window, PC-Browse exits in the same way. 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                            <BRINGING UP PC-BROWSE> 

The hot key is the key (or combination of keys) that pops up PC-Browse, making 
it the active program on your screen. There are six PC-Browse hot keys, but 
all except the first are shortcut keys to do various PC-Browse operations 
immediately after it pops up. The hot key combinations are written in the form 
"Shf Ctl F1." This means that you must hold down the shift and the control 
keys and then press the F1 key. 

You can change the hot key combinations. If one of your programs uses Shf Ctl 
F1, or you have a computer that does not recognize Shf Ctl combinations, you 
could tell PC-Browse to pop up with a hot key like Alt Ctl F1 or Ctl B. (see: 
Customizing.) 

To pop up PC-Browse: 
   
 Press Shf Ctl F1. 

   Shf Ctl F1 is the "basic" hot key. If you had already loaded a file into 
   PC-Browse, the page you last viewed is in the PC-Browse window and the full 
   Main Menu appears. All windows, files, and other items are the same as when 
   you left. If you pop up PC-Browse without an active file, the screen looks 
   like this: 

File:Find:cursorwordĿ 
                                                                            
                                                                            
                                                                            
                                                                            
                                                                            
                                                                            
                                                                            
                                                                            
                                                                            
                                                                            
Esc:Exit  F1:Help  F6:File  F9:Find
      
When you pop up PC-Browse, the word at the cursor in the underlying 
application becomes the Find text. Say you're writing a letter to Ms. Sanchez 
and your address file is loaded in PC-Browse. To find her address, put the 
cursor on her name, pop up PC-Browse with Shf Ctl F1, and hit the search 
(Grey+) key. September 21, 1989 The text at the cursor depends on the 
application. In a word processor, it's the word just typed. In a spreadsheet, 
it's the current cell. In DOS, it's usually the current drive or directory. If 
the cursor is just after a word, that word becomes the Find text. If the 
cursor isn't on or right after a word, the original Find text isn't changed 
when you pop up. 

To start a Lookup search for the word at the cursor: 

 Press Shf Ctl F2.  
                                   
   PC-Browse pops up and does a lookup search, the same as Shf Ctl F1 then F9 
   then F2. The word at the cursor becomes a lookup search-trigger keyword. 

To start a Linear search for the keyword at the cursor: 

 Press Shf Ctl F3.  

   PC-Browse pops up and does a linear search, the same as Shf Ctl F1 then F9 
   then F3. The word at the cursor becomes a linear search-trigger keyword. 

To pop up PC-Browse and prepare to get a directory: 

 Press Shf Ctl F8. 

   PC-Browse pops up with the cursor at the File prompt, the same as Shf Ctl 
   F1 then F8. Type the file name pattern you want. 

To pop-up PC-Browse and move the cursor to the Find prompt: 

 Press Shf Ctl F9 

   PC-Browse pops up with the page you last viewed, but with the cursor at the 
   Find prompt, the same as Shf Ctl F1 then F9. The word at the cursor becomes 
   the Find text. Press Grey+ to search for it, or F10 or Shf Grey+ to search 
   from the start of the file. 
 
To pop-up PC-Browse and view the first page of the current file: 

 Press Shf Ctl F10.   
 
   PC-Browse pops up at the first page of the file, the same as Shf Ctl F1 
   then F10. This is particularly useful with files that have an index page at 
   the start. Use the arrow keys to highlight a keyword, then Grey+ or Enter 
   to jump to the target keyword. 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                            <FILE NAME PATTERNS> 

Several PC-Browse operations apply to a group of files, not just one file. For 
these, you type a File Name Pattern at the "F6:File" prompt. A file name 
pattern looks like this: 

   drive\path\filename 
      
"drive" can be:  A drive specification of one or more drive letters followed 
by a colon. For example, to search drive C, type "C:". To search drives A and 
   C, type "AC:" (but you can't get a directory with multiple drives, only 
   search through them). To search the default drive, you don't need a drive 
   letter. 

"path" can be:  A specific directory path, such as "\PCW\" to search the PCW 
subdirectory in the root directory, or "LETT\" to search the subdirectory LETT 
   in the current directory. 

 path\*\ to also search all paths "downstream" from a given directory. For 
   example, "PCW\*\CAT" finds PCW\CAT, PCW\R1\CAT, PCW\R2\D2\CAT, and so on. 

 *\ to search all paths "downstream" from the current directory (i.e., the 
   current  directory and any of its subdirectories). 

 \*\ to search the whole disk (all paths on the drive from the root 
  directory). 

   You can also put "/s" after the file name to search all subdirectories, as 
   you can with many DOS commands. For example, "\CAT/s" finds all files on 
   the disk named CAT, and "PCW\KIT/s" finds PCW\KIT, PCW\D3\KIT, and so on. 

"filename" can be:
 A specific file name. 
 *.* to search all files. 
 A combination of DOS wild card characters and text to narrow the search: 
     The ? wild card matches any one character. 
     The * wild card matches all characters that follow it. 

   The ?'s and *'s can only be used at the end of the file name or extension; 
   a pattern such as "?BC" will not work (see your DOS manual for further 
   details). For example, "*.BAT" finds all files with the extension BAT, and 
   "A??.*" finds any three-letter file name starting with A and any extension. 

Here are some examples of file name patterns: 

   CD:*.DOC 
   
searches all files with the extension DOC on the current directories of drives 
C and D. 
   
   CE:\PCW\*.* 
   
searches all files in the PCW directories on both drives C and E. (You 
wouldn't believe how hard it is to find files when you have several hard 
disks. Or maybe you would....) 
   
   C:*\*.BAT 
   
searches all .BAT files on the current directory and its subdirectories on 
drive C. 
   
   \*\*.* 
   
searches all files on the current drive.

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                       <LOADING FILES> INTO PC-BROWSE 

Unless you always use the BR filename command to use PC-Browse with one file, 
you'll need to tell PC-Browse to load new files. A directory option makes this 
easy to do. 

To Load a File into PC-Browse: 

 Press F6. PC-Browse prompts you to type a file name in the "File:" area of 
   the top line. When you're done, press Enter. PC-Browse displays the first 
   page of the file. 

   You can specify a drive (b:myfile.doc), a path (\br\myfile.doc), or both 
   (c:\pcw\myfile.doc). If you don't specify a drive or path (myfile.doc), PC-
   Browse looks for your file in the current directory, and then each 
   directory specified by your PCBROWSE= or PATH=  environment variables. 

PC-Browse shows (and remembers) the full name of your file on the top line. If 
you exit, change directories, and then pop up PC-Browse again, it uses this 
path to find the file. For example, if MYFILE.DOC is in your PC-Write 
directory, the "File:" prompt shows: 

File:C:\PCW\MYFILE.DOCFind:Ŀ
                                                                            

You can enter a file name pattern at this prompt if you don't know the exact 
file you want. Then you can either get a directory of all matching file names, 
or all matching file names whose files also contain the Find text. (This is 
covered in Searching Multiple Files.) 

To Select a File from a <DIRECTORY>: 

1. Press F6, type a file name pattern, then press F8 (not Enter). 
 
2. Or, press F8, then type a file name pattern, then press Enter (or F8 
again). 

   A list of file names matching this pattern appears. The pattern must be for 
   a single drive only. The first one is highlighted. File name patterns are 
   described above. 
   
3. Use the Arrow keys to select the file (or subdirectory) you want.  The name 
   also appears in the "File:" prompt. There are two kinds of file name lists: 

    If your file name pattern includes directories, such as \*\ or /s, the 
      matching names are listed in one column. Use the Up and Down Arrows to 
      select the file you want. 

    If your file name pattern assumes the current directory, such as P?.DOC 
      or *.*, the matching names and subdirectories are listed in five 
      columns. All four Arrow keys select a file name or subdirectory. 
      Subdirectory names end with "\". The parent directory is also listed, as 
      "..\". 

4. Press Enter to load the selected file.  If you select a directory name 
   ending in "\" instead, you get a list of its files in this directory. 
   Select "..\" to go back to the parent directory. Note that PC-Browse does 
   not actually change your current directory. 

Remarks                                                                       
Your path is set by the PATH command, which tells DOS and PC-Browse where to 
look for files if they are not in the current directory. The path lets 
programs find your files as you change directories on your hard disk. The PATH 
command puts the various paths into the PATH= environment string. There is 
also a special PC-Browse "path" environment string, PCBROWSE=. The PCBROWSE= 
environment string is searched first. Put PC-Browse text files into a separate 
directory (one not in your PATH) to keep DOS searches fast. 

If PC-Browse can't find a file in your current directory or along your path, 
it beeps and displays "Can't find filename", where "filename" is the file you 
asked for. 

Files You Can Load With PC-Browse 

Text Files: 

PC-Browse works easily with "straight-ASCII" text files. These files contain 
only "printable" characters; they have no formatting or "control" codes. These 
files include:  

    PC-Write files without formatting commands (or with them; see below). 
    Output files from a database or spreadsheet "print to file" option. 
    Word processor files saved in "non-document" mode. 
    Batch (.BAT) files or program source files (such as .C, .PAS, or .ASM). 
    Text files downloaded from bulletin boards. 

In normal text files, each line ends with a carriage return and line feed 
(code 13 then 10). PC-Browse assumes the line feed (code 10) ends a line. 
Carriage return (code 13) doesn't force the end of a line; it is ignored 
before a line feed, and assumed to be a PC-Write X font any other place. For 
extremely large files with very short lines, you can save some room by leaving 
out the carriage returns. This applies to some PC-Browse applications using 
the lookup search. But for most text files, and any file created with PC-
Write, each line should end with the normal carriage return and line feed 
pair. 

Word Processing Files: 

Most word processing files include formatting codes for margins, fonts, and so 
forth. PC-Browse knows how to read these codes in PC-Write files; it displays 
them as easily as it does text files. PC-Write font characters (all codes 
below 32) and guidelines (all lines starting with code 11) are "hidden", as 
they would be in PC-Write's Hide mode. PC-Write page break lines (code 12, or 
the pair 12 then 15) are hidden, but actual text on a line after a form feed 
is visible (including PC-Write page numbers). 

Many other word processors store formatting information in the first few 
hundred bytes of their files. You never see it when you're working in the word 
processor, but it's there. The rest of the file is relatively "clean", so just 
use Shf PgDn to skip the first screen or so. 

In some word processors, every paragraph is stored as one very long line. You 
can use the Shf Left and Right Arrow, Home, and End keys to view the long 
"lines" in these files. 

A few word processors store your text in a completely non-ASCII, proprietary 
format. You may have difficulty reading such files with PC-Browse. 

Other File Types: 

Other files, such as programs (.EXE, .COM) or spreadsheet files (.WK1) can 
also be displayed in PC-Browse, but, since they are not ASCII files, you will 
probably have trouble recognizing more than small fragments of them. You may 
find the text of any messages they display. Some database files (dBase, PC-
File) are partially readable. 

You can't read encrypted files (so much for peeking at the passwords) or files 
compressed with archiving programs. PC-Browse won't show understandable text. 
There's nothing wrong with your file, or with PC-Browse; the contents just 
aren't in standard text format. Since PC-Browse never writes to the file, you 
can always PC-Browse a file without harm. 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                        <TRAVELLING> IN PC-BROWSE

Information in a PC-Browse file is divided into pages. Pages are always 
separated by a form feed (a PC-Write page break). The form feed symbol is a 
circle with a cross under it. (character code 12). In PC-Browse, as with a 
printed report, each page of text is separate. In order to display material as 
clearly as possible, PC-Browse shows only one page at a time. You won't see 
the bottom of one page and the top of another (as you would with PC-Write.) 

To scroll one line at a time within a page: 

 Press PgDn to scroll forward (toward the end of the file). 

 Press PgUp to scroll backward (toward the top of the file). 

   PgDn and PgUp allow you to scroll one line at a time within a page of text. 
   Scrolling stops when you reach the top or the bottom of the page. 

To move in larger jumps (even across pages), use Shf PgDn or Shf PgUp. 

To scroll one window at a time: 

 Press Shf PgDn to scroll down one window. 

 Press Shf PgUp to scroll up one window. 

   Shf PgDn and Shf PgUp scroll one window's worth at a time, until you reach 
   the top or bottom of the page. Shf PgDn at the bottom of a page goes to the 
   top of the next page. Likewise, Shf PgUp at the top of a page jumps to the 
   bottom of the preceding page. Shf PgDn at the end of the last page or Shf 
   PgUp at the top of the first page just beep. 

   Notice the graphical reminder, near the bottom of the right edge of the 
   window. If you can page down, you see a downward triangle (ASCII 31). 

                                                                            
 Esc:Unload       F4:View-locations      F7:Print PgUp/Dn:more

   If you can page up, the triangle will point upwards (). 

                                                                            
 Esc:Unload       F4:View-locations      F7:Print PgUp/Dn:more

   If you can page in either direction, the triangles join to become a 
   diamond.

                                                                            
 Esc:Unload       F4:View-locations      F7:Print PgUp/Dn:more

   Finally, if the entire file fits in the window and has no page breaks, you 
   can't scroll in either direction, and no PgUp/Dn marker appears on this 
   line. 
      
To move directly from page to page, use the Ctl PgUp and Ctl PgDn keys. 

To scroll one page at a time: 

 Press Ctl PgDn to move to the next page. 

 Press Ctl PgUp to move to the prior page. 
   
   Ctl PgDn takes you to the top of the next page (except on the last page of 
   the file). In the middle of a page, Ctl PgUp moves to the top of that page. 
   If you press it again, it moves to the top of the preceding page, and so on 
   until you reach the top of the file. 

People are particular about PgUp and PgDn. About 30% feel they move in the 
wrong direction. Another group feels PgUp/Dn and Shf PgUp/Dn should be 
swapped. You can alter these keys to suit yourself with the /A switch (see: 
Customizing). 
                                                    
To move to the top or bottom of the file: 

 Press F10 or Shf Grey+ to move to the top of the file. 

 Press Shf F10 or Shf Grey- to move to the end of the file. 

   Grey+ and Grey- refer to the plus and minus keys on the numeric keypad at 
   the far right of the keyboard, not the keys across the top of the keyboard. 
   They're grey rather than white on most keyboards. Not all keyboards have 
   Grey+ and Grey- keys. 

You may be looking at a file wider than 78 columns. You can scroll the window 
left or right on the page to see the entire file through the PC-Browse window. 

To scroll the window left: 

 Press Shf Left Arrow.  The text on the page moves right, so you can see 20 
   more columns on the left. 

To scroll the window right: 

 Press Shf Right Arrow.  The text on the page moves left, so you can see 20 
   more columns on the right. 

To scroll left to the left margin: 

 Press the Home key.  The start of every line is visible. 

To scroll one window right from the left margin: 

 Press the End key.  Columns 79 to 156 (one window width right) are visible. 

You can also move to the next or prior trigger keyword (a highlighted word 
that links to the location of its target keyword). The selected trigger 
keyword replaces the Find text. Any upper case letters in the trigger keyword 
become lower case in the Find text, since lower case matches both upper and 
lower case in a keyword search. 

To scroll to next or prior trigger keyword: 

 Press Tab to move to the next trigger keyword. 

 Press Shf Tab to move to the prior trigger keyword. 

 Press an Arrow key to select a trigger keyword if they're lined up in rows 
and columns. 

   A trigger keyword is a word surrounded by special characters (delimiters) 
   that initiates a linear or lookup search. (Keyword Search discusses 
   triggers and delimiters.) If there are no (more) trigger keywords in the 
   file, PC-Browse beeps. If the file is long, the bottom line of the window 
   shows you it's searching for the trigger. 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                              <NORMAL SEARCH> 

In a normal search, PC-Browse scans the file for the next occurrence of the 
find text. 

To do a normal search: 

1. Press F9. The cursor moves to the Find text area. You see the Find menu: 

                                                                            
MATCH  F5:Any alpha  F6:Non-alpha.  SEARCH  F10:From top  Grey+:From cursor.

2. Type the text you want to search for. 

   The default Find text is the word at the cursor in the original program 
   when you pressed the hot key. (If there was no text at the cursor, the Find 
   text does not change). If this is the text you want to search for, you 
   don't need to press F9 or type it in again. 
    
3. Press the Enter key to just accept the Find text without starting a search. 

4. Or press one of the search keys to start searching from the F9 prompt: 
    Grey+ (or Ctl-L).        Searches from the current location forward. 
    Grey- (or Ctl-O).        Searches from the current location backward. 
    Shf Grey+ (or F10).      Goes to the top of the file and searches forward. 
    Shf Grey- (or Shf F10).  Goes to the very end and searches backward. 

To do a normal search on a word from another program: 

1. From that program, place the cursor on the word you wish to search for. The 
   cursor can be on any character of the word. It can also be on the space 
   just after the word, so you can type the word and then search for it with 
   PC-Browse. 

2. Press Shf Ctl F9. PC-Browse pops up and puts the word at the cursor in the 
   original program into the Find text. The cursor is in the Find text. 

3. Press one of the search keys described above. 

Once PC-Browse finds the text, the search stops and the found text is 
highlighted. 

 To search for further occurrences of the find text: 

 Grey+ (or Ctl-L) searches forward. 
 Grey- (or Ctl-O) searches backward. 
 Enter searches forward (at the Find or File prompt, Enter just accepts the text). 
 Shf Grey+ (or F10) then Grey+ searches forward from the top. 
 Shf Grey- (or Shf F10) then Grey- searches backward from the end. 

While PC-Browse is searching, it displays the following message: 

                                                                            
Finding... (xx%) [Press any key to stop search]

where "xx" indicates how far the search has progressed through the file. If 
you press a key while this message is displayed, the search stops. 

If PC-Browse finds the text, the window shows the page, with the found text 
highlighted. The file locations both before and after you made the jump are 
saved in the location list. Press F4 to return to the previous location, or 
Shf F4 to view the list. (See: Location List.) 

If PC-Browse does not find the text, it displays "Not found: text" where 
"text" is the text you were searching for. The message is cleared the next 
time you press a key. 
      

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                CASE MATCHING AND <WILD CARDS IN A SEARCH> 

PC-Browse has case matching rules and wild card characters that help you 
search for text. It uses the same case matching and wild cards as PC-Write's 
Find function. These aren't the same as the file name wild card characters * 
and ? used at the File: prompt. 

During a search, lower case letters match the corresponding upper case and 
accented letters. For example, "a" matches "a", "A", "", and so on. To match 
only the lower case "a", press F4 before it to match "a". (Lookup keyword 
searches are different; all cases match.) 

Also, a single space matches any combination of spaces, font characters (codes 
1 to 31, except 12), line boundaries (code 13,10 pair), or PC-Write Guide 
Lines (any line starting with code 11). Again, the F4 wild card before a space 
makes it match exactly one space. 

PC-Browse normally ignores PC-Write font characters in the file (codes less 
than 32). For example, if your Find text is Gregor, PC-Browse finds Gregor 
even if the "G" is boldfaced. However, if you put explicit font characters in 
the Find text, they must occur in the file to match (unless they are also wild 
cards, in which case you need the F4 wild card in front of them). 

Like a wild card, a trigger keyword delimiter modifies the search. Either a 
linear or a lookup search-trigger keyword delimiter matches the corresponding 
target keyword delimiter. A lookup trigger delimiter also invokes a lookup 
search instead of a normal, linear search. Also in a lookup search, all letter 
cases match. 

You can use the following wild cards to find a text string with a particular 
pattern: 

Key  Symbol     Description     
                 
F4   Triangle   Matches the next character exactly. In particular: 
     (16)          A space matches exactly. 
                   A lower case letter matches exactly. 
                   A trigger keyword delimiter matches exactly. 
                   A character that represents a wild card matches exactly: 
                      Alt-A, Alt-D, Alt-J, Alt-M, Alt-X and Alt-Z. 
                If you want to search for one of these PC-Write font 
                characters, you must precede it with F4 so that it does not 
                act like a wild card. 
                       
F5   Bullet     Matches any letter or number found at that position, but not 
     (07)       spaces or symbols (i.e., matches "a" or "3" but not "." or 
                "$"). 
                       
F6   Dark       Matches any space or symbol found at that position, but not 
     square     letter or numbers (i.e., matches "." or "$" but not "A" or 
     with dot   "3". Use F6 to find whole words: "at" surrounded by F6 char-
     (08)       acters won't find "cat" or "match"
                       
F7   Starburst  Matches any one character, blank, letter, number, or symbol. 
     (15)      
                       
F8   Musical    Matches a line boundary, the characters at the end of a line. 
     Notes      Line boundaries contain a carriage return (code 13) and line 
     (13,14)    feed (code 10). Character 13 by itself matches the carriage  
                return; Character 14 by itself matches a line feed.

Here are some examples: (in this example ! stands for the F4 wild card,
                            for F5, ? for F6 and  for F7 wild card).
   
Text        Wild Card      Matches              Doesn't match
ax!$        F4(!)          ax$                  axe, ax*
Hose       F5()          House, Horse         Hose, Ho-se
C?PO        F6(?)          C.PO, C+PO           C3PO, CAPO
Aom        F7()          Atom, A:om           Aom, A..om

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                      <FOREIGN CHARACTERS> IN A SEARCH

If the text you want to find contains foreign or special characters, you can 
enter them from the keyboard using the Accent key. Each special character is 
created typing the first of a pair of characters, then the Accent key, then 
the second of the pair. The Accent key acts like a special Left Arrow, 
overstriking the first character with the second. 

PC-Browse supports both the normal IBM extended character set and the 
alternate "Code Page 850" character set (if your computer hardware supports 
its use). 

To enter foreign or special characters with the Accent key: 

 Type one of the characters below, then the Accent key, then the second 
character. 

Here's the table of Accented characters: 

PRESS <END> TO SEE TEXT OFF TO THE RIGHT

Code  Keys     Char     Code  Keys     Char     Code  Keys     Char     Code  Keys     Char   
128   C and ,          141   i and `          154   U and "          222   7 and `    *
129   u and "          142   A and "          155   c and /          224   a and /    *
130   e and '          143   A and o          157   = and Y          226   g and /    *
131   a and ^          144   E and '          160   a and '          227   p and /    *
132   a and "          145   a and e          161   i and '          228   S and /    *
133   a and `          146   A and E          162   o and '          229   s and /    *
134   o and a          147   o and ^          163   u and '          231   t and /    *
135   c and ,          148   o and "          164   n and ~          232   F and /    *
136   e and ^          149   o and `          165   N and ~          233   h and /    *
137   e and "          150   u and ^          166   a and _          234   M and /    *
138   e and `          151   u and `    *     167   o and _          235   d and /    *
139   i and "          152   y and "          168   ? and ?          236   $ and `    *
140   i and ^          153   O and "    *     173   ! and !          237   f and /    *

If you have a VGA display and are using the code page 850 extended character 
set, you lose the above characters marked with *; however you gain the 
following characters: 

PRESS <END> TO SEE TEXT OFF TO THE RIGHT

Code  Keys     Char     Code  Keys     Char     Code  Keys     Char     Code  Keys     Char 
155   o and /          209   D and -          216   I and "          231   t and h     
157   O and /          210   E and ^          222   I and `          232   T and H    
181   A and '          211   E and "          224   O and '          233   U and '     
182   A and ^          212   E and `          226   O and ^          234   U and ^     
183   A and`           213   i and .          227   O and `          235   U and `     
198   a and ~          214   I and '          228   o and ~          236   y and '     
199   A and ~          215   I and ^          229   O and ~          237   Y and '    
208   d and -   
                                                                                            
Remarks
PC-Browse also accepts PC-Write font characters, entered with the Alt key and 
a letter. 

You can also search for any character by entering its numeric code at the Find 
prompt. Just hold down the Alt key as you enter the decimal code using the 
numeric keypad. The character appears when you release the Alt key. 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                       SEARCHING <MULTIPLE FILES> 

PC-Browse allows you to search for the Find text in multiple files on your 
disk. Basically, you use the DOS wild card characters you're already familiar 
with, ? and *. You can view each file containing the Find text, or put a list 
of such files onto the location list. 


To search multiple files: 

1. If the text you want to search for is not already in the Find prompt, press 
   the F9 key, type the search text, and press Enter.  Don't start the search 
   by pressing Grey+ yet. 

2. Press F6, or F8. PC-Browse prompts you to enter a file name. Press F8 if 
   you know you want a list of files, not a view of each one. 

3. Type the file name pattern using a combination of text and file name wild 
   cards. 

4. Press the Enter key to accept the file name, or Grey+ to accept it and then 
   search. 

5. When the search first starts, you get the following prompt (unless you 
   pressed F8; then PC-Browse knows you want a list of files): 

                                                                          
Esc:Cancel  F9:View each match as found  F10:Collect matches and list them

    Press F9 to load each file containing the Find text. 

      When a match is found, PC-Browse displays the file, highlighting the 
      found text. You can move around through this file freely with PgDn, Shf 
      PgDn, and so on. If this is not the occurrence of the Find text that 
      you're looking for, press Grey+ or Enter to keep searching. The search 
      will continue through the end of the current file and then on to the 
      next file that matches the file name pattern. 
   
      You can also press Shf Enter to go right to the next file and search. 
      Press Shf Enter as soon as you know the current file is not the one you 
      want. You can also press Grey- to search backwards in the file; however, 
      it won't go back to a prior file. 
   
    Press F10 to put all files containing the Find text on the location list.  

      This process may take a while. It adds to the location list, described 
      below. When it finishes, the location list is displayed. Use the arrow 
      keys to select a file to load. Since the location list has a limited 
      size, all locations may not fit. This means you only get the end of the 
      list. However, you can press the Shf F9 key first to set a protected 
      location, and then cancel the search when the list fills. Then you get 
      the first part of the list. You can also make the location list bigger 
      (see:Customizing). 
   
As each file matching the pattern is searched, its name is displayed in the 
File prompt, along with the original file name pattern. For example, if the 
pattern is: 

      CE:\PCW\*.* 

the File prompt might display: 

File:CE:\PCW\*.*=C:\PCW\MYFILE.DOCFind:browseĿ
                                                                            

While PC-Browse is searching, it displays the following message: 

                                                                            
Finding... (xx%) [Press any key to stop search]

where "xx" indicates how far the search has progressed through the file being 
searched (the counter starts over with each file). If you press any key while 
PC-Browse is searching, the search stops (the key's normal action does not 
occur). 

If you change the Find text after a multi-file search and search again, PC-
Browse asks if you want to continue the multi-file search, or just search the 
current file: 

                                                                            
Esc:Cancel  F9:This file only  F10:All files matching file spec

Press F9 to just search the current file, or F10 to continue the multi-file 
search but look with the different Find text. 

If PC-Browse can't find any file that matches the file name pattern, it shows 
the message: "Can't find filename pattern" where "filename pattern" is what 
you entered at the File prompt. (The message clears the next time you press a 
key to do something.) 

If no (more) occurrences of the Find text can be found in any file that 
matches the file name pattern, PC-Browse displays "Not found  text" where 
"text" is the text you were searching for. PC-Browse shows the last file (if 
any) that contained "text." 

Remarks  
PC-Browse, by default, skips certain non-text files in a multiple file search. 
Files with extensions .COM, .EXE, .OBJ, .OVL, and .OVR are skipped unless you 
specifically tell PC-Browse to search them (e.g., by setting the File text to 
*.EXE). In addition, hidden files are skipped, but again if you know the name 
of a hidden file you can search it by giving the name at the File prompt. 
Also, you can customize the list of excluded file name extensions, to skip 
large non-text files like compressed files or fonts (see: Customizing). 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                            <KEYWORD SEARCHES> 

There are two kinds of keyword searches; a linear keyword search and a lookup 
keyword search. This section describes keyword searches in general, and linear 
and lookup searches in particular. 

A linear keyword search is a kind of normal search. The Find text has linear 
search-trigger keyword delimiters, which match the same text with target 
keyword delimiters. In a normal search, "paint" finds "paint" (or "Paint", 
"PAINT", etc). In a linear keyword search "<paint>" finds "!paint" (or 
"!Paint", etc.), assuming < > and !  are the defined linear-search trigger 
and target keyword delimiters. 

A lookup keyword search appears on the surface like a linear keyword search. 
However, it does not scan the whole file like a normal search or a linear 
keyword search; instead it uses a much faster method (divide and conquer) 
since the file is sorted by the keyword. The lookup search is an extremely 
fast search of sorted data, most useful with large files created from a data 
base program. There are four requirements for a lookup search: 

1. Each target keyword can appear only once in the file. 
2. Each page must have one and only one target keyword. 
3. Each page is limited to no more than 4096 bytes (or current buffer size). 

4. The lookup targets must occur in alphanumeric sort order, so a page with 
  "Beckett" comes before the one with "Brecht," which comes before the one 
   with "Shakespeare."  

PC-Browse does a "divide and conquer" to do a lookup search. First it compares 
the target keyword on the current page to the one it's seeking. If it's 
looking for "Marimba" and finds "Glockenspiel," it knows the target keyword 
must occur later in the file. But if it finds "Sousaphone," it knows "Marimba" 
lies in the first part of the file. It repeats this strategy with the selected 
portion of the file, choosing a page in the middle and comparing keywords 
again. This continues until it hits the target. Should there be two 
occurrences of the target text, there is no guarantee which one it will find. 

Note that both lookup and linear searches find the same target keyword; they 
simply use different methods. The lookup search is much faster on large files 
(perhaps 20 times faster on a 2-megabyte file), but lookup files have more 
exacting design requirements. 

To describe a keyword search, we use the idea of a trigger keyword and a 
target keyword. The trigger keyword is the word that can start a search; the 
target keyword  is the word found by such a search. A keyword search only 
finds words delimited (specially marked) as search targets. Keyword searching 
requires files designed for PC-Browse. If you just want to find a text string 
within a normal file, use the Normal Search, described above. 

There are three ways to trigger a keyword search: 

1. Convert normal PC-Browse Find text to a trigger keyword, and then search. 
   (see Converting Find Text)

2. Pop up PC-Browse and do a keyword search for the word at the application 
   cursor. (see Converting Cursor word)

3. Start a search from a trigger embedded in the text. This method allows you 
   to link  (cross reference) related information. This capability is often 
   referred to as hypertext. (see Searching from Trigger)

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                           <CONVERTING FIND TEXT>

To do a keyword search on a word you type in: 

1. Press F9 to put the cursor at the Find prompt. Type the text you want to 
search for. 

2. Press F3 to convert the Find text to a linear trigger keyword and begin the 
   search. PC-Browse places the linear search-trigger delimiters around the 
   Find text and forces the text to lower case. It then searches the file 
   (from the top, not simply from the current location) for the first 
   occurrence of the Find text as a target keyword. 

3. Or, press F2 to convert the Find text to a lookup trigger and begin the 
   search.  PC-Browse places the lookup search-trigger delimiters around the 
   Find text and does a faster lookup search. There should only be one 
   occurrence of the lookup target text. 

Let's assume your linear search-trigger keyword delimiters are "{" and "}", 
your target keyword delimiters are "<" and ">", and you typed "hi" at the Find 
prompt. If you simply press Grey+, PC-Browse does a normal search, finding 
"hi", "this" and "<hi>". However, if you press F3 instead, it converts the 
Find text to "{hi}" and finds only "<hi>". The braces in the Find text "{hi}" 
tell it to look in the file for "<hi>"; the trigger delimiters match the 
target delimiters. Now if you press Grey+, you get a linear keyword search, 
because the find text "{hi}" is still active. 

While PC-Browse is doing a linear search, it displays the following message: 

                                                                            
Finding... (xx%) [Press any key to stop search]

where "xx" indicates how far the search has progressed. If you press a key 
while this message is displayed, the search stops (the key's action is 
ignored). 

If PC-Browse finds the target, the search stops and the found text is 
highlighted. If not, it displays "Not found  {text}" where "text" is the 
target you were searching for and "{" and "}" are the search-trigger 
delimiters. (The message clears when you press a key.) 

For a lookup search, if the targets are not sorted in the file, PC-Browse may 
(or may not) discover this and display: Pages must be sorted for a Lookup 
search to work. PC-Browse displays the page with the target keyword that 
caused it to give this message. However, often it won't detect that the file 
is not sorted, since this faster search does not read the whole file. It 
simply tells you it can't find your text. Also, each page must fit into the 
PC-Browse text buffer. If it finds a page larger than the buffer (4096 bytes 
by default) with no target keyword, it displays the message "Pages in this 
file are too long". 

To continue searching for the same target keyword: 

 Press the Grey+ or Enter key.  The target keyword for a linear search may 
   occur more than once. Grey+ or Enter finds the next one. (Grey- finds prior 
   ones.) The braces are still in the Find text, so each repeated search is 
   still a linear keyword search. If you press F9 then F3, you also get a 
   linear keyword search, but from the top of the file. 

For example, in the file AREACODE, each state abbreviation is a target 
keyword. Since some states have several areacodes, some target keywords occur 
several times. If you type CA as the Find text and then press F3, PC-Browse 
finds the first page, 209/Fresno. If you press Grey+, it finds the next one, 
213/Carson. 

If you press Grey+ after doing a lookup search, it does the lookup search 
again. Since each target appears only once, it finds the same page. This is 
one way to get back to a target page after you've found it (via lookup search) 
and then browsed around the file. You might also change files and press Grey+ 
to repeat the lookup search in the new file. 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                         <CONVERTING CURSOR WORD>

To do a keyword search on a word from another program: 

1. From that program, place the cursor on the word you wish to search for.  
   The cursor can be on any character of the word. It can also be on the space 
   just following the word, so you can type the word and then search with PC-
   Browse. 

2. Press Shf Ctl F3 to do a linear keyword search. PC-Browse pops up, grabs 
   the word at the cursor in the original program, makes it lower case, adds 
   the delimiters to create the linear search-trigger keyword in the Find 
   text, and searches for the first occurrence in the PC-Browse file of that 
   word as a target keyword. 

3. Or, press Shf Ctl F2 to do a lookup search.  A similar process occurs, 
   using lookup search-trigger delimiters. 

   If the PC-Browse file has no appropriate keyword definitions, it pops up, 
   but gives you a message and leaves the cursor at the Find text prompt. 

For example, load the sample file MISUSED into PC-Browse. Press Esc to return 
to your original application (or the DOS prompt). Type the word "its" and then 
press Shf Ctl F3. PC-Browse pops up and jumps to the page covering the proper 
use of "its" and "it's." 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                         <SEARCHING FROM TRIGGER>

To do a keyword search on a cross-referenced word: 

1. Use Tab (or Shf Tab) to select the next (or previous) trigger keyword. If 
   the trigger keywords are aligned in rows and columns, you can also use the 
   four Arrow keys. When you select a trigger keyword, it appears as new the 
   Find text, in lower case. These keys stop at both linear and lookup search-
   trigger keywords. 

2. Press the Grey+ or Enter key to search for the target keyword. This 
   searches from the start of the file for the first occurrence of the text as 
   a target keyword. 
   
For example, load the sample file HAMLET into PC-Browse. Each time you press 
Tab, the next trigger is highlighted. The Find text shows the trigger you just 
found. If you tab to the "outrageous fortune" trigger (the fourth trigger in 
the file) and press Grey+, you jump to the page with "<outrageous fortune>" at 
the top as the target keyword. 

If the triggers are lined up in contiguous rows and columns (called an index 
page), the four Arrow keys also select a trigger keyword. For example, in the 
sample file MISUSED the first page is an index page. You can use the Arrow 
keys to highlight a trigger keyword, and then Enter or Grey+ to jump to the 
corresponding target page. 

You may want to search for a particular trigger keyword itself. For example, 
you want to find all cross-references to a given target keyword. 

To search for references to a keyword 

1. Place the trigger keyword in the Find text. You can type the keyword at the 
   F9 prompt and press F3, use the Tab key to select it, or type the keyword 
   and delimiters yourself. 

2. Press F9 to go to the Find text. 

3. Press Ins, then F4. This inserts the F4 wild card in front of the first 
   search trigger keyword delimiter, to make it match exactly. 

4. Press End, then Bksp. This removes the final search-trigger keyword 
delimiter. 

5. Press Grey+ to search. Because of the F4 wild card, you get a normal 
search. 

Remarks  
Most of our sample files use PC-Write font characters as trigger delimiters. 
In MISUSED, for example, the index on the first page doesn't show the trigger 
delimiters, because PC-Write font characters are hidden in PC-Browse. This 
makes the table easier to read. Fonts do appear in the Find text when you use 
Tab or Arrow keys to highlight a trigger. (see also Links between files)

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                             <LINKS BETWEEN FILES> 

You can put a file name in square brackets after a trigger keyword to link to 
the target keyword in that file. This can be handy to organize your 
application files. An earlier example used PARTS and SUPPLIER files to keep 
different information in different files. Very large applications can be 
easier to manage if divided into separate files, too. 

The left square bracket must come either right after the trigger keyword, or 
with one space between. If you want the file name in brackets hidden in PC-
Browse, put a question mark after the left square bracket; in this case you 
can't put a space between the keyword and the bracket. Some examples: 

#3478 [PARTS]          Link to part #3478 in the PARTS file. 
<PLIERS>[TOOL.LST]     Link to keyword PLIERS in the file TOOL.LST. 
<HAS CAR>[?SCRIPT2A]   Link to keyword HAS CAR in the SCRIPT2A file, but don't 
                          show the brackets or the file name. 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                          <RUNNING OTHER PROGRAMS>

PC-Browse can also run another program when a trigger keyword is selected, 
instead of linking to the other file. In fact, it can run any DOS command. 
Basically, you just put the DOS command in square brackets instead of a file 
name. But there are some rules. 

First, PC-Browse must be in non-resident mode. You must run PC-Browse as a 
normal program, instead of a resident (TSR) program. DOS can't handle a 
resident program that pops up over a second program and runs a third program. 
In non-resident mode, you cannot use the Esc key to exit; you can only use Shf 
Esc to unload PC-Browse from memory and exit. 

To load PC-Browse in non-resident mode, use the /M startup customization 
option, usually by giving it on the command line that starts PC-Browse. For 
example: 

   BR MAINMENU.BRS /M 

Next, you must tell PC-Browse you want to do a DOS command, not just link to a 
file. To do this, follow the "[" (or the "[?" if you want to hide it) with a 
">". For example: 

Lotus [>123 PAYABLES]
*Word Processor*[?>ED]
"Regrets-Letter"[?>ED BOZOLET.TMP /e]
*Prepare New Disk*[?>c:\sys\FORMAT B:/s]

After PC-Browse runs the other program, the PC-Browse window returns. For 
example, [>TYPE BETA.DOC] types BETA.DOC and returns to PC-Browse. In this 
case, the file would whiz by so fast you couldn't see it. But you can tell PC-
Browse to give the message "Press any key to continue" and wait for the user 
to press a key before returning. Put a /P before the command text to do this. 
For example, [/P >TYPE BETA.DOC] 

Even though PC-Browse is "non-resident", when you use it to run another 
program you can pop up PC-Browse in that other program (you just can't run yet 
another program). You can give users of these programs access to on-line help, 
customer information, etc. When you include the command to run another 
program, you can also give the name of a PC-Browse file to be made available 
when the user pops up PC-Browse. Every program you run can have its own PC-
Browse help file. The /H switch does this. For example: 

   *Payroll[? /H:FEEDEM.BR  >123 PAYRLL89.WKS]
   *Payables[?/H:STALLEM.BR >123 PAYBLE89.WKS]

If you use several of these options, start with the "?" that hides the entry, 
then put the /H:File and /P switches, and finally the ">" followed by the DOS 
command line. 

This ability to "launch" other programs can be used to create a menu of 
programs and commands to run from PC-Browse. This can be handy for people who 
are not overjoyed when they see a DOS prompt. The sample application file MENU 
gives you a model to start from. Here's a sample page from this file: 

   <DOS>
   Dir[?/p>dir /w] 
   Check Disk[?/p>chkdsk]
   Shell to DOS[?>c:\command] 
    (remember: type the word 'EXIT' to return to this menu.)
   F10 to Return to the Main Menu


The first line, <DOS>, is a target keyword used to reach this page from the 
main menu. The second contains the trigger keyword Dir (the [?/p>dir /w] 
part is invisible). When the user selects this trigger with the Tab key and 
hits Enter, the DOS directory appears, followed by Press any key to continue. 
After viewing the directory and pressing a key, the user sees this menu page 
again. 

The third menu item runs a program called COMMAND. Since this is the DOS 
command processor, when the user selects this option they get a normal DOS 
prompt, and can run any DOS commands (similar to PC-Write's F1 then F4 
option). The DOS command exit leaves this shell of DOS and returns to the PC-
Browse menu again. 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                            <ADDITIONAL WINDOWS>

PC-Browse can display a large amount of information. You can view different 
but related references at the same time with multiple windows. The number of 
windows depends on the height of the windows, which you can define yourself 
(see: Customizing). 
 
To open a new window: 

 Press F2. If there is room on the screen, an exact copy of the current 
   window is opened below it. You continue working in the new window while the 
   original remains visible. 

There must be room on the screen to display the full window (minus 1 line; the 
top line covers the bottom of the window above). By default, there are 25 
screen lines; the first window takes lines 1-13, the second lines 13-25. If 
you change the height to 9 lines, three windows fit, on lines 1-9, 9-17, and 
17-25. If your screen can display more lines (as EGA and VGA adapters do) you 
can tell PC-Browse to use a longer screen. (see: Customizing.) 

To shut the current window: 

 Press Shf F2. The current window is closed and you are returned to the 
   window above. Pressing Shf F2 at the first window exits; you are returned 
   to the original program. 

To reopen a window: 

 Press F3. Unlike F2, which opens a new window, F3 reopens the last one that 
   was shut. A window can be reopened as long as another window has not been 
   opened with F2. 

You can slide the PC-Browse windows down on the screen, to see your 
application screen underneath. Then you can slide it back again. The Shf Up 
and Down Arrow keys do this. 

To slide the window down: 

 Press Shf Down Arrow. 

To slide the window up: 

 Press Shf Up Arrow. 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                        <NAVIGATING> WITHIN PC-BROWSE

As you explore with PC-Browse, traveling within a file or across several 
files, there is always the chance that you may get "lost." PC-Browse provides 
you with two navigational aids that allow you to go off on tangents, confident 
that you can return to your starting point or to any interesting "way 
stations" that you noted while PC-Browsing.
(For details see The Location List and The Bookmark)

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                            <THE LOCATION LIST>

The location list is the main navigational aid. Each location records the 
file, your position in it, and any "found" text. Every time you search for 
text or link to a keyword, PC-Browse puts both the original and the new 
location on a list. If the original was already on the list, it doesn't go on 
twice. Pressing Tab to select a trigger word doesn't save the location, but 
does change it (since the selected text changes). If you press Enter to follow 
this link, then the location is saved. All PC-Browse windows share one 
location list. 

You can put any location on the list yourself. If you are viewing one file but 
have set a location in another, PC-Browse automatically returns to the correct 
file when you return to that location. The file name, screen position, and 
selected ("found") text are restored. 

The location list is sequential; location 1 is followed by location 2, then 
location 3, and so on. You can go back up the list with F4, then either go 
down the same list again with F5, or start a new branch with any search or 
with the set-location key, Shf F9. You can also view the entire list and 
select a location from it, with Shf F4. There is only one path, so if you 
start a new path at location 3, every location beyond that (such as 4 and 5) 
is cleared. 

There is a limit to the number of location marks you can set, and that number 
varies. PC-Browse allocates 1024 bytes by default for storing the location 
list for all windows. You can increase this to store a longer location list 
(see: Customizing). When the list is full and you add a new location, the 
oldest location is normally removed. 

However, when you use Shf F9 to put a location on the list, that location is 
protected. PC-Browse asks if it's okay to remove a protected location from the 
list with the prompt: 

                                                                            
Protected location found:   Esc:Cancel  F9:Overwrite it

A small arrow in the upper right hand window border shows the location list 
status. If the arrow is pointing down you are at the start of the list. 
If it is pointing up you are at the end of the list. A double headed 
arrow means you are in the middle of the list and can go in either 
direction. 

To set a position on the location list: 

 Press Shf F9.  Any search also puts the locations before and after the jump 
on the list. 

To move to the prior location on the list: 

 Press F4.  If you're at the start of the list, PC-Browse beeps. 

To move to the next location on the list: 

 Press F5.  If you're at the end of the list, PC-Browse beeps. 

To view and select from the Location list: 

 Press Shf F4.  The last location on the list (where F4 would take you) is 
highlighted. 

 Press Up or Down Arrow to select a location.  The list scrolls to show all 
locations. 

 Press Grey+ or Enter to jump to the location.  The old location does not go 
on the list. 

 Or, press Esc to cancel the location list view. 

The location list shows a  for a protect location, and a  for a location 
added by a multi-file search for the find text. For example: 

File:c:\br\hamletFind:Thus conscience does make
 a:\launch                                        browsers                 
  c:\br\address                                    Walton                   
  c:\br\hamlet                                     of the play.             
  c:\br\hamlet                                     <TO BE, OR NOT TO BE>    
  c:\br\hamlet                                     Must give us pause.      
 c:\br\hamlet                                     Thus conscience does make
 c:\br\quarto                                     in his mind with         
                                                                            
                                                                            
                                                                            
Arrows highlight entries, Enter selects (Esc:Cancel)
                                                                                
Remarks 
One kind of multiple-file search adds a list of all files that contain the 
Find text to the location list. (See: Searching Multiple Files.) 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                               <THE BOOKMARK> 

The bookmark also saves a location (like the location list), but only you can 
set it (PC-Browse never sets it). The bookmark remains in effect until you set 
a new one. 
 
To set the bookmark:

 Press Ctl Home. 
                                                                             
To return to the bookmark:

 Press Ctl End.


                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
                           <PASTING AND PRINTING>

You can paste selected text into your original application. You can also print 
selected text to your printer or to a file. Pasting into your application 
tells PC-Browse to "type" it just like it came from the keyboard. If you're 
pasting text into a word processor, make sure it is set for "insert" or 
"pushright" mode; otherwise, existing text may be overwritten. 
 
To paste or print with PC-Browse: 

1. Press F7 to paste, or Shf F7 to print.  You get the following menu: 

                                                                            
Esc:Cancel F4:Start marking F5:Marked text  F6:File name  F7:Window  F8:Page

2. Press one of the following keys: 

    Esc        Cancels the operation and returns to the PC-Browse Main Menu. 

    Up/Down    The up- and down-arrow keys move the blinking cursor to select 
    Arrow      lines for marking (this is the only time PC-Browse uses a 
               cursor). 

    F4         Starts marking lines, beginning with the cursor line. 

    F5         Pastes or prints the marked lines. 

    F6         Pastes or prints the name of the current file, with the drive 
               and path. 

    F7         Pastes or prints the contents of the current PC-Browse window. 

    F8         Pastes or prints the entire current page that you are viewing. 
               The page may extend in either direction beyond the window to 
               the page break. 

3. For a Paste, PC-Browse then asks when you want to paste the selected text: 

                                                                            
Esc:Cancel paste  F9:Paste now  F10:Paste when Paste-hotkey pressed 

4. Now you have three paste choices:

    Esc        Cancels the entire paste operation.

    F9         Exits PC-Browse and immediately pastes the text into your 
               application. You must be confident that your cursor is 
               correctly positioned. 

    F10        Exits PC-Browse and returns to your application. When you're 
               ready to paste in the text, press Shf Ctl F7 and the selected 
               text will be pasted. 

5. For a Print, PC-Browse asks if you want a form feed with the following menu: 

                                                                            
Esc:Cancel  F9:Send form feed at end (force page out)  F10:No form feed

6. Now you have three Print choices: 

    Esc        Cancels the entire print operation. 

    F9         Sends a form feed after printing. This advances continuous feed 
               paper to the next sheet, or ejects sheet-fed paper, including 
               laser printer paper. 

   F10         Does not send a form feed after printing. To print several 
               short items on one piece of paper, select F10 for all but the 
               last. On the last item select F9 to advance or eject the paper. 

7. For Paste or Print, if PC-Browse finds any PC-Write font characters (codes 
   below 32), it prompts you with: 

                                                                            
Esc:Cancel  Font characters found;  F9:No font chars  F10:Include font chars

8. Now you have three choices: 

    Esc        Cancels the entire operation. 

    F9         Skips over (does not include) all PC-Write font characters. 
               Select this if you're pasting to an application other than PC-
               Write, or if you don't want the font characters in a PC-Write 
               document. If you're pasting "hypertext" material with cross-
               references that use font characters as delimiters, this removes 
               them. Use this option for printing, unless you are printing to 
               a PC-Write file or these characters are printer escape 
               sequences. 

    F10        Includes the font characters. This pastes or prints the 
               characters exactly; they are not translated as in PC-Write. For 
               example, if the word "text" is in PC-Write bold font characters 
               (code 2), it sends the code 2's and the word "text" to the 
               printer. It does not print the word "text" in boldface. 

Remarks
You can turn off the form feed and font character prompts, opting instead for 
a setting of Always (always send form feed, always include font characters) or 
Never (never send a form feed, never include font characters). (See: 
Customizing.) 

A paste, by default, simulates pressing the Enter key at the end of each line. 
You can change this. For example, if the end-of-line character is a space, 
pasted text will word wrap in a word processing program. In a data base 
program, you might want to simulate the Tab key at the end of each line, since 
the Enter key might exit the data-entry screen. 

For some applications, including PC-Write versions before 3.03, a paste 
incorrectly simulates the Shf Enter key at the end of a line, instead of the 
Enter key. This is not serious. To correct this, you can customize PC-Browse 
to always include something called the piping delay, or to have each paste 
prompt you as to whether to include it. By default, the piping delay never 
occurs. If you have problems pasting, set this parameter to prompt you about 
including the piping delay, and try it both ways. If you include the piping 
delay, some applications may "hang" when you try to paste in text from PC-
Browse. 

Setting the <OUTPUT FILE NAME> 

You can set the name of the print output file. You can print to a disk file, 
or add to the end of a file, to accumulate text. You can also set a device 
name, such as LPT2. 

To change the output file name: 

1. Press Shf F6. The cursor jumps to the File prompt. 

2. To print the file on your printer, type PRN and press Enter. PRN is the DOS 
   name for the printer. (PC-Browse also sends output to the printer if 
   there's no text in this field.) 

   To send the output to a file, type the name of the output file. If the file 
   already exists, PC-Browse asks you if you want to replace it with the new 
   material, append the material to the end of the existing file, or cancel 
   the request entirely: 

                                                                            
File found;  Esc:Cancel  F9:Replace file  F10:Append to end

   Press F9 to replace the file, or F10 to add the material to the end of the 
   file. 

                   Press F10 To Go To the Table of Contents
                    Press F4 to return to the previous view
