'Scrambles and unscrambles files so that they may not be read.
'
' $INCLUDE: 'qb.bi'

DECLARE FUNCTION exists (filename$)
DECLARE SUB parsecommand ()

CONST YES = 1, NO = 0
DIM SHARED inregs AS RegTypeX, outregs AS RegTypeX
DIM SHARED arg$(10)

	parsecommand
	infile$ = arg$(1)
	IF infile$ = "" THEN GOTO help
	IF exists(infile$) = NO THEN GOTO nofind
	OPEN infile$ FOR INPUT AS #1
	outfile$ = "temp"
	OPEN outfile$ FOR OUTPUT AS #2
	GOSUB filename
	oldfile$ = UCASE$(file$) + ".OLD"
	SELECT CASE RIGHT$(arg$(2), 1)
		CASE "S": pro$ = "Scrambling"
		CASE "U": pro$ = "Unscrambling"
		CASE ELSE: GOTO badinstruct
	END SELECT
HEADER:
	COLOR 15: PRINT "SCRAMBLE "; : COLOR 7: PRINT "Fast file scambler"
	PRINT pro$; " "; infile$; ", making backup in "; oldfile$
	PRINT "Hit [Ctrl]+[Break] to terminate."
	GOSUB TIME
	PRINT "      Start time:"; newtime$
	PRINT " Processing Line: ";
	z = 0
	DO UNTIL EOF(1)
		z = z + 1
		LINE INPUT #1, l$
		LOCATE , 18: PRINT z;
		out$ = ""
		IF pro$ = "Scrambling" THEN GOSUB SCRAMBLE
		IF pro$ = "Unscrambling" THEN GOSUB UNSCRAMBLE
		out$ = l$
		PRINT #2, out$
	LOOP
FINISH:
	  CLOSE
	  IF exists(oldfile$) = YES THEN KILL oldfile$
	  NAME infile$ AS oldfile$
	  NAME outfile$ AS infile$
	  GOSUB TIME
	  PRINT
	  PRINT "     Finish time:"; newtime$
	  CLOSE
	  END
'*************************** GENERAL SUBROUTINES ******************************
SCRAMBLE:
	FOR i = 1 TO LEN(l$)
		IF ASC(MID$(l$, i, 1)) < 128 THEN
			MID$(l$, i, 1) = CHR$(ASC(MID$(l$, i, 1)) + 128)
		END IF
	NEXT
	RETURN
UNSCRAMBLE:
	FOR i = 1 TO LEN(l$)
		IF ASC(MID$(l$, i, 1)) > 127 THEN
			 MID$(l$, i, 1) = CHR$(ASC(MID$(l$, i, 1)) - 128)
		END IF
	NEXT
	RETURN
filename:
	p = INSTR(infile$, ".")
	IF p = 0 THEN
		file$ = infile$
	ELSE
		file$ = LEFT$(infile$, p - 1)
	END IF
	RETURN
TIME:
	  intime$ = TIME$                                     'current time changed
			hour$ = MID$(intime$, 1, 2)                     'to newtime$
			min$ = MID$(intime$, 4, 2)
			sec$ = MID$(intime$, 7, 2)
			hour = VAL(hour$)
				  IF hour < 12 THEN ampm$ = "am" ELSE ampm$ = "pm"
				  IF hour > 12 THEN hour = hour - 12
			hour$ = STR$(hour)
	  newtime$ = hour$ + ":" + min$ + ":" + sec$ + " " + ampm$
	  RETURN
'****************************** HELP AND ERROR ROUTINES ***********************
help:
	  PRINT " "
	  PRINT "SCRAMBLE scrambles ASCII files for file security."
	  PRINT "(c)1990 David A. Wesson"
	  PRINT " "
	  PRINT "Syntax: SCRAMBLE [d:]oldfile  /S or /U"
	  PRINT " where  oldfile = original file [drive optional]"
	  PRINT "           /S   = SCRAMBLE file"
	  PRINT "           /U   = UNSCRAMBLE file"
	  PRINT ""
	  PRINT "NOTE: A backup file of the original is made named filename.OLD"
	  END
nofind:
	  PRINT "ERROR: No file by that name found."
	  GOTO help
badfile:
	  PRINT "ERROR: Duplicate or missing filename."
	  GOTO help
badinstruct:
	  PRINT "ERROR: Bad or missing instruction."
	  GOTO help

FUNCTION exists (search$)
	 savefile$ = search$
	 inregs.ax = &H4E00
	 inregs.cx = 1     '3 for hidden
	 search$ = search$ + CHR$(0)
	 inregs.dx = SADD(search$)
	 inregs.ds = -1
	 CALL INTERRUPTX(&H21, inregs, outregs)
	 IF (outregs.flags AND 1) = 1 THEN
			exists = NO
	 ELSE
			exists = YES
	 END IF
	 search$ = savefile$
END FUNCTION

SUB parsecommand
	  inline$ = COMMAND$
	  word = 1
	  FOR x = 1 TO LEN(inline$)
			y$ = MID$(inline$, x, 1)
			IF ASC(y$) = 32 THEN
				IF arg$(word) <> "" THEN word = word + 1
			ELSE
				arg$(word) = arg$(word) + y$
			END IF
	  NEXT x
END SUB

