;**************************************************************
;*                                                            *
;*          Digitized Voice Programmer's Toolkit              *
;*          ------------------------------------              *
;*                                                            *
;*            Example memory-resident program                 *
;*                                                            *
;*          Copyright (c) 1989, Farpoint Software             *
;*                                                            *
;*                                                            *
;*  This program monitors the state of the left shift key     *
;*  bit at absolute address 417h (bit 1). Upon detecting a    *
;*  zero to one transition of this bit, a voice announcement  *
;*  is initiated in the background.                           *
;*                                                            *
;**************************************************************

.286
.MODEL LARGE
DOSSEG

shift_mask equ	02h

extrn	PVOICE_INIT:far
extrn	PVOICE_START:far
extrn	PVOICE_STATUS:far

;------------------------------------------------

;declare the VDATA segment here as well as in TSRVM.ASM
; so that the pointers to the beginning and end of the
; voice data can be properly accessed

VDATA	segment	public 'VDATA'

extrn	_EVMSG:byte
extrn	_EVMSGLEN:byte

VDATA	ends

;------------------------------------------------

.STACK	256

;------------------------------------------------

.DATA

count	dd	0
index	dd	0
pspseg	dw	0
prev	db	0

;------------------------------------------------

.CODE
	assume	ds:DGROUP

old_1C	dd	0	;this is in the code segment so
			; that we can jump to the original
			; user timer tick routine without
			; inconvenient messing with the stack

; - - - - - - - - - - - - - - - - - - - - - - - -

;this is the user timer tick interrupt routine

shift_check	proc	far

	push	ds	;save all registers
	push	es
	pusha

	mov	ax,DGROUP
	mov	ds,ax

	mov	ax,40h
	mov	es,ax
	mov	al,es:[17h]	;address at which shift state is kept
	and	al,shift_mask
	cmp	al,prev			;has the bit changed?
	je	shift_check_exit
	mov	prev,al
	cmp	al,shift_mask		;is it now a 1?
	jne	shift_check_exit

;left shift has been pressed
;are we still playing message from last press?

	push	ds
	push	offset count
	push	ds
	push	offset index
	call	PVOICE_STATUS
	or	ax,ax
	jnz	shift_check_exit

;trigger voice message playback

	push	VDATA			;block address
	push	offset _EVMSG

	mov	ax,offset _EVMSGLEN
	sub	ax,offset _EVMSG
	push	0			;block	length
	push	ax

	push	0			;file read flag (MUST be zero!)

	push	0			;handle

	push	0			;data length
	push	ax

	push	0			;start position
	push	0

	call	PVOICE_START		;do it

shift_check_exit:
	popa		;restore all registers
	pop	es
	pop	ds
	jmp	old_1C	;chain to previous holder of this vector

shift_check	endp

; - - - - - - - - - - - - - - - - - - - - - - - -

;Begin execution here

start:	mov	ax,DGROUP	;set segment registers
	mov	ds,ax
	mov	ax,es
	mov	pspseg,ax	;save PSP segment for later

;install voice playback routines

	call	PVOICE_INIT

;get the original user timer tick vector

	mov	ax,351Ch
	int	21h
	mov	word ptr old_1C,bx
	mov	word ptr old_1C+2,es

;set the vector to point to our routine

	push	ds
	lea	dx,shift_check
	mov	ax,cs
	mov	ds,ax
	mov	ax,251Ch
	int	21h
	pop	ds

;terminate and stay resident

	mov	dx,ss		;DOSSEG forces stack to last segment
	sub	dx,pspseg	;compute amout of memory this occupies
	mov	ax,3100h	;terminate and stay resident
	int	21h

	end	start
