/*
    Example code that uses CT-VOICE.DRV to access the Soundblaster
    DAC channel.
*/

#include <stdio.h>
#include <alloc.h>
#include <dos.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>

char far *driver_mem = NULL;
void far (*driver)(void) = NULL;

void LoadDriver(void)
{
    FILE *f;
    long length;
    char *sp;
    char sn[129];

    strcpy(sn,"");
    sp = getenv("SOUND");
    if(sp)
    {
        strcpy(sn,sp);
        if(sn[strlen(sn)-1] != '\\')
            strcat(sn,"\\");
    }
    strcat(sn,"drv\\CT-VOICE.DRV");

    f = fopen(sn,"rb");
    if(!f)
        return;
    length = filelength(fileno(f));

    driver_mem = (char far *)malloc((int)length + 16);
    if(FP_SEG(driver_mem) != 0)
        driver = MK_FP(FP_SEG(driver_mem)+1,0);
    else
        driver = driver_mem;

    fread(driver,1,(int)length,f);

    fclose(f);
}

int GetVersion(void)
{
    _BX = 0;
    (*driver)();
    return _AX;
}

void SetIOAddr(int base)
{
    _BX = 1;
    _AX = base;
    (*driver)();
}

void SetIRQ(int irq)
{
    _BX = 2;
    _AX = irq;
    (*driver)();
}

int InitialiseDriver(void)
{
    _BX = 3;
    (*driver)();
    return _AX;
}

void UninstallDriver(void)
{
    _BX = 9;
    (*driver)();
}

void SpeakerOnOff(int onoff)
{
    _BX = 4;
    _AX = onoff & 0x0001;
    (*driver)();
}

void SetStatusWord(unsigned int *addr)
{
    _BX = 5;
    _ES = FP_SEG(addr);
    _DI = FP_OFF(addr);
    (*driver)();
}

void OutputVoice(char *buffer)
{
    _BX = 6;
    _ES = FP_SEG(buffer);
    _DI = FP_OFF(buffer);
    (*driver)();
}

void InputVoice(int sample_rate, char *buffer, long length)
{
    _BX = 7;
    _AX = sample_rate;
    _ES = FP_SEG(buffer);
    _DI = FP_OFF(buffer);
    _DX = (unsigned)(length >> 16);
    _CX = (unsigned)(length & 0x0000ffff);
    (*driver)();
}

void StopVoiceProcess(void)
{
    _BX = 8;
    (*driver)();
}

int PauseOutputVoice(void)
{
    _BX = 10;
    (*driver)();
    return _AX;
}

int ContinueOutputVoice(void)
{
    _BX = 11;
    (*driver)();
    return _AX;
}

char *LoadVOC(char *name)
{
    FILE *f;
    char *buf;
    long length;

    f = fopen(name,"rb");
    if(!f)
        return NULL;

    length = filelength(fileno(f)) - 0x1a;

    buf = (char *)malloc((int)length);
    fseek(f,0x1a,SEEK_SET);
    fread(buf,1,length,f);

    fclose(f);
    return buf;
}

void main(int argc, char *argv[])
{
    char *b;
    int status;

    LoadDriver();
    if(driver == NULL)
    {
        printf("Could not load CT-VOICE.DRV\n");
        exit(1);
    }

    printf("Voice version %d\n",GetVersion());

    if(InitialiseDriver())
    {
        printf("Could not initialise driver.\n");
        exit(1);
    }
    SetStatusWord(&status);

    b = LoadVOC(argv[1]);

    OutputVoice(b);

    while(status)
        ;

    free(b);

    UninstallDriver();

    free(driver_mem);

    exit(0);
}
