
{ Functions and subroutines for use with the PC Mouse.


   Converted to TP4 unit by Rowan McKenzie  5/3/89 from Turbmous.pas}


Unit turbmous;

Interface


Uses dos;

Function MsMouse : Boolean;
Procedure Reset_mouse;            { resets mouse internal variables }
Procedure Show_mouse;             { displays the mouse cursor on the screen }
Procedure Hide_mouse;             { Hides the mouse cursor on the screen }
Procedure Get_mouse_status(Var m2, m3, m4 : Integer);
Procedure Put_mouse(x, y : Integer);
Procedure Get_mouse_button_pressed(Var m1, m2, m3, m4 : Integer);
Procedure Get_mouse_button_released(Var m1, m2, m3, m4 : Integer);
Procedure Set_mouse_X_range(Min, Max : Integer);
Procedure Set_mouse_Y_range(Min, Max : Integer);
Procedure Set_Graphics_Icon(Var xspot, yspot, icon_pointer : Integer);
Procedure Set_text_cursor(cursor_type, start, stop : Integer);
Procedure Mouse_motion(Var xcounter, ycounter : Integer);
Procedure mouse_mickeys(x, y : Integer);
Procedure mouse_DST(mickeys : Integer);

Implementation

  Function MsMouse : Boolean;

  Var
    MouseR         : registers;

  Begin
    mouser.ax:=0;
    intr($33,mouser);
    msmouse:=(mouser.ax<>0);
  End;                            { MsMouse }


  Procedure Reset_mouse;          { resets mouse internal variables }

  Var
    MouseR         : registers;

  Begin
    MouseR.ax := 0;
    intr($33, MouseR);
  End;


  Procedure Show_mouse;           { displays the mouse cursor on the screen }

  Var
    MouseR         : registers;

  Begin
    MouseR.ax := 1;
    intr($33, MouseR);
  End;


  Procedure Hide_mouse;           { Hides the mouse cursor on the screen }

  Var
    MouseR         : registers;

  Begin
    MouseR.ax := 2;
    intr($33, MouseR);
  End;


  Procedure Get_mouse_status(Var m2, m3, m4 : Integer);

  Var
    MouseR         : registers;

  Begin
    MouseR.ax := 3;
    intr($33, MouseR);
    m2 := MouseR.bx;
    m3 := MouseR.cx;
    m4 := MouseR.dx;
  End;


  Procedure Put_mouse(x, y : Integer);

  Var
    MouseR         : registers;

  Begin
    MouseR.ax := 4;
    MouseR.cx := x;
    MouseR.dx := y;
    intr($33, MouseR);
  End;


  Procedure Get_mouse_button_pressed(Var m1, m2, m3, m4 : Integer);

  Var
    MouseR         : registers;

  Begin
    MouseR.ax := 5;
    MouseR.bx := m2;
    intr($33, MouseR);
    m1 := MouseR.ax;
    m2 := MouseR.bx;
    m3 := MouseR.cx;
    m4 := MouseR.dx;
  End;


  Procedure Get_mouse_button_released(Var m1, m2, m3, m4 : Integer);

  Var
    MouseR         : registers;

  Begin
    MouseR.ax := 6;
    MouseR.bx := m2;
    intr($33, MouseR);
    m1 := MouseR.ax;
    m2 := MouseR.bx;
    m3 := MouseR.cx;
    m4 := MouseR.dx;
  End;


  Procedure Set_mouse_X_range(Min, Max : Integer);

  Var
    MouseR         : registers;

  Begin
    MouseR.ax := 7;
    MouseR.cx := Min;
    MouseR.dx := Max;
    intr($33, MouseR);
  End;


  Procedure Set_mouse_Y_range(Min, Max : Integer);

  Var
    MouseR         : registers;

  Begin
    MouseR.ax := 8;
    MouseR.cx := Min;
    MouseR.dx := Max;
    intr($33, MouseR);
  End;


  Procedure Set_Graphics_Icon(Var xspot, yspot, icon_pointer : Integer);

    { cga mode only}

  Var
    MouseR         : registers;

  Begin
    MouseR.ax := 9;
    MouseR.bx := xspot;
    MouseR.cx := yspot;
    MouseR.dx := icon_pointer;
    intr($33, MouseR);
  End;


  Procedure Set_text_cursor(cursor_type, start, stop : Integer);

  Var
    MouseR         : registers;

  Begin
    MouseR.ax := 10;
    MouseR.bx := cursor_type;
    MouseR.cx := start;
    MouseR.dx := stop;
    intr($33, MouseR);
  End;


  Procedure Mouse_motion(Var xcounter, ycounter : Integer);

  Var
    MouseR         : registers;

  Begin
    MouseR.ax := 11;
    intr($33, MouseR);
    xcounter := MouseR.cx;
    ycounter := MouseR.dx;
  End;


  Procedure mouse_mickeys(x, y : Integer);

  Var
    MouseR         : registers;

  Begin
    MouseR.ax := 15;
    MouseR.cx := x;
    MouseR.dx := y;
    intr($33, MouseR);
  End;


  Procedure mouse_DST(mickeys : Integer);

  Var
    MouseR         : registers;

  Begin
    MouseR.ax := 19;
    MouseR.dx := mickeys;
    intr($33, MouseR);
  End;

End.
