;RM82TS8,16,24,32,40,48
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

;===========================================================================
;DECLARE FUNCTION SCN2BUFF  ;put text screen in buffer
;DECLARE FUNCTION BUFF2SCN  ;get text screen from buffer
;
; Allows movement of text screens, page 0 to and from a buffer.
; Modified to handle a CGA display so will NOT cause SNOW on a CGA
;
; Handles only 80*25 displays. Will not crash on 80*43 or 80*50 just wont
;	save the entire display.
;
; Storage in Code Segment used to save space in DGROUP, makes DATA near
; without using up the limited amount of DGROUP space.  However prevents
; use of program in OS/2 which prohibits any change to CodeSeg values.
;===========================================================================

DOSSEG
.MODEL MEDIUM

        PUBLIC   SCN2BUFF, BUFF2SCN

.data
	;external data so all video routines can access
	EVEN
	EXTRN  B$DVIDEOSEG:WORD
	EXTRN  B$DVIDEOPORT:WORD
	EXTRN  B$DVIDEOINSTL:BYTE
.code
 EXTRN   Get_Adapter:FAR
 INCLUDE  NOWAIT.INC      ;all the video common macros
;------------------------------Data Area----------------------------------
	EVEN            ;speed up access on an 80286,8086 machine
	BUFF            DW      2000 DUP(?)

EVEN
SCN2BUFF   PROC    FAR
	Push            BP             ;Save current display in the buffer
	Push            DS
	Push            SI
	Push            DI

        Assume          DS:@data

	Cmp             B$DVIDEOINSTL,1
	JE              Skip_Ahead
	Call 		Get_Adapter      ;get display information

Skip_Ahead:

	Mov		DX,B$DVIDEOPORT  ;DX =  VIDEOPORT address or 0
        Mov             AX,CS            ;point ES to CS
	Mov             ES,AX

	;have to be finished with stack or .data before can change DS
        Mov             DS,B$DVIDEOSEG ;DS points to video buffer

	;MUST KEEP THESE TO USE OFFSET RELATIVE TO THE CODE SEGMENT
	Assume		DS:NOTHING, ES:NOTHING

        Mov             DI,OFFSET CS:BUFF
	Xor             SI,SI          ;offset of display page 0

	; Move 4,000 bytes between display and the buffer  BUFF
        Cld                            ;all data moves below will be forward
	Mov             CX,2000        ;load counter (2000 words = 4000 bytes)
        Or              DL,DL          ;monochrome or EGA (is DL=0)?
	JZ              Mono           ;yes, skip over the retrace stuff

EVEN
CGA_Loop:
        CLI                            ;prevent interrupts
	Wait_CGA_Retrace               ;run CGA retrace macro
	Movsw                          ;move the data in one operation
	STI                            ;allow interrupts again
	Loop            CGA_Loop       ;loop until done

	Jmp             Short Exit     ;skip over the mono routine and exit

Mono:
	Rep             Movsw          ;move the data in one operation
				       ;Move DS:SI to ES:DI
Exit:
	Pop             DI             ;restore stack
	Pop             SI
	Pop             DS

        Assume          DS:@data

	Pop             BP
	Ret
SCN2BUFF   ENDP

;===========================================================================
; Restores saved buffer to screen
;===========================================================================

EVEN
BUFF2SCN   PROC    FAR
	Push            BP                ;Save registers
	Push            DS
	Push            SI
	Push            DI

        Assume          DS:@data

	Cmp             B$DVIDEOINSTL,1
	JE              skip_over
	Call 		Get_Adapter     ;get display information

skip_over:
        Mov             ES,B$DVIDEOSEG  ;ES points to video buffer
	Mov             DX,B$DVIDEOPORT ;DX contains B$DVIDEOPORT address or 0

	Mov             AX,CS           ;set DS to code segment
	Mov             DS,AX

        ;MUST KEEP THESE TO USE OFFSET RELATIVE TO THE CODE SEGMENT
	Assume		DS:NOTHING, ES:NOTHING

	Mov             SI, OFFSET CS:BUFF
	Xor             DI,DI        ;offset on screen page 0

	Mov             CX, 2000     ;load counter (2000 words = 4000 bytes)
	Cld                          ;all data moves below will be forward
	Or              DL,DL        ;monochrome or EGA (is DL = 0)?
	JZ              Mono1        ;yes, skip over the retrace stuff

EVEN
CGA1:

	CLI                          ;prevent interrupts
	Wait_CGA_Retrace             ;run CGA retrace macro
	Movsw                        ;move data by words  DS:SI to ES:DI
	STI                          ;allow interrupts again
	Loop            CGA1         ;loop until done
	Jmp             Short Exit1  ;skip over the mono routine and exit

Mono1:
	Rep             Movsw        ;move the data in one operation
				     ;Move DS:SI to ES:DI
Exit1:
	Pop             DI           ;restore stack
	Pop             SI
	Pop             DS

        Assume          DS:@data

	Pop             BP
	Ret
BUFF2SCN   ENDP
END
