;RM82TS8,16,24,32,40,48,56,64
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================


DOSSEG
.model medium, Basic
.data
	EXTRN  B$DVIDEOINSTL:BYTE       ; tell other routines
					; that display has changed
.code

;============================================================================
; DECLARE SUB HERCMODE (BYVAL Mode%)
; CALL HERCMODE (Mode%)
; Input:
;       Mode =  0, Sets a Herc display to half-mode, so it can use a CGA
;       Mode <> 0, Sets a Herc display to full-mode, can not use a CGA
; Does not test for existence of Herc display
;============================================================================
EVEN
HERCMODE Proc FAR BASIC, MODE:WORD 
	Mov	BL,3		; assume will be Full mode
	Mov	AX,MODE		; read mode
	OR	AL,AL		; is MODE = 0?
	JNZ	Start		; no so jump ahead
	Mov	BL,1		; else select half mode
Start:
	Mov	AL,BL		; get value from BL
	Mov	DX,03BFh	; HERC Port address
	Out	DX,Al		; send it to HERC
	;Mov    AX,7            ; mode change not necessary
	;Int    10h             ; unless want to clear display
	Ret			; MASM will remove the one parameter
HERCMODE ENDP

;============================================================================
; DECLARE SUB SWAPCOLOR ()
; CALL SWAPCOLOR
; Purpose:
;         If have a CGA and a MONO display, this makes the CGA active
; Note:
;         Does not test if have either CGA or MONO installed
; Side Effect: Display Cleared
;============================================================================

EVEN
SWAPCOLOR Proc FAR BASIC
	Xor	AX,AX
	Mov     B$DVIDEOINSTL,AL        ; tell video routines that display
					; has changed
	Mov	ES,AX			; set ES to BIOS ram
	And     Byte Ptr ES:[0410h],11001111b ; clear CRT type equipment word
	Or      Byte Ptr ES:[0410h],00100000b ; set 80 col. CGA
	Mov	AX,3			; reset video mode as that resets
	Int	10h			; internal parameters
	Ret
SWAPCOLOR ENDP

;============================================================================
; DECLARE SUB SWAPMONO ()
; CALL SWAPMONO
; Purpose:
;         If have a CGA and a MONO display, this makes the MONO active
; Note:
;         Does not test if have either CGA or MONO installed
; Side Effect: Display Cleared
;============================================================================

EVEN
SWAPMONO Proc FAR BASIC
	Xor	AX,AX
	Mov     B$DVIDEOINSTL,AL        ; tell video routines that display
					; has changed
	Mov     ES,AX                   ; set ES to BIOS ram
	And     Byte Ptr ES:[0410h],11001111b ; clear CRT type equipment word
	Or      Byte Ptr ES:[0410h],00110000b ; set mono display
	Mov	AX,7			; reset video mode as that resets
	Int	10h			; internal parameters
	Call    FAR PTR DUALDISPLAY     ; see if we have dual displays
	Or      AX,AX                   ; is AX = 0, (i.e. no dual displays)
	JZ      Finis2                  ; if only one display, skip ahead
	Xor     AX,AX                   ; set any HERC to compatible mode
	Push    AX                      ; Push a zero on the stack
	Call    FAR PTR HERCMODE        ; select HERC compatible mode
					; should have no effect on other
					; displays
Finis2:
	Ret
SWAPMONO ENDP

;============================================================================
; DECLARE FUNCTION FINDMONO% ()
; Returns:
;       True  (<> 0)  if mono CRT found, even if not active
;       False (0)     if mono CRT not found
;============================================================================

EVEN
FINDMONO proc BASIC
	Mov     DX,03B4h                ; mono CRTC index port
	JMP     SHORT Main
FINDMONO ENDP

;============================================================================
; DECLARE FUNCTION FINDCOLOR% ()
; Returns:
;       True  (<> 0)  if color CRT found, even if not active
;       False (0)     if color CRT not found
;============================================================================

EVEN
FINDCOLOR Proc  BASIC
	Mov     DX,03D4h                ; color CRTC index port
Main::
	Mov     BX,-1                   ; assume will find display
	Mov     AL,0Eh                  ; load cursor location high address
	Out     DX,AL                   ; write to index port
	INC     DX                      ; increment to port 03x5
	IN      AL,DX                   ; read cursor location low
	Mov     AH,AL                   ; store in AH
	Mov     AL,71h                  ; select impossible value
	Out     DX,AL                   ; write it
	Jmp     $+2                     ; allow delay for slow ports
	Jmp     $+2                     ; allow delay for slow ports
	Jmp     $+2                     ; allow delay for slow ports
	Jmp     $+2                     ; allow delay for slow ports
	Jmp     $+2                     ; allow delay for slow ports
	Jmp     $+2                     ; allow delay for slow ports
	Jmp     $+2                     ; allow delay for slow ports
	Jmp     $+2                     ; allow delay for slow ports
	In      AL,DX                   ; read value we just wrote
	XCHG    AH,AL                   ; get back original value
	Jmp     $+2                     ; allow delay for slow ports
	Out     DX,AL                   ; write it
	CMP     AH,71h                  ; did we get back 71h?
	JE      Finis                   ; yes, so CRT is there
	Xor     BX,BX                   ; report CRT not there

Finis:
	Mov     AX,BX                   ; store result in AX
	Xor     DX,DX                   ; so can be called long
	RET
FINDCOLOR   ENDP

;============================================================================
; DECLARE FUNCTION DUALDISPLAY% ()
; Returns:
;       True  (<> 0)  if two dislays found
;       False (0)     if only one CRT found
;============================================================================

EVEN
DUALDISPLAY Proc BASIC USES SI
	Xor	AX,AX
	Mov	SI,AX			; clear SI and use as counter
	Call    FAR PTR FINDCOLOR       ; see if color CRT installed
	Or	AX,AX			; if AX = 0 then no color
	JZ	Next_Display
	Inc	SI			; report color display found
Next_Display:
	Call    FAR PTR FINDMONO        ; see if mono CRT installed
	Or	AX,AX
	JZ	Wrap_up
	Inc	SI			; report mono CRT found
Wrap_up:
	Xor	AX,AX			; assume only one CRT
	Cmp	SI,2			; were two found?
	JNE	Finis			; nope
	Mov	AX,-1			; report yes
Finis:
	Xor	DX,DX			; so can be called long
	Ret
DUALDISPLAY ENDP
END
