;RM82TS8,16,24,32,40,48,56,64
; Updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;           All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

;===========================================================================
; Important information for my set of video routines
;===========================================================================

DOSSEG
.MODEL MEDIUM
PUBLIC B$DVIDEOINSTL, B$DVIDEOSEG, B$DVIDEOPORT, B$DVIDEODI, Get_Adapter, SET_DI

.DATA
	EVEN
	B$DVIDEOSEG     DW      0       ;current video segment
	B$DVIDEOPORT	DW	0	;retrace port if CGA
	B$DVIDEODI      DW      0       ;current offset inside video segment
	B$DVIDEOINSTL   DB      0       ;records if Get_Adapter run
.code

INCLUDE NOWAIT.INC

Copyright       DB    13,10,'Copyright Copr. (C) 1990 Sidney J. Kelly',13,10
Copyright1      DB    'All Rights Reserved',13,10,26

;===========================================================================
;Purpose:
;	   Called as a subroutine to find display adapter attached
;          sets the above information segment to reflect that information
;Destroys: Nothing
;Returns:  Nothing
;	   Above Data Area Filed
;Routine assumes that if you have an EGA or VGA, it is active.
;  This could produce snow if EGA were a secondary display acting as
;  a mono monitor, with CGA active. Not done because routine would become
;  bloated to handle unusual case.
;===========================================================================

EVEN
Get_Adapter	PROC	FAR
	Push    BP            ;save everthing we use
	Push	AX
	Push	BX
	Push	DX
	Push	ES

	Xor	DX,DX         ;zero out DX  (also sets DX for no CGA)
	Mov	ES,DX         ;put the zero in ES, to look at low memory
	Mov	BX,0B000h     ;assume the Mono screen segment
	Mov	AL,ES:[463h]  ;look at the video controller port address
	Cmp	AL,0B4h       ;is it mono?
	JZ 	All_Done      ;yes, skip over adding 800h to video segment
	Add	BX,800h       ;no, adjust BX for a color monitor
	Push	BX            ;and save it because the EGA test destroys BX

	Mov	AH,12h        ;specify EGA BIOS EGA special function service
	Mov	BL,10h        ;request EGA info
	Int	10h           ;call the BIOS
	Cmp	BL,10h        ;if BL is still 10h, there's no EGA
	JNE	Color_EGA     ;it is an EGA, skip ahead
	Mov	DX,3DAh       ;not EGA, specify port to check for retrace

Color_EGA:
	Pop	BX            ;get the video segment again

All_Done:
	Mov	B$DVIDEOSEG,   BX  ;Store the information we found
	Mov	B$DVIDEOPORT,  DX
	Mov	B$DVIDEOINSTL, 1   ;Note that routine is installed

        Pop	ES
        Pop	DX
        Pop	BX
	Pop	AX
	Pop	BP
	Ret
Get_Adapter ENDP

;=============================================================================
;Call SET_DI
; A public subroutine that fixes DI 
; Setup for 80 column display because that is all QBASIC supports
;
; Input:     DH = Row :  DL = Column
; Output:    DI = Memory Offset
; Destroys:  CX
;=============================================================================

EVEN
SET_DI	PROC FAR
	Set_DI_Offset      ;call macro to find video seg offset in DI
	Ret
SET_DI	ENDP
END
