   
    REM $INCLUDE: 'SVGAQB10.BI'
    REM $INCLUDE: 'SVGADEMO.BI'

REM $DYNAMIC
    SUB DOBLOCK (RET$, MAXX, MAXY)

    MYPI! = ATN(1) * 4

    '*************************************************************************
    '* SET UP THE TITLE
    '*************************************************************************
    TITLE$ = "DEMO 5: Block functions and Sprites"
    PALSET PAL, 0, 255
   
    '*************************************************************************
    '* SHOW BLOCK GET (DRAW SOME CIRCLES AND "GET A CHUNK OF THEM")
    '*************************************************************************
    FILLSCREEN (0)
    SETVIEW 0, 0, MAXX, MAXY
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
    A$ = "BLKGET (X1,Y1,X2,Y2,GfxBlockArray)"
    DRWSTRING 1, 7, 0, A$, 10, 16
    Colr = 16
    FOR I = 0 TO MAXX \ 2
        DRWCIRCLE 1, Colr, MAXX \ 4 + I, MAXY \ 2, MAXY \ 5
        Colr = Colr + 2
        IF Colr > 255 THEN
            Colr = 16
        END IF
    NEXT I
    XINC = MAXX \ 20
    YINC = MAXY \ 20
    X1 = MAXX \ 2 - XINC
    Y1 = MAXY \ 2 - YINC
    X2 = MAXX \ 2 + XINC
    Y2 = MAXY \ 2 + YINC
    DRWBOX 1, 0, X1, Y1, X2, Y2
    BLKGET X1, Y1, X2, Y2, GFXBLK(0)
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        FILLSCREEN (0)
        EXIT SUB
    END IF

    '*************************************************************************
    '* SHOW BLOCK PUT (PUT THE "CHUNKS" RANDOMLY AROUND THE SCREEN)
    '*************************************************************************
    A$ = "BLKPUT (Mode,X,Y,GfxBlockArray)   "
    DRWSTRING 1, 7, 0, A$, 10, 16
    XINC = MAXX \ 10
    YINC = MAXY \ 10
    SETVIEW 0, 32, MAXX, MAXY
    FOR I = 0 TO MAXX \ 2
        X = (MAXX + XINC) * RND - XINC
        Y = (MAXY + YINC) * RND - YINC
        BLKPUT 1, X, Y, GFXBLK(0)
    NEXT I
    GETKEY RET$
    SETVIEW 0, 0, MAXX, MAXY
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        FILLSCREEN (0)
        EXIT SUB
    END IF

    '*************************************************************************
    '* SHOW SPRITE GET/PUT
    '*************************************************************************
    FILLSCREEN (0)
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
    A$ = "SPRITEPUT(TranSColr,X,Y,SpriteArray)"
    DRWSTRING 1, 7, 0, A$, 10, 16
    A$ = "SPRITEGAP(TranSColr,X,Y,SpriteArray,BackGroundArray)"
    DRWSTRING 1, 7, 0, A$, 10, 32

    SETVIEW 0, 50, MAXX, MAXY
    Colr = 16
    X1 = 10
    X2 = MAXX - 9
    Y1 = 35
    Y2 = MAXY - 9
    I = 0
    PALSET PAL, 16, 255
    WHILE Y1 + I < Y2 - I
        DRWBOX 1, Colr, X1 + I, Y1 + I, X2 - I, Y2 - I
        Colr = Colr + 1
        IF Colr > 255 THEN
            Colr = 16
        END IF
        I = I + 1
    WEND
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        FILLSCREEN (0)
        PALSET PAL, 16, 255
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF
    CNTX = (MAXX \ 2) - 8
    CNTY = ((MAXY - 9) \ 2) - 8
    J = 0
    FOR DEG = 0 TO 360 STEP 2
        RAD! = (DEG * MYPI! / 180)
        X = CNTX + SIN(RAD!) * MAXY \ 4
        Y = CNTY + COS(RAD!) * MAXY \ 4
        SPRITEGAP 0, X, Y, SPRITEDATA(J), SPRITEBKGND(0)
        SDELAY 3
        SPRITEPUT 0, X, Y, SPRITEBKGND(0)
        J = J + 130
        IF J > 910 THEN
            J = 0
        END IF
    NEXT DEG

    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        FILLSCREEN (0)
        PALSET PAL, 16, 255
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF
    



    END SUB

    SUB DOCLIP (RET$, MAXX, MAXY)

    '*************************************************************************
    '* SET UP AND SHOW THE THE TITLE
    '*************************************************************************
    TITLE$ = "DEMO 2: Clipping capability"
    PALSET PAL2, 0, 255
   
    '*************************************************************************
    '* SET UP THE WINDOWS
    '*************************************************************************
    FILLSCREEN (0)
    SETVIEW 0, 0, MAXX, MAXY
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
    A$ = "All primatives automaticlly clip"
    DRWSTRING 1, 7, 0, A$, 10, 16

    WDTH = (MAXX + 1) / 2.25
    SPCINGX = ((MAXX + 1) - WDTH * 2) / 3
    HGTH = (MAXY + 1 - 35) / 2.25
    SPCINGY = ((MAXY + 1 - 35) - HGTH * 2) / 3
    XINC = WDTH * 1.5
    YINC = HGTH * 1.5
    XSUB = WDTH * .25
    YSUB = HGTH * .25


    B1X1 = SPCINGX
    B1X2 = B1X1 + WDTH
    B1Y1 = SPCINGY + 35
    B1Y2 = B1Y1 + HGTH
  
    B2X2 = MAXX - SPCINGX
    B2X1 = B2X2 - WDTH
    B2Y1 = SPCINGY + 35
    B2Y2 = B2Y1 + HGTH
  
    B3X2 = MAXX - SPCINGX
    B3X1 = B3X2 - WDTH
    B3Y2 = MAXY - SPCINGY
    B3Y1 = B3Y2 - HGTH
  
    B4X1 = SPCINGX
    B4X2 = B4X1 + WDTH
    B4Y2 = MAXY - SPCINGY
    B4Y1 = B4Y2 - HGTH

    DRWBOX 1, 15, B1X1, B1Y1, B1X2, B1Y2
    DRWBOX 1, 15, B2X1, B2Y1, B2X2, B2Y2
    DRWBOX 1, 15, B3X1, B3Y1, B3X2, B3Y2
    DRWBOX 1, 15, B4X1, B4Y1, B4X2, B4Y2

    B1X1 = B1X1 + 1
    B1Y1 = B1Y1 + 1
    B1X2 = B1X2 - 1
    B1Y2 = B1Y2 - 1
  
    B2X1 = B2X1 + 1
    B2Y1 = B2Y1 + 1
    B2X2 = B2X2 - 1
    B2Y2 = B2Y2 - 1
  
    B3X1 = B3X1 + 1
    B3Y1 = B3Y1 + 1
    B3X2 = B3X2 - 1
    B3Y2 = B3Y2 - 1

    B4X1 = B4X1 + 1
    B4Y1 = B4Y1 + 1
    B4X2 = B4X2 - 1
    B4Y2 = B4Y2 - 1

    Colr = 1

    '*************************************************************************
    '* SHOW THE CLIPPING
    '*************************************************************************
    FOR I = 0 TO MAXX \ 6
        FOR J = 1 TO 4
            SELECT CASE J
                CASE IS = 1
                    SETVIEW B1X1, B1Y1, B1X2, B1Y2
                    FOR K = 0 TO 4
                        X = B1X1 + RND * XINC - XSUB
                        Y = B1Y1 + RND * XINC - XSUB
                        DRWPOINT 1, Colr, X, Y
                        Colr = Colr + 1
                        IF Colr > 15 THEN
                            Colr = 1
                        END IF
                    NEXT K
                CASE IS = 2
                    SETVIEW B2X1, B2Y1, B2X2, B2Y2
                    X1 = B2X1 + RND * XINC - XSUB
                    Y1 = B2Y1 + RND * XINC - XSUB
                    X2 = B2X1 + RND * XINC - XSUB
                    Y2 = B2Y1 + RND * XINC - XSUB
                    DRWLINE 1, Colr, X1, Y1, X2, Y2
                    Colr = Colr + 1
                    IF Colr > 15 THEN
                        Colr = 1
                    END IF
                CASE IS = 3
                    SETVIEW B3X1, B3Y1, B3X2, B3Y2
                    X = B3X1 + RND * XINC - XSUB
                    Y = B3Y1 + RND * XINC - XSUB
                    RAD = RND * WDTH \ 2
                    DRWCIRCLE 1, Colr, X, Y, RAD
                    Colr = Colr + 1
                    IF Colr > 15 THEN
                        Colr = 1
                    END IF
                CASE IS = 4
                    SETVIEW B4X1, B4Y1, B4X2, B4Y2
                    X = B4X1 + RND * XINC - XSUB
                    Y = B4Y1 + RND * XINC - XSUB
                    RADX = RND * WDTH \ 2
                    RADY = RND * WDTH \ 2
                    DRWELLIPSE 1, Colr, X, Y, RADX, RADY
                    Colr = Colr + 1
                    IF Colr > 15 THEN
                        Colr = 1
                    END IF
            END SELECT
        NEXT J
    NEXT I
    SETVIEW 0, 0, MAXX, MAXY
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        EXIT SUB
    END IF
  
    END SUB

    SUB DOFILL (RET$, MAXX, MAXY)

    '*************************************************************************
    '* SET UP THE TITLE
    '*************************************************************************
    TITLE$ = "DEMO 3: Filling functions"
    PALSET PAL, 0, 255

    '*************************************************************************
    '* SHOW SCREEN FILL
    '*************************************************************************
    FILLSCREEN (10)
    SETVIEW 0, 0, MAXX, MAXY
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
    A$ = "FILLSCREEN (Color)"
    DRWSTRING 1, 7, 0, A$, 10, 16
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF
  
    '*************************************************************************
    '* SET UP WINDOWS AND SHOW VIEWPORT FILL
    '*************************************************************************
    FILLSCREEN (0)
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
    A$ = "FILLVIEW (Color)"
    DRWSTRING 1, 7, 0, A$, 10, 16
  
    WDTH = (MAXX + 1) / 2.25
    SPCINGX = ((MAXX + 1) - WDTH * 2) / 3
    HGTH = (MAXY + 1 - 35) / 2.25
    SPCINGY = ((MAXY + 1 - 35) - HGTH * 2) / 3
    XINC = WDTH * 1.5
    YINC = HGTH * 1.5
    XSUB = WDTH * .25
    YSUB = HGTH * .25
  
    B1X1 = SPCINGX
    B1X2 = B1X1 + WDTH
    B1Y1 = SPCINGY + 35
    B1Y2 = B1Y1 + HGTH
 
    B2X2 = MAXX - SPCINGX
    B2X1 = B2X2 - WDTH
    B2Y1 = SPCINGY + 35
    B2Y2 = B2Y1 + HGTH
 
    B3X2 = MAXX - SPCINGX
    B3X1 = B3X2 - WDTH
    B3Y2 = MAXY - SPCINGY
    B3Y1 = B3Y2 - HGTH
 
    B4X1 = SPCINGX
    B4X2 = B4X1 + WDTH
    B4Y2 = MAXY - SPCINGY
    B4Y1 = B4Y2 - HGTH

    DRWBOX 1, 15, B1X1, B1Y1, B1X2, B1Y2
    DRWBOX 1, 15, B2X1, B2Y1, B2X2, B2Y2
    DRWBOX 1, 15, B3X1, B3Y1, B3X2, B3Y2
    DRWBOX 1, 15, B4X1, B4Y1, B4X2, B4Y2

    B1X1 = B1X1 + 1
    B1Y1 = B1Y1 + 1
    B1X2 = B1X2 - 1
    B1Y2 = B1Y2 - 1
 
    B2X1 = B2X1 + 1
    B2Y1 = B2Y1 + 1
    B2X2 = B2X2 - 1
    B2Y2 = B2Y2 - 1
 
    B3X1 = B3X1 + 1
    B3Y1 = B3Y1 + 1
    B3X2 = B3X2 - 1
    B3Y2 = B3Y2 - 1

    B4X1 = B4X1 + 1
    B4Y1 = B4Y1 + 1
    B4X2 = B4X2 - 1
    B4Y2 = B4Y2 - 1

    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF
  
    SETVIEW B1X1, B1Y1, B1X2, B1Y2
    FILLVIEW (10)
    SETVIEW B2X1, B2Y1, B2X2, B2Y2
    FILLVIEW (12)
    SETVIEW B3X1, B3Y1, B3X2, B3Y2
    FILLVIEW (13)
    SETVIEW B4X1, B4Y1, B4X2, B4Y2
    FILLVIEW (14)
  
    SETVIEW 0, 0, MAXX, MAXY
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF

    '*************************************************************************
    '* SET UP WINDOW AND SHOW AREA FILL
    '*************************************************************************
    FILLSCREEN (0)
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
    A$ = "FILLAREA (Xseed,Yseed,BrdrCol,FilCol)"
    DRWSTRING 1, 7, 0, A$, 10, 16

    DRWBOX 1, 15, 5, 35, MAXX - 4, MAXY - 4
    SETVIEW 6, 36, MAXX - 5, MAXY - 5

    Colr = 1
    FOR I = 0 TO MAXX \ 10
        X = 50 + RND * (MAXX - 50)
        Y = 50 + RND * (MAXY - 50)
        RADX = 2 + RND * MAXX \ 20
        RADY = 2 + RND * MAXX \ 20
        DRWELLIPSE 1, Colr, X, Y, RADX, RADY
        Colr = Colr + 1
        IF Colr > 10 THEN
            Colr = 1
        END IF
    NEXT I
  
    FOR I = 0 TO MAXX \ 15
        X = 50 + RND * (MAXX - 50)
        Y = 50 + RND * (MAXY - 50)
        RADX = 2 + RND * MAXX \ 20
        RADY = 2 + RND * MAXX \ 20
        DRWELLIPSE 1, 12, X, Y, RADX, RADY
    NEXT I

    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF

    FILLAREA 7, 37, 12, 10

    GETKEY RET$
    SETVIEW 0, 0, MAXX, MAXY
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        EXIT SUB
    END IF

    '*************************************************************************
    '* SET UP WINDOW AND SHOW COLOR FILL
    '*************************************************************************
    FILLSCREEN (0)
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
    A$ = "FILLCOLOR (Xseed,Yseed,OldCol,FilCol)"
    DRWSTRING 1, 7, 0, A$, 10, 16

    DRWBOX 1, 15, 5, 35, MAXX - 4, MAXY - 4
    SETVIEW 6, 36, MAXX - 5, MAXY - 5

    Colr = 1
    FOR I = 0 TO MAXX \ 10
        X = 50 + RND * (MAXX - 50)
        Y = 50 + RND * (MAXY - 50)
        RADX = 2 + RND * MAXX \ 20
        RADY = 2 + RND * MAXX \ 20
        DRWELLIPSE 1, Colr, X, Y, RADX, RADY
        Colr = Colr + 1
        IF Colr > 10 THEN
            Colr = 1
        END IF
    NEXT I
   
    FOR I = 0 TO MAXX \ 15
        X = 50 + RND * (MAXX - 50)
        Y = 50 + RND * (MAXY - 50)
        RADX = 2 + RND * MAXX \ 20
        RADY = 2 + RND * MAXX \ 20
        DRWELLIPSE 1, 12, X, Y, RADX, RADY
    NEXT I
   
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF

    FILLCOLOR 7, 37, 0, 10
  
    SETVIEW 0, 0, MAXX, MAXY
    GETKEY RET$
 
    END SUB

    SUB DOPAL (RET$, MAXX, MAXY)

    '*************************************************************************
    '* SET UP THE TITLE
    '*************************************************************************
    TITLE$ = "DEMO 4: Palette functions"
    PALSET ORGPAL, 0, 255
   
    '*************************************************************************
    '* SHOW PALETTE SET/GET
    '*************************************************************************
    FILLSCREEN (0)
    SETVIEW 0, 0, MAXX, MAXY
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
    A$ = "PALGET (Palette$,FirstColr,LastColr) PALSET (Palette$,FirtColr,LastColr)"
    DRWSTRING 1, 7, 0, A$, 10, 16
    Colr = 16
    X1 = 10
    X2 = MAXX - 9
    Y1 = 35
    Y2 = MAXY - 9
    I = 0
    WHILE Y1 + I < Y2 - I
        DRWBOX 1, Colr, X1 + I, Y1 + I, X2 - I, Y2 - I
        Colr = Colr + 1
        IF Colr > 255 THEN
            Colr = 16
        END IF
        I = I + 1
    WEND
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        FILLSCREEN (0)
        PALSET PAL, 16, 255
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF
    PALSET PAL, 16, 255
  
    '*************************************************************************
    '* SHOW PALETTE AUTO FADE OUT/IN
    '*************************************************************************
    A$ = "PALIOAUTO (Palette$,FirstColr,LastColr,Speed)                           "
    DRWSTRING 1, 7, 0, A$, 10, 16
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF
    PALIOAUTO PAL, 16, 255, -2
    PALIOAUTO PAL, 16, 255, 2

    '*************************************************************************
    '* SHOW PALETTE AUTO FADE TO
    '*************************************************************************
    A$ = "PALCHGAUTO (Palette$,NewPalette$,FirstColr,LastColr,Speed)"
    DRWSTRING 1, 7, 0, A$, 10, 16
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF
    PALCHGAUTO PAL, PAL2, 16, 255, 2
    PALCHGAUTO PAL2, PAL, 16, 255, 2
  
    '*************************************************************************
    '* SHOW PALETTE ROTATE
    '*************************************************************************
    A$ = "PALROTATE (Palette$,FirstColr,LastColr,Shift)             "
    DRWSTRING 1, 7, 0, A$, 10, 16
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF
    FOR I = 0 TO 240
        PALROTATE PAL, 16, 255, 2
        PALGET PAL, 16, 255
    NEXT I
    FOR I = 0 TO 120
        PALROTATE PAL, 16, 255, -8
        PALGET PAL, 16, 255
    NEXT I
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF

    END SUB

    SUB DOPRIMS (RET$, MAXX, MAXY)
  
    '*************************************************************************
    '* SET UP THE THE TITLE
    '*************************************************************************
    TITLE$ = "DEMO 1: Primatives"
    PALSET PAL, 0, 255
  
    '*************************************************************************
    '* DRAW SOME POINTS
    '*************************************************************************
    FILLSCREEN (0)
    SETVIEW 0, 0, MAXX, MAXY
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
    A$ = "DRWPOINT (Mode,Color,X1,Y1,X2,Y2)"
    DRWSTRING 1, 7, 0, A$, 10, 18
    SETVIEW 0, 32, MAXX, MAXY
    Colr = 1
    NUMOF = MAXX * 2
    FOR A = 0 TO NUMOF
        X1 = RND * MAXX
        Y1 = RND * MAXY
        DRWPOINT 1, Colr, X1, Y1
        Colr = Colr + 1
        IF Colr > 15 THEN
            Colr = 1
        END IF
    NEXT A
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF
  
    '*************************************************************************
    '* DRAW SOME LINES
    '*************************************************************************
    SETVIEW 0, 0, MAXX, MAXY
    FILLSCREEN (0)
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
    A$ = "DRWLINE (Mode,Color,X1,Y1,X2,Y2)"
    DRWSTRING 1, 7, 0, A$, 10, 18
    SETVIEW 0, 32, MAXX, MAXY
    NUMOF = MAXX \ 6
    FOR A = 0 TO NUMOF
        X1 = RND * MAXX
        Y1 = RND * MAXY
        X2 = RND * MAXX
        Y2 = RND * MAXY
        DRWLINE 1, Colr, X1, Y1, X2, Y2
        Colr = Colr + 1
        IF Colr > 15 THEN
            Colr = 1
        END IF
    NEXT A
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF

    '*************************************************************************
    '* DRAW SOME BOXES
    '*************************************************************************
    SETVIEW 0, 0, MAXX, MAXY
    FILLSCREEN (0)
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
    A$ = "DRWBOX (Mode,Color,X1,Y1,X2,Y2)"
    DRWSTRING 1, 7, 0, A$, 10, 18
    SETVIEW 0, 32, MAXX, MAXY
    NUMOF = MAXX \ 10
    FOR A = 0 TO NUMOF
        X1 = RND * MAXX
        Y1 = RND * MAXY
        X2 = RND * MAXX
        Y2 = RND * MAXY
        DRWBOX 1, Colr, X1, Y1, X2, Y2
        Colr = Colr + 1
        IF Colr > 15 THEN
            Colr = 1
        END IF
    NEXT A
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF

    '*************************************************************************
    '* DRAW SOME CIRCLES
    '*************************************************************************
    SETVIEW 0, 0, MAXX, MAXY
    FILLSCREEN (0)
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
    A$ = "DRWCIRCLE (Mode,Color,Cx,Cy,Radius)"
    DRWSTRING 1, 7, 0, A$, 10, 18
    SETVIEW 0, 32, MAXX, MAXY
    NUMOF = MAXX \ 20
    MAXRAD = MAXX \ 2
    FOR A = 0 TO NUMOF
        X = RND * MAXX
        Y = RND * MAXY
        RAD = RND * MAXRAD
        DRWCIRCLE 1, Colr, X, Y, RAD
        Colr = Colr + 1
        IF Colr > 15 THEN
            Colr = 1
        END IF
    NEXT A
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF

    '*************************************************************************
    '* DRAW SOME ELLIPSES
    '*************************************************************************
    SETVIEW 0, 0, MAXX, MAXY
    FILLSCREEN (0)
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
    A$ = "DRWELLIPSE (Mode,Color,Cx,Cy,RadiusX,RadiusY)"
    DRWSTRING 1, 7, 0, A$, 10, 18
    SETVIEW 0, 32, MAXX, MAXY
    NUMOF = MAXX \ 20
    MAXRAD = MAXX \ 2
    FOR A = 0 TO NUMOF
        X = RND * MAXX
        Y = RND * MAXY + 35
        RADX = RND * MAXRAD
        RADY = RND * MAXRAD
        DRWELLIPSE 1, Colr, X, Y, RADX, RADY
        Colr = Colr + 1
        IF Colr > 15 THEN
            Colr = 1
        END IF
    NEXT A
    SETVIEW 0, 0, MAXX, MAXY
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        EXIT SUB
    END IF
  
    END SUB

    SUB DOSCROLL (RET$, MAXX, MAXY)

    
    '*************************************************************************
    '* SET UP THE TITLE
    '*************************************************************************
    TITLE$ = "DEMO 7: Scroll functions"
    PALSET PAL, 0, 255
    FILLSCREEN (0)
    SETVIEW 0, 0, MAXX, MAXY
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
   
    SPCNG = (MAXY - 32) \ 5
    SKIP = (INT((MAXX + 1) / 320 + .9) * 2) - 1
    NUM = SPCNG / 2 / SKIP
    IF SPCNG / 2 <> INT(SPCNG / 2) THEN
        SPCNG = SPCNG + 1
    END IF
    X1 = ((MAXX + 1) \ 2) - SPCNG
    Y1 = (((MAXY + 1 - 32) \ 2) + 32) - SPCNG
    X2 = ((MAXX + 1) \ 2) + SPCNG
    Y2 = (((MAXY + 1 - 32) \ 2) + 32) + SPCNG

    DRWBOX 1, 12, X1, Y1, X2, Y2
    X1 = X1 + 1
    Y1 = Y1 + 1
    X2 = X2 - 1
    Y2 = Y2 - 1
    Colr = 16
    TEXT$ = "TEXT text TEXT"
   
    '*************************************************************************
    '* SHOW SCROLLUP
    '*************************************************************************
    SETVIEW 0, 0, MAXX, MAXY
    A$ = "SCROLLUP (X1,Y1,X2,Y2,NumLines,FillColr)"
    DRWSTRING 1, 7, 0, A$, 10, 16
    SETVIEW X1, Y1, X2, Y2
    FILLVIEW (0)
    NUMOF = MAXX \ 10
    FOR A = 0 TO NUMOF
        X = RND * MAXX
        Y = RND * MAXY
        I = RND * MAXX
        J = RND * MAXY
        DRWLINE 1, Colr, X, Y, I, J
        Colr = Colr + 3
        IF Colr > 255 THEN
            Colr = 16
        END IF
    NEXT A
    DRWSTRING 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    DRWSTRINGLT 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    DRWSTRINGDN 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    DRWSTRINGRT 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF
    FOR A = 0 TO NUM
        SCROLLUP X1, Y1, X2, Y2, SKIP, 0   '* HERE IT IS!
    NEXT A
   
    '*************************************************************************
    '* SHOW SCROLLLT
    '*************************************************************************
    SETVIEW 0, 0, MAXX, MAXY
    A$ = "SCROLLLT (X1,Y1,X2,Y2,NumLines,FillColr)"
    DRWSTRING 1, 7, 0, A$, 10, 16
    SETVIEW X1, Y1, X2, Y2
    FILLVIEW (0)
    NUMOF = MAXX \ 10
    FOR A = 0 TO NUMOF
        X = RND * MAXX
        Y = RND * MAXY
        I = RND * MAXX
        J = RND * MAXY
        DRWLINE 1, Colr, X, Y, I, J
        Colr = Colr + 3
        IF Colr > 255 THEN
            Colr = 16
        END IF
    NEXT A
    DRWSTRING 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    DRWSTRINGLT 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    DRWSTRINGDN 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    DRWSTRINGRT 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF
    FOR A = 0 TO NUM
        SCROLLLT X1, Y1, X2, Y2, SKIP, 0   '* HERE IT IS!
    NEXT A
   
    '*************************************************************************
    '* SHOW SCROLLDN
    '*************************************************************************
    SETVIEW 0, 0, MAXX, MAXY
    A$ = "SCROLLDN (X1,Y1,X2,Y2,NumLines,FillColr)"
    DRWSTRING 1, 7, 0, A$, 10, 16
    SETVIEW X1, Y1, X2, Y2
    FILLVIEW (0)
    NUMOF = MAXX \ 10
    FOR A = 0 TO NUMOF
        X = RND * MAXX
        Y = RND * MAXY
        I = RND * MAXX
        J = RND * MAXY
        DRWLINE 1, Colr, X, Y, I, J
        Colr = Colr + 3
        IF Colr > 255 THEN
            Colr = 16
        END IF
    NEXT A
    DRWSTRING 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    DRWSTRINGLT 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    DRWSTRINGDN 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    DRWSTRINGRT 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF
    TIM! = TIMER
    FOR A = 0 TO NUM
        SCROLLDN X1, Y1, X2, Y2, SKIP, 0   '* HERE IT IS!
    NEXT A
    TIM3! = TIMER - TIM!
  
    '*************************************************************************
    '* SHOW SCROLLRT
    '*************************************************************************
    SETVIEW 0, 0, MAXX, MAXY
    A$ = "SCROLLRT (X1,Y1,X2,Y2,NumLines,FillColr)"
    DRWSTRING 1, 7, 0, A$, 10, 16
    SETVIEW X1, Y1, X2, Y2
    FILLVIEW (0)
    NUMOF = MAXX \ 10
    FOR A = 0 TO NUMOF
        X = RND * MAXX
        Y = RND * MAXY
        I = RND * MAXX
        J = RND * MAXY
        DRWLINE 1, Colr, X, Y, I, J
        Colr = Colr + 3
        IF Colr > 255 THEN
            Colr = 16
        END IF
    NEXT A
    DRWSTRING 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    DRWSTRINGLT 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    DRWSTRINGDN 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    DRWSTRINGRT 1, 7, 0, TEXT$, X1 + SPCNG, Y1 + SPCNG
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF
    FOR A = 0 TO NUM
        SCROLLRT X1, Y1, X2, Y2, SKIP, 0   '* HERE IT IS!
    NEXT A
   
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        EXIT SUB
    END IF

    END SUB

    SUB DOTEXT (RET$, MAXX, MAXY)

    '*************************************************************************
    '* SET UP THE TITLE
    '*************************************************************************
    TITLE$ = "DEMO 6: Text functions"
    PALSET PAL, 0, 255
 
    '*************************************************************************
    '* SHOW ALTERNATE PRINT DIRECTIONS
    '*************************************************************************
    
    FILLSCREEN (0)
    SETVIEW 0, 0, MAXX, MAXY
    DRWSTRING 1, 7, 0, TITLE$, 10, 0
    A$ = "DRWSTRING(Mode,ForeGndColr,BackGndColr,Text$,X,Y)"
    DRWSTRING 1, 7, 0, A$, 10, 16
    SETVIEW 0, 32, MAXX, MAXY
    A$ = "The Quick Brown Fox Jumped Over The Lazy Dog's Back! 0123456789"
    Colr = 16
    FOR Y = 32 TO MAXY STEP 20
        DRWSTRING 1, Colr, 0, A$, 0, Y
        Colr = Colr + 5
        IF Colr > 255 THEN
            Colr = 16
        END IF
    NEXT Y
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        FILLSCREEN (0)
        EXIT SUB
    END IF
  
    FILLVIEW (0)
    SETVIEW 0, 0, MAXX, MAXY
    A$ = "DRWSTRINGLT(Mode,ForeGndColr,BackGndColr,Text$,X,Y)"
    DRWSTRING 1, 7, 0, A$, 10, 16
    SETVIEW 0, 32, MAXX, MAXY
    A$ = "The Quick Brown Fox Jumped Over The Lazy Dog's Back! 0123456789"
    FOR X = 0 TO MAXX STEP 20
        DRWSTRINGLT 1, Colr, 0, A$, X, MAXY
        Colr = Colr + 5
        IF Colr > 255 THEN
            Colr = 16
        END IF
    NEXT X
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        FILLSCREEN (0)
        EXIT SUB
    END IF

    FILLVIEW (0)
    SETVIEW 0, 0, MAXX, MAXY
    A$ = "DRWSTRINGDN(Mode,ForeGndColr,BackGndColr,Text$,X,Y)"
    DRWSTRING 1, 7, 0, A$, 10, 16
    SETVIEW 0, 32, MAXX, MAXY
    A$ = "The Quick Brown Fox Jumped Over The Lazy Dog's Back! 0123456789"
    Colr = 16
    FOR Y = MAXY TO 32 STEP -20
        DRWSTRINGDN 1, Colr, 0, A$, MAXX, Y
        Colr = Colr + 5
        IF Colr > 255 THEN
            Colr = 16
        END IF
    NEXT Y
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        FILLSCREEN (0)
        EXIT SUB
    END IF
              
    FILLVIEW (0)
    SETVIEW 0, 0, MAXX, MAXY
    A$ = "DRWSTRINGRT(Mode,ForeGndColr,BackGndColr,Text$,X,Y)"
    DRWSTRING 1, 7, 0, A$, 10, 16
    SETVIEW 0, 32, MAXX, MAXY
    A$ = "The Quick Brown Fox Jumped Over The Lazy Dog's Back! 0123456789"
    FOR X = MAXX TO 0 STEP -20
        DRWSTRINGRT 1, Colr, 0, A$, X, 32
        Colr = Colr + 5
        IF Colr > 255 THEN
            Colr = 16
        END IF
    NEXT X
    GETKEY RET$
    IF (RET$ = "S") OR (RET$ = "Q") THEN
        SETVIEW 0, 0, MAXX, MAXY
        FILLSCREEN (0)
        EXIT SUB
    END IF
       
    END SUB

