'****************************************************************************
'*     
'*      'SVGAQB10' A Super Vga Graphics Library for use with MS
'*      QuickBasic 4.X
'*      Copyright 1993 by Stephen L. Balkum and Daniel A. Sill
'*
'*      MS and QuickBasic are registered trademarks of Microsoft Corporation.
'*      GIF and 'Graphics Intechange Format' are trademarks (tm) of
'*      Compuserve, Incorporated, an H&R Block Company.
'*
'*    **************** UNREGISTERD SHAREWARE VERSION ***********************
'*    * FOR EVUALATION ONLY. NOT FOR RESALE IN ANY FORM. SOFTWARE WRITTEN  *
'*    * USING THIS UNREGISTERED SHAREWARE GRAPHICS LIBRARY MAY NOT BY SOLD *
'*    * OR USED FOR ANY PURPOSE OTHER THAN THE EVUALTION OF THIS LIBRARY.  *
'*    **********************************************************************
'*
'*    **************** NO WARRANTIES AND NO LIABILITY **********************
'*    * Stephen L. Balkum and Daniel A. Sill provide no warranties, either *
'*    * expressed or implied, of merchantability, or fitness, for a        *
'*    * particular use or purpose of this SOFTWARE and documentation.      *
'*    * In no event shall Stephen L. Balkum or Daniel A. Sill be held      *
'*    * liable for any damages resulting from the use or misuse of the     * 
'*    * SOFTWARE and documentation.                                        *
'*    **********************************************************************
'*
'*    ************** U.S. GOVERNMENT RESTRICTED RIGHTS *********************
'*    * Use, duplication, or disclosure of the SOFTWARE and documentation  *
'*    * by the U.S. Government is subject to the restictions as set forth  *
'*    * in subparagraph (c)(1)(ii) of the Rights in Technical Data and     *
'*    * Computer Software cluse at DFARS 252.227-7013.                     *
'*    * Contractor/manufacturer is Stephen L. Balkum and Daniel A. Sill,   *
'*    * P.O. Box 7704, Austin, Texas 78713-7704                            *
'*    **********************************************************************
'*
'*    **********************************************************************
'*    * By using this SOFTWARE or documentation, you agree to the above    *
'*    * terms and conditions.                                              *
'*    **********************************************************************
'*
'****************************************************************************
    

    REM $INCLUDE: 'SVGAQB10.BI'
    REM $INCLUDE: 'SVGADEMO.BI'

    DIM POINTARRY3D(0 TO 13) AS P3Dtype
    DIM PLAYARRY(0 TO 13) AS P3Dtype
    DIM PLOTARRY(0 TO 13) AS P2DType
    DIM OPLOTARRY(0 TO 13) AS P2DType
    DIM GFXBLK(0 TO 10000) AS INTEGER
    DIM SPRITEDATA(0 TO 1040) AS INTEGER
    DIM SPRITEBKGND(0 TO 130) AS INTEGER
   

    '*************************************************************************
    '* SAVE THE STARTING VIDEOMODE AND SET IT TO MODE 3.
    '*************************************************************************
    STARTVIDEOMODE = VIDEOMODEGET
    RESTEXT
    CLS

    FOR A = 0 TO 33
        Dummy$ = INKEY$  '* CLEAR THE KEYBOARD BUFFER
    NEXT A
    '*************************************************************************
    '* MOVE THE DOS CURSOR TO THE TOP LEFT TO START THE PROGRAM AND SAY HELLO
    '*************************************************************************
    LOCATE 1, 1
    PRINT "'SVGAQB10.LIB' A SuperVGA Graphics Library For Use With MS QuickBASIC 4.5"
    LOCATE 2, 10
    PRINT "Copyright 1993 by Stephen L. Balkum and Daniel A. Sill"
    LOCATE 12, 25
    PRINT "Demonstration/Example Program"
    LOCATE 23, 1
    PRINT "Press a key to begin the demo..."
    GETKEY (RET$)
    CLS
   
    '*************************************************************************
    '* LET'S ID THE PROCESSOR FIRST AS THE LIBRARY REQUIRES A 386 OR BETTER.
    '*************************************************************************
    LOCATE 1, 1
    CPU = WHICHCPU
    CPU$ = STR$(CPU)
    L = LEN(CPU$)
    CPU$ = RIGHT$(CPU$, L - 1)
    IF CPU < 386 THEN
        PRINT "Sorry, this library requires a 80386 or better processor."
        PRINT "Processor is identified as a 80"; CPU$; "."
        PRINT "Demo program will be terminated."
        PRINT
        PRINT "Press a key..."
        SOUND 100, 5
        WHILE INKEY$ = ""
        WEND
        VIDEOMODESET (STARTVIDEOMODE)
        END
    ELSE
        PRINT "Microprocessor is identified as a 80"; CPU$; "."
    END IF
    PRINT

    '*************************************************************************
    '* LET'S ID THE VIDEO CARD/CHIP AS THE LIBRARY REQUIRES A SUPERVGA ADAPTER.
    '*************************************************************************
    VGA = WHICHVGA
    SELECT CASE VGA
        CASE IS = 1
            VGA$ = "Acumos SuperVGA"
        CASE IS = 2
            VGA$ = "ATI Technologies SuperVGA"
        CASE IS = 3
            VGA$ = "Ahead V5000 ver A SuperVGA"
        CASE IS = 4
            VGA$ = "Ahead V5000 ver B SuperVGA"
        CASE IS = 5
            VGA$ = "Chips and Technologies SuperVGA"
        CASE IS = 6
            VGA$ = "Cirrus Logic CL-GD 500/600 SuperVGA"
        CASE IS = 7
            VGA$ = "Everex Micro Enhancer SuperVGA"
        CASE IS = 8
            VGA$ = "Genoa SuperVGA"
        CASE IS = 9
            VGA$ = "NCR 77C22E SuperVGA"
        CASE IS = 10
            VGA$ = "Oak Technologies OTI-067/037C SuperVGA"
        CASE IS = 11
            VGA$ = "Paridise/Western Digital SuperVGA"
        CASE IS = 13
            VGA$ = "Trident 8800/8900 SuperVGA"
        CASE IS = 14
            VGA$ = "Tseng Labs 3000 SuperVGA"
        CASE IS = 15
            VGA$ = "Tseng Labs 4000 SuperVGA"
        CASE IS = 16
            VGA$ = "VESA compatable SuperVGA"
        CASE IS = 17
            VGA$ = "Video 7 SuperVGA"
        CASE ELSE
            VGA$ = "Unidentified"
            VGA = 0
    END SELECT
    IF VGA < 1 THEN
        PRINT "Sorry, unable to identify video card or it is not a SuperVGA video adapter."
        PRINT "Demo program will be terminated."
        PRINT
        PRINT "Press a key..."
        SOUND 100, 5
        WHILE INKEY$ = ""
        WEND
        VIDEOMODESET (STARTVIDEOMODE)
        END
    ELSE
        PRINT "Video card/chip is identified as a "; VGA$; "."
    END IF
   
    '*************************************************************************
    '* LET'S SEE THE HOW MUCH MEMORY IS INSTALLED ON THE SUPER VGA ADAPTER.
    '*************************************************************************
    VIDEOMEMORY = WHICHMEM
    MEM$ = STR$(VIDEOMEMORY)
    MEM$ = RIGHT$(MEM$, LEN(MEM$) - 1) + " kB"
    IF VIDEOMEMORY < 1 THEN
        PRINT "Sorry, unable to identify the amount of installed video memory."
        PRINT "Demo program will be terminated."
        PRINT
        PRINT "Press a key..."
        SOUND 100, 5
        WHILE INKEY$ = ""
        WEND
        VIDEOMODESET (STARTVIDEOMODE)
        END
    ELSE
        PRINT "Installed video memory identified as "; MEM$; "."
    END IF
   
    '*************************************************************************
    '* LET'S TELL THE USER WHAT THE HIGHEST RESOLUTION THAT THE VIDEO CARD
    '* AND ITS INSTALLED MEMORY CARD IS CABABLE OF. THE MONITOR MUST BE ABLE
    '* TO SUPPORT THOSE MODES TOO !
    '*************************************************************************
    PRINT "Video card and installed memory is capable of the following resolutions:"
    SELECT CASE VIDEOMEMORY
        CASE IS > 1023
            PRINT TAB(4); "320x200 in 256 colors"
            PRINT TAB(4); "640x480 in 256 colors"
            PRINT TAB(4); "800x600 in 256 colors"
            PRINT TAB(4); "1024x768 in 256 colors"
            MAX = 4
        CASE IS > 511
            PRINT TAB(4); "320x200 in 256 colors"
            PRINT TAB(4); "640x480 in 256 colors"
            PRINT TAB(4); "800x600 in 256 colors"
            MAX = 3
        CASE ELSE
            PRINT TAB(4); "320x200 in 256 colors"
            MAX = 1
    END SELECT
    PRINT
    PRINT "PLEASE keep in mind that not all monitors support all resolutions."
    PRINT

    '*************************************************************************
    '* LET'S LOOK FOR A MOUSE. IF WE FIND ONE, TELL ALL ABOUT IT
    '*************************************************************************
    MOUSE = WHICHMOUSE
    IF MOUSE > 0 THEN
        MOUSEINFO MJV, MNV, TP, I
        VER$ = STR$(MNV)
        L = LEN(VER$)
        VER$ = STR$(MJV) + "." + RIGHT$(VER$, L - 1)
        VER$ = "Software driver version is" + VER$ + " (Microsoft equalvalent version)."
        SELECT CASE TP
            CASE IS = 1
                TYPE$ = "bus mouse"
            CASE IS = 2
                TYPE$ = "serial mouse"
            CASE IS = 3
                TYPE$ = "Inport mouse"
            CASE IS = 4
                TYPE$ = "PS/2 mouse"
            CASE IS = 5
                TYPE$ = "HP mouse"
            CASE ELSE
                TYPE$ = "unknown type"
        END SELECT
        PRINT "Microsoft compatable " + TYPE$ + " detected with" + STR$(MOUSE) + " buttons on IRQ" + STR$(I) + "."
        PRINT VER$
    ELSE
        PRINT "No Microsoft compatable mouse detected."
    END IF
    PRINT

    '*************************************************************************
    '* LET'S LOOK FOR JOYSTICKS
    '*************************************************************************
    JOYSTICK = WHICHJOYSTICK
    SELECT CASE JOYSTICK
        CASE IS = -1
            A$ = "No joystick port detected or no joystick BIOS support present."
        CASE IS = 0
            A$ = "No joystick detected."
        CASE IS = 1
            A$ = "Joystick A is present and available."
        CASE IS = 2
            A$ = "Joystick B is present and available."
        CASE IS = 3
            A$ = "Both Joystick A and Joystick B are present and available."
    END SELECT
    PRINT A$
    PRINT
    PRINT "Press a key..."
    GETKEY RET$
   
    '*************************************************************************
    '* LET'S GET DOWN TO BUISNESS!
    '*************************************************************************
    RES = 1
    ENDIT = 0
   
    '*************************************************************************
    '* INIT ALTERNATE MOUSE CURSORS
    '*************************************************************************
    FOR I = 1 TO 386
        READ A
        MID$(MAGMOUSECURSOR, I, 1) = CHR$(A)
    NEXT I
    FOR I = 1 TO 386
        READ A
        MID$(BIGMOUSECURSOR, I, 1) = CHR$(A)
    NEXT I
    FOR I = 1 TO 386
        READ A
        MID$(STWMOUSECURSOR, I, 1) = CHR$(A)
    NEXT I

    '*************************************************************************
    '* INIT THE SPRITE DATA ARRAY
    '*************************************************************************
    FOR I = 0 TO 7
        FOR J = 0 TO 129
            READ SPRITEDATA(I * 130 + J)
        NEXT J
    NEXT I


    '*************************************************************************
    '* INIT ALTERNATE COLOR PALETTES
    '*************************************************************************
    RES320
    PALGET ORGPAL, 0, 255
    PAL = ORGPAL
    PAL2 = ORGPAL
    MYPI! = 8 * ATN(1) / 240
    FOR Colr = 0 TO 239
        R1 = 32 + SIN((Colr + 0) * MYPI!) * 31
        G1 = 32 + SIN((Colr + 80) * MYPI!) * 31
        B1 = 32 + SIN((Colr + 160) * MYPI!) * 31
        R2 = 32 + SIN((Colr + 10) * MYPI!) * 31
        G2 = 32 + SIN((Colr + 30) * MYPI!) * 31
        B2 = 32 + SIN((Colr + 50) * MYPI!) * 31
        OFFSET = ((Colr + 16) * 3)
        MID$(PAL, OFFSET + 1, 1) = CHR$(R1)  '* RED
        MID$(PAL, OFFSET + 2, 1) = CHR$(G1)  '* GREEN
        MID$(PAL, OFFSET + 3, 1) = CHR$(B1)  '* BLUE
        MID$(PAL2, OFFSET + 1, 1) = CHR$(R2)  '* RED
        MID$(PAL2, OFFSET + 2, 1) = CHR$(G2)  '* GREEN
        MID$(PAL2, OFFSET + 3, 1) = CHR$(B2)  '* BLUE
    NEXT Colr
    RESTEXT

    '*************************************************************************
    '* HERE IS THE MAIN SELECTOR LOOP
    '*************************************************************************
    WHILE ENDIT = 0
        RetVal$ = ""
        CLS
        SOUND 700, .75
        SELECT CASE RES
            CASE IS = 1
                MAXX = 319
                MAXY = 199
                RES$ = "320x200x256"
            CASE IS = 2
                MAXX = 639
                MAXY = 479
                RES$ = "640x480x256"
            CASE IS = 3
                MAXX = 799
                MAXY = 599
                RES$ = "800x600x256"
            CASE IS = 4
                MAXX = 1023
                MAXY = 767
                RES$ = "1024x768x256"
        END SELECT
        PRINT "Please select the demo you would like to see in the " + RES$ + " resolution:"
        PRINT
        PRINT "(0)  Exit This Program"
        PRINT
        PRINT "(1)  Demo #1  The Primitive Drawing Routines"
        PRINT "(2)  Demo #2  The Clipping Capibilities"
        PRINT "(3)  Demo #3  The Fill Routines"
        PRINT "(4)  Demo #4  The Palette Routines"
        PRINT "(5)  Demo #5  The Block Routines"
        PRINT "(6)  Demo #6  The Text Routines"
        PRINT "(7)  Demo #7  The Scrolling Routines"
        PRINT "(8)  Demo #8  The GIF (tm) Routines"
        PRINT "(9)  Demo #9  The Mouse Routines"
        PRINT "(10) Demo #10 The Joystick Routines"
        PRINT "(11) Demo #11 The Two Dimensional Routines"
        PRINT "(12) Demo #12 The Three Dimensional Routines"
        PRINT "(13) The Grand Tour Of All Demos"
        PRINT
        SELECT CASE VIDEOMEMORY
            CASE IS > 1023
                PRINT "(14) Use 320x200x256  Resolution"
                PRINT "(15) Use 640x480x256  Resolution"
                PRINT "(16) Use 800x600x256  Resolution"
                PRINT "(17) Use 1024x768x256 Resolution"
                MAX = 17
            CASE IS > 511
                PRINT "(14) Use 320x200x256  Resolution"
                PRINT "(15) Use 640x480x256  Resolution"
                PRINT "(16) Use 800x600x256  Resolution"
                MAX = 16
            CASE ELSE
                PRINT "(14) Use 320x200x256  Resolution"
                MAX = 14
        END SELECT
        A$ = ""
        INPUT "Your Choice"; A$
        KY = VAL(A$)
        IF (A$ > "9") OR (A$ < "0") THEN
            KY = -1
        END IF
        IF KY > MAX THEN
            KY = -1
        END IF
        SELECT CASE KY
            CASE IS = 0
                ENDIT = 1
            CASE IS = 1
                'DEMO #1
                SELECT CASE RES
                    CASE IS = 1
                        RES320
                    CASE IS = 2
                        RES640
                    CASE IS = 3
                        RES800
                    CASE IS = 4
                        RES1024
                END SELECT
                DOPRIMS RetVal$, MAXX, MAXY
                RESTEXT
            CASE IS = 2
                'DEMO #2
                SELECT CASE RES
                    CASE IS = 1
                        RES320
                    CASE IS = 2
                        RES640
                    CASE IS = 3
                        RES800
                    CASE IS = 4
                        RES1024
                END SELECT
                DOCLIP RetVal$, MAXX, MAXY
                RESTEXT
            CASE IS = 3
                'DEMO #3
                SELECT CASE RES
                    CASE IS = 1
                        RES320
                    CASE IS = 2
                        RES640
                    CASE IS = 3
                        RES800
                    CASE IS = 4
                        RES1024
                END SELECT
                DOFILL RetVal$, MAXX, MAXY
                RESTEXT
            CASE IS = 4
                'DEMO #4
                SELECT CASE RES
                    CASE IS = 1
                        RES320
                    CASE IS = 2
                        RES640
                    CASE IS = 3
                        RES800
                    CASE IS = 4
                        RES1024
                END SELECT
                DOPAL RetVal$, MAXX, MAXY
                RESTEXT
            CASE IS = 5
                'DEMO #5
                SELECT CASE RES
                    CASE IS = 1
                        RES320
                    CASE IS = 2
                        RES640
                    CASE IS = 3
                        RES800
                    CASE IS = 4
                        RES1024
                END SELECT
                DOBLOCK RetVal$, MAXX, MAXY
                RESTEXT
            CASE IS = 6
                'DEMO #6
                SELECT CASE RES
                    CASE IS = 1
                        RES320
                    CASE IS = 2
                        RES640
                    CASE IS = 3
                        RES800
                    CASE IS = 4
                        RES1024
                END SELECT
                DOTEXT RetVal$, MAXX, MAXY
                RESTEXT
            CASE IS = 7
                'DEMO #7
                SELECT CASE RES
                    CASE IS = 1
                        RES320
                    CASE IS = 2
                        RES640
                    CASE IS = 3
                        RES800
                    CASE IS = 4
                        RES1024
                END SELECT
                DOSCROLL RetVal$, MAXX, MAXY
                RESTEXT
            CASE IS = 8
                'DEMO #8
                SELECT CASE RES
                    CASE IS = 1
                        RES320
                    CASE IS = 2
                        RES640
                    CASE IS = 3
                        RES800
                    CASE IS = 4
                        RES1024
                END SELECT
                DOGIF RetVal$, MAXX, MAXY
                RESTEXT
            CASE IS = 9
                'DEMO #9
                SELECT CASE RES
                    CASE IS = 1
                        RES320
                    CASE IS = 2
                        RES640
                    CASE IS = 3
                        RES800
                    CASE IS = 4
                        RES1024
                END SELECT
                DOMOUSE RetVal$, MAXX, MAXY
                RESTEXT
            CASE IS = 10
                'DEMO #10
                SELECT CASE RES
                    CASE IS = 1
                        RES320
                    CASE IS = 2
                        RES640
                    CASE IS = 3
                        RES800
                    CASE IS = 4
                        RES1024
                END SELECT
                DOJOYSTICK RetVal$, MAXX, MAXY
                RESTEXT
            CASE IS = 11
                'DEMO #11
                SELECT CASE RES
                    CASE IS = 1
                        RES320
                    CASE IS = 2
                        RES640
                    CASE IS = 3
                        RES800
                    CASE IS = 4
                        RES1024
                END SELECT
                DO2D RetVal$, MAXX, MAXY
                RESTEXT
            CASE IS = 12
                'DEMO #12
                SELECT CASE RES
                    CASE IS = 1
                        RES320
                    CASE IS = 2
                        RES640
                    CASE IS = 3
                        RES800
                    CASE IS = 4
                        RES1024
                END SELECT
                DO3D RetVal$, MAXX, MAXY
                RESTEXT
            CASE IS = 13
                'DO THE GRAND TOUR OF ALL DEMOS!
                CLS
                PRINT "Press 'Q' To End Grand Tour At Any Time. Press 'S' To Skip To The Next"
                PRINT "Demo At Any Time. Press Any Other Key to Begin The Grand Tour..."
                GETKEY RET$
                IF RET$ = "Q" THEN
                    GOTO EXITGRANDTOUR
                END IF
                SELECT CASE RES
                    CASE IS = 1
                        RES320
                    CASE IS = 2
                        RES640
                    CASE IS = 3
                        RES800
                    CASE IS = 4
                        RES1024
                END SELECT
                'DEMO #1
                DOPRIMS RetVal$, MAXX, MAXY
                IF RetVal$ = "Q" THEN
                    GOTO EXITGRANDTOUR
                END IF
                'DEMO #2
                DOCLIP RetVal$, MAXX, MAXY
                IF RetVal$ = "Q" THEN
                    GOTO EXITGRANDTOUR
                END IF
                'DEMO #3
                DOFILL RetVal$, MAXX, MAXY
                IF RetVal$ = "Q" THEN
                    GOTO EXITGRANDTOUR
                END IF
                'DEMO #4
                DOPAL RetVal$, MAXX, MAXY
                IF RetVal$ = "Q" THEN
                    GOTO EXITGRANDTOUR
                END IF
                'DEMO #5
                DOBLOCK RetVal$, MAXX, MAXY
                IF RetVal$ = "Q" THEN
                    GOTO EXITGRANDTOUR
                END IF
                'DEMO #6
                DOTEXT RetVal$, MAXX, MAXY
                IF RetVal$ = "Q" THEN
                    GOTO EXITGRANDTOUR
                END IF
                'DEMO #7
                DOSCROLL RetVal$, MAXX, MAXY
                IF RetVal$ = "Q" THEN
                    GOTO EXITGRANDTOUR
                END IF
                'DEMO #8
                DOGIF RetVal$, MAXX, MAXY
                IF RetVal$ = "Q" THEN
                    GOTO EXITGRANDTOUR
                END IF
                'DEMO #9
                DOMOUSE RetVal$, MAXX, MAXY
                IF RetVal$ = "Q" THEN
                    GOTO EXITGRANDTOUR
                END IF
                IF RetVal$ = "Q" THEN
                    GOTO EXITGRANDTOUR
                END IF
                'DEMO #10
                DOJOYSTICK RetVal$, MAXX, MAXY
                IF RetVal$ = "Q" THEN
                    GOTO EXITGRANDTOUR
                END IF
                'DEMO #11
                DO2D RetVal$, MAXX, MAXY
                IF RetVal$ = "Q" THEN
                    GOTO EXITGRANDTOUR
                END IF
                'DEMO #12
                DO3D RetVal$, MAXX, MAXY
EXITGRANDTOUR:
                RetVal$ = ""
                RESTEXT
            CASE IS = 14
                RES = 1
            CASE IS = 15
                RES = 2
            CASE IS = 16
                RES = 3
            CASE IS = 17
                RES = 4
            CASE ELSE
                SOUND 100, 5
        END SELECT
        IF RetVal$ = "Q" THEN
            ENDIT = 1
        END IF
    WEND

    '*************************************************************************
    '* THAT'S ALL FOLKS! END THE PROGRAM
    '*************************************************************************
    RESTEXT '* FORCE THE VGA PALETTE TO RESET
    VIDEOMODESET STARTVIDEOMODE '*RESTORE THE VIDEOMODE WE STARTED IN
    RESTEXT '* FORCE THE VGA PALETTE TO RESET
    END


    '*************************************************************************
    '* DATA DATA DATA DATA DATA DATA DATA DATA DATA DATA DATA DATA DATA DATA
    '*************************************************************************
   
    REM *MAGNIFIER MOUSE CURSOR DATA
    DATA 7,6
    DATA 255,255,255,255,255,7,7,7,7,255,255,255,255,255,255,255
    DATA 255,255,255,7,7,255,255,255,255,7,7,255,255,255,255,255
    DATA 255,255,7,255,255,255,255,255,255,255,255,7,255,255,255,255
    DATA 255,7,255,255,255,255,255,255,255,255,255,255,7,255,255,255
    DATA 255,7,255,255,255,255,255,255,255,255,255,255,7,255,255,255
    DATA 7,255,255,255,255,255,255,255,255,255,255,255,255,7,255,255
    DATA 7,255,255,255,255,255,255,255,255,255,255,255,255,7,255,255
    DATA 7,255,255,255,255,255,255,255,255,255,255,255,255,7,255,255
    DATA 7,255,255,255,255,255,255,255,255,255,255,255,255,7,255,255
    DATA 255,7,255,255,255,255,255,255,255,255,255,255,7,255,255,255
    DATA 255,7,255,255,255,255,255,255,255,255,255,255,7,255,255,255
    DATA 255,7,7,255,255,255,255,255,255,255,255,7,7,255,255,255
    DATA 255,255,7,7,7,255,255,255,255,7,7,7,255,255,255,255
    DATA 255,255,255,7,7,7,7,7,7,8,8,255,255,255,255,255
    DATA 255,255,255,255,255,7,7,7,7,7,8,8,255,255,255,255
    DATA 255,255,255,255,255,255,255,255,255,7,8,8,255,255,255,255
    DATA 255,255,255,255,255,255,255,255,255,255,7,8,8,255,255,255
    DATA 255,255,255,255,255,255,255,255,255,255,7,8,8,255,255,255
    DATA 255,255,255,255,255,255,255,255,255,255,255,7,8,8,255,255
    DATA 255,255,255,255,255,255,255,255,255,255,255,7,8,8,255,255
    DATA 255,255,255,255,255,255,255,255,255,255,255,255,7,8,8,255
    DATA 255,255,255,255,255,255,255,255,255,255,255,255,7,8,8,255
    DATA 255,255,255,255,255,255,255,255,255,255,255,255,255,7,8,8
    DATA 255,255,255,255,255,255,255,255,255,255,255,255,255,7,7,7

    REM *BIG ARROW MOUSE CURSOR DATA
    DATA 1,1
    DATA 0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255
    DATA 0,15,15,0,0,255,255,255,255,255,255,255,255,255,255,255
    DATA 0,15,15,15,15,0,0,0,255,255,255,255,255,255,255,255
    DATA 0,15,15,15,15,15,15,15,0,0,255,255,255,255,255,255
    DATA 0,15,15,15,15,15,15,15,15,15,0,0,0,255,255,255
    DATA 0,15,15,15,15,15,15,15,15,15,15,15,15,0,0,255
    DATA 0,15,15,15,15,15,15,15,15,15,15,15,15,15,0,255
    DATA 0,15,15,15,15,15,15,15,15,15,15,15,0,0,255,255
    DATA 0,15,15,15,15,15,15,15,15,15,15,0,255,255,255,255
    DATA 0,15,15,15,15,15,15,15,15,0,0,255,255,255,255,255
    DATA 0,15,15,15,15,15,15,15,15,0,255,255,255,255,255,255
    DATA 0,15,15,15,15,15,0,15,15,15,0,255,255,255,255,255
    DATA 0,15,15,15,15,0,0,15,15,15,0,255,255,255,255,255
    DATA 0,15,15,0,0,255,255,0,15,15,15,0,255,255,255,255
    DATA 0,15,0,255,255,255,255,0,15,15,15,0,255,255,255,255
    DATA 0,0,255,255,255,255,255,255,0,15,15,15,0,255,255,255
    DATA 255,255,255,255,255,255,255,255,255,0,15,15,15,0,255,255
    DATA 255,255,255,255,255,255,255,255,255,0,15,15,15,0,255,255
    DATA 255,255,255,255,255,255,255,255,255,255,0,15,15,15,0,255
    DATA 255,255,255,255,255,255,255,255,255,255,255,0,15,15,15,0
    DATA 255,255,255,255,255,255,255,255,255,255,255,0,15,15,15,0
    DATA 255,255,255,255,255,255,255,255,255,255,255,255,0,15,15,0
    DATA 255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0
    DATA 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
   
    REM *STOPWATCH MOUSE CURSOR DATA
    DATA 8,11
    DATA 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
    DATA 255,255,255,255,255,255,15,15,15,15,255,255,255,255,255,255
    DATA 255,255,255,255,255,255,15,15,15,15,255,255,255,255,255,255
    DATA 255,255,255,255,255,255,255,15,15,255,255,255,255,255,255,255
    DATA 255,255,255,255,255,255,15,15,15,15,255,255,255,255,255,255
    DATA 255,255,255,255,15,15,15,7,7,15,15,15,255,255,255,255
    DATA 255,255,255,15,15,7,7,7,7,7,7,15,15,255,255,255
    DATA 255,255,15,15,7,7,7,7,7,7,7,7,15,15,255,255
    DATA 255,15,15,7,0,7,7,7,7,7,7,7,7,15,15,255
    DATA 255,15,7,7,7,0,7,7,7,7,7,7,7,7,15,255
    DATA 15,15,7,7,7,7,0,7,7,7,0,0,7,7,15,15
    DATA 15,7,7,7,7,7,7,0,0,0,7,7,7,7,7,15
    DATA 15,7,7,7,7,7,7,0,0,7,7,7,7,7,7,15
    DATA 15,15,7,7,7,7,7,7,7,7,7,7,7,7,15,15
    DATA 255,15,7,7,7,7,7,7,7,7,7,7,7,7,15,255
    DATA 255,15,15,7,7,7,7,7,7,7,7,7,7,15,15,255
    DATA 255,255,15,15,7,7,7,7,7,7,7,7,15,15,255,255
    DATA 255,255,255,15,15,7,7,7,7,7,7,15,15,255,255,255
    DATA 255,255,255,255,15,15,15,7,7,15,15,15,255,255,255,255
    DATA 255,255,255,255,255,255,15,15,15,15,255,255,255,255,255,255
    DATA 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
    DATA 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
    DATA 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
    DATA 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255

      
    REM *SPRITE DATA
    DATA  15, 15, 0, 0, 0, 2304, 0, 0, 0, 0
    DATA  0, 0, 0, 265, 9, 0, 0, 0, 0, 0
    DATA  2304, 2305, 2305, 0, 0, 0, 0, 0, 0, 2304
    DATA  0, 0, 0, 0, 0, 0, 0, 2304, 0, 0
    DATA  0, 0, 0, 0, 0, 2570, 10, 0, 0, 0
    DATA  0, 0, 2560, 3588, 2564, 0, 0, 0, 0, 0
    DATA  2560, 1038, 2574, 0, 0, 0, 0, 0, 2560, 3588
    DATA  2564, 0, 0, 0, 0, 0, 1280, 2570, 1290, 0
    DATA  0, 0, 0, 0, 5, 2304, 0, 5, 0, 0
    DATA  0, 0, 5, 2304, 0, 5, 0, 0, 0, 1280
    DATA  0, 265, 9, 1280, 0, 0, 0, 1280, 2304, 2049
    DATA  2305, 1280, 0, 0, 0, 5, 2304, 2049, 2305, 0
    DATA  5, 0, 0, 0, 0, 0, 0, 0, 0, 0

    DATA  15, 15, 0, 0, 0, 0, 0, 0, 0, 0
    DATA  0, 0, 0, 0, 0, 2313, 2313, 0, 0, 0
    DATA  0, 0, 0, 256, 2305, 0, 0, 0, 0, 0
    DATA  0, 2304, 2305, 0, 0, 0, 0, 0, 0, 9
    DATA  2304, 0, 0, 0, 0, 2570, 2314, 0, 0, 0
    DATA  0, 0, 2560, 1038, 2574, 0, 0, 0, 0, 1280
    DATA  2565, 1028, 2564, 0, 0, 0, 1280, 5, 2560, 1038
    DATA  2574, 0, 0, 0, 5, 0, 2304, 2570, 10, 0
    DATA  0, 0, 0, 2313, 9, 1280, 0, 0, 0, 0
    DATA  2304, 257, 9, 1280, 0, 0, 0, 0, 265, 264
    DATA  9, 5, 0, 0, 0, 0, 2048, 2305, 0, 5
    DATA  0, 0, 0, 0, 0, 9, 1280, 0, 0, 0
    DATA  0, 0, 0, 0, 0, 0, 0, 0, 0, 0

    DATA  15, 15, 0, 0, 0, 0, 0, 0, 0, 0
    DATA  0, 0, 0, 0, 0, 0, 0, 0, 5, 0
    DATA  0, 0, 0, 0, 0, 0, 1280, 5, 0, 0
    DATA  0, 0, 0, 0, 0, 1280, 5, 0, 0, 0
    DATA  0, 0, 2313, 0, 1280, 2570, 10, 0, 9, 0
    DATA  257, 9, 2560, 3588, 2564, 0, 2305, 0, 2056, 2305
    DATA  2569, 1038, 2574, 2313, 265, 9, 257, 9, 2560, 3588
    DATA  2564, 0, 2305, 0, 2313, 0, 1280, 2570, 10, 0
    DATA  9, 0, 0, 1280, 5, 0, 0, 0, 0, 0
    DATA  1280, 5, 0, 0, 0, 0, 0, 0, 5, 0
    DATA  0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    DATA  0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    DATA  0, 0, 0, 0, 0, 0, 0, 0, 0, 0

    DATA  15, 15, 0, 9, 1280, 0, 0, 0, 0, 0
    DATA  2048, 2305, 0, 5, 0, 0, 0, 0, 265, 264
    DATA  9, 5, 0, 0, 0, 0, 2304, 257, 9, 1280
    DATA  0, 0, 0, 0, 0, 2313, 9, 1280, 0, 0
    DATA  0, 0, 5, 0, 2304, 2570, 10, 0, 0, 0
    DATA  1280, 5, 2560, 1038, 2574, 0, 0, 0, 0, 1280
    DATA  2565, 1028, 2564, 0, 0, 0, 0, 0, 2560, 1038
    DATA  2574, 0, 0, 0, 0, 0, 0, 2570, 2314, 0
    DATA  0, 0, 0, 0, 0, 0, 0, 9, 2304, 0
    DATA  0, 0, 0, 0, 0, 2304, 2305, 0, 0, 0
    DATA  0, 0, 0, 256, 2305, 0, 0, 0, 0, 0
    DATA  0, 2313, 2313, 0, 0, 0, 0, 0, 0, 0
    DATA  0, 0, 0, 0, 0, 0, 0, 0, 0, 0

    DATA  15, 15, 0, 5, 2304, 2049, 2305, 0, 5, 0
    DATA  0, 1280, 2304, 2049, 2305, 1280, 0, 0, 0, 1280
    DATA  0, 265, 9, 1280, 0, 0, 0, 0, 5, 2304
    DATA  0, 5, 0, 0, 0, 0, 5, 2304, 0, 5
    DATA  0, 0, 0, 0, 1280, 2570, 1290, 0, 0, 0
    DATA  0, 0, 2560, 3588, 2564, 0, 0, 0, 0, 0
    DATA  2560, 1038, 2574, 0, 0, 0, 0, 0, 2560, 3588
    DATA  2564, 0, 0, 0, 0, 0, 0, 2570, 10, 0
    DATA  0, 0, 0, 0, 0, 2304, 0, 0, 0, 0
    DATA  0, 0, 0, 2304, 0, 0, 0, 0, 0, 0
    DATA  2304, 2305, 2305, 0, 0, 0, 0, 0, 0, 265
    DATA  9, 0, 0, 0, 0, 0, 0, 2304, 0, 0
    DATA  0, 0, 0, 0, 0, 0, 0, 0, 0, 0

    DATA  15, 15, 0, 0, 0, 0, 1280, 0, 9, 0
    DATA  0, 0, 0, 0, 5, 2304, 2049, 0, 0, 0
    DATA  0, 0, 5, 265, 264, 9, 0, 0, 0, 1280
    DATA  0, 265, 2305, 0, 0, 0, 0, 1280, 0, 2313
    DATA  9, 0, 0, 0, 0, 2570, 2314, 0, 0, 5
    DATA  0, 0, 2560, 1038, 2574, 0, 1285, 0, 0, 0
    DATA  2560, 1028, 2564, 1285, 0, 0, 0, 0, 2560, 1038
    DATA  2574, 0, 0, 0, 0, 0, 2304, 2570, 10, 0
    DATA  0, 0, 2304, 0, 9, 0, 0, 0, 0, 0
    DATA  2304, 2305, 0, 0, 0, 0, 0, 0, 2304, 257
    DATA  0, 0, 0, 0, 0, 0, 2304, 2313, 9, 0
    DATA  0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    DATA  0, 0, 0, 0, 0, 0, 0, 0, 0, 0

    DATA  15, 15, 0, 0, 0, 0, 0, 0, 0, 0
    DATA  0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    DATA  0, 0, 0, 0, 0, 5, 0, 0, 0, 0
    DATA  0, 0, 1285, 0, 0, 0, 0, 0, 0, 1285
    DATA  0, 0, 0, 9, 0, 2570, 1290, 0, 2304, 9
    DATA  2304, 1, 2560, 3588, 2564, 0, 265, 1, 265, 2313
    DATA  2569, 1038, 2574, 2313, 2049, 8, 2304, 1, 2560, 3588
    DATA  2564, 0, 265, 1, 0, 9, 0, 2570, 1290, 0
    DATA  2304, 9, 0, 0, 0, 0, 0, 1285, 0, 0
    DATA  0, 0, 0, 0, 0, 0, 1285, 0, 0, 0
    DATA  0, 0, 0, 0, 0, 5, 0, 0, 0, 0
    DATA  0, 0, 0, 0, 0, 0, 0, 0, 0, 0
    DATA  0, 0, 0, 0, 0, 0, 0, 0, 0, 0

    DATA  15, 15, 0, 0, 0, 0, 0, 0, 0, 0
    DATA  2304, 2313, 9, 0, 0, 0, 0, 0, 2304, 257
    DATA  0, 0, 0, 0, 0, 0, 2304, 2305, 0, 0
    DATA  0, 0, 0, 0, 2304, 0, 9, 0, 0, 0
    DATA  0, 0, 0, 0, 2304, 2570, 10, 0, 0, 0
    DATA  0, 0, 2560, 1038, 2574, 0, 0, 0, 0, 0
    DATA  2560, 1028, 2564, 1285, 0, 0, 0, 0, 2560, 1038
    DATA  2574, 0, 1285, 0, 0, 0, 0, 2570, 2314, 0
    DATA  0, 5, 0, 0, 0, 1280, 0, 2313, 9, 0
    DATA  0, 0, 0, 1280, 0, 265, 2305, 0, 0, 0
    DATA  0, 0, 5, 265, 264, 9, 0, 0, 0, 0
    DATA  5, 2304, 2049, 0, 0, 0, 0, 0, 1280, 0
    DATA  9, 0, 0, 0, 0, 0, 0, 0, 0, 0

REM $DYNAMIC
    SUB GETKEY (KEY$)

    '*************************************************************************
    '* THIS ROUTINE WAITS FOR A KEY STROKE
    '*************************************************************************
   
    FOR A = 0 TO 7 '* CLEAR THE KBD BUFFER
        A$ = INKEY$
    NEXT A
   
    SOUND 700, .75
    A$ = ""
    WHILE A$ = ""
        A$ = INKEY$
        IF A$ = "q" THEN
            A$ = "Q"
        END IF
        IF A$ = "s" THEN
            A$ = "S"
        END IF
    WEND
    KEY$ = A$
   
    END SUB

