' RecurTW.Bas - Recursive directory treewalk demonstration.
' $INCLUDE: 'TREEWALK.BI'
' $INCLUDE: 'DIRFUN.BI'
' In your programs in which you want to use the TreeWalk module,
' you'll similarly need to create your own ProcessDirectoryEntry.
DECLARE SUB ProcessDirectoryEntry (PathSpec$, EntrySpec$, _
           EntryRecord AS DirectoryRecord, Level%)

INPUT "Enter a path spec: ", Spec$
Action% = 0
DO WHILE Action% = 0
  PRINT "Enter T for top-down traversal, or"
  INPUT "enter B for bottoms-up traversal:", Action$
  Action% = INSTR("TB", UCASE$(Action$))
LOOP
TreeWalk Spec$, Action%   ' Walk the directory tree.
END

SUB ProcessDirectoryEntry (PathSpec$, EntrySpec$, _
                         DirEnt AS DirectoryRecord, Level%)
' ProcessDirectoryEntry - Perform whatever action you want
'                         with the contents of "DirEnt".
' Convert ASCIIZ string to normal string
TrimmedEntry$ = MID$(DirEnt.FileName, 1, INSTR(DirEnt.FileName, CHR$(0)) - 1)
IF Right$(TrimmedEntry$, 4) = RIGHT$(EntrySpec$, 4) THEN
  PRINT "Level "; Level%; " "; PathSpec$; TrimmedEntry$
END IF
END SUB
