' ParsPath.Bas - Support module to contain the ParsePathname subprogram.

' $INCLUDE: 'QUALNAME.BI'
' $INCLUDE: 'PARSPATH.BI'
' $INCLUDE: 'QB.BI'

' Note: This module requires the support module QUALNAME.BAS
'       for its operation.

SUB ParsePathname (InSpec$, Drive$, Path$, Entry$)
' ParsePathname - Split the file specification in InSpec$
'                 into its component parts (after trying
'                 to qualify it).
IF LEN(InSpec$) > 0 THEN
  OldSpec$ = InSpec$		' make a copy for possible later use
  OldDrive$ = ""
  InSpec$ = QualifyName$(InSpec$) ' qualify the name (DOS 3.X > only)
  ' Let's see if the network redirector messed with the name
  IF LEFT$(InSpec$, 2) = "\\" THEN
    ' Yup. This filename is on a network. We'll need to remove
    ' the \\SERVER_NAME\VOLUME_NAME prefix, then stick a drive
    ' letter back on the front of the name.
    InSpec$ = MID$(InSpec$, INSTR(MID$(InSpec$, 3), "\")+2)
    InSpec$ = MID$(InSpec$, INSTR(MID$(InSpec$, 2), "\")+1)
    IF MID$(OldSpec$, 2, 1) = ":" THEN ' Did user specify a drive letter?
      OldDrive$ = LEFT$(OldSpec$, 2)   ' yes, use the drive they specified
    ELSE				' nope, use current drive
      ' won't be right if file found in APPEND path
      OldDrive$ = LEFT$(CURDIR$, 2)
    END IF
  END IF
  ' More initializations for the name parsing routine
  Entry$ = "": InLen% = LEN(InSpec$): ParseState% = 0: CHPos% = InLen%
  DO WHILE CHPos%
    SELECT CASE ParseState%
      CASE 0
          ' Whatever was entered after the last "\" is an entry name
          IF INSTR(":\", MID$(InSpec$, CHPos%, 1)) = 0 THEN
            Entry$ = MID$(InSpec$, CHPos%, 1) + Entry$
            CHPos% = CHPos% - 1
          ELSE
            ' We don't want to include the "\" in the next component
            ' we're going to parse, UNLESS the next component is
            ' going to be the root directory specification. 
            IF MID$(InSpec$, CHPos%, 1) = "\" THEN
              IF CHPos% > 1 THEN
                IF MID$(InSpec$, CHPos% - 1, 1) <> ":" THEN
                  CHPos% = CHPos% - 1
                END IF
              END IF
            END IF
            ParseState% = ParseState% + 1           ' next state
          END IF
      CASE 1
          ' Here, we build the path that leads the to entry name.
          IF INSTR(":", MID$(InSpec$, CHPos%, 1)) = 0 THEN
            Path$ = MID$(InSpec$, CHPos%, 1) + Path$
            CHPos% = CHPos% - 1
          ELSE
            ParseState% = ParseState% + 1
          END IF
      CASE 2
          ' Here, we build the drive specfication also
          ' (also, because the drive spec is part of the drive spec).
          Drive$ = MID$(InSpec$, CHPos%, 1) + Drive$
          Path$ = MID$(InSpec$, CHPos%, 1) + Path$
          CHPos% = CHPos% - 1
    END SELECT
  LOOP
  IF LEN(Drive$) = 0 THEN Drive$ = OldDrive$
END IF
END SUB
