'      FED - DEMO
'  Version III - demonstrates the use of a LEVEL parameter
'                to handle an entire record I/O in a loop and
'                one or 2 MFed CALLS - NO GOTOs!!!!!
'
'                Note that Macros are not actually used, just the
'                editting features of it.
'
'  Text input demo
'  Demonstrates the use of MFed and several other GLib routines
'
'  Author: Gizmo Mike
'  (C) InfoSoft, 1987, 1988, 1989
'


' define named common block for most FED variables
'
DECLARE FUNCTION MFed% (ed$, fsiz%, Macro$())
DECLARE FUNCTION ArgCnt%
DECLARE FUNCTION ArgVar$ (which%)
DECLARE FUNCTION NFrmat% (nst$, m%, p%)
DECLARE FUNCTION DlrFrmat% (nst$, m%, p%)

COMMON SHARED /MFedVars/ fg%, bg%, fgd%, bgd%, Alarm%, bad$, editted%, hatch%, nums%, num$, upcase%, Mac%, RngLo#, RngHi#

DECLARE SUB SaveScrn (SEG arry%)
DECLARE SUB RestScrn (SEG arry%)


    CLEAR
    DEFINT A-Z
    OPTION BASE 1

    hatch = 176                         ' define hatching character
    Mac = 0                             ' signal macros not used


    TYPE structure                      ' set up employee structure
	   NName AS STRING * 25
	   Phone AS STRING * 8
	   Addr AS STRING * 25
	   City AS STRING * 10
	   State AS STRING * 2
	   Zip AS STRING * 5
	   Dept AS STRING * 6
	   Superv AS STRING * 12
	   PFreq AS STRING * 1
	   PRate AS SINGLE
	   PIN AS INTEGER
    END TYPE

    DIM Emp AS structure             ' DIM emp as TYPE struct

    REDIM a$(11)                     ' temp holding for emp structures

    'make sure it is set up right
    CLS : SOUND 750, 2: LOCATE 5, 5
    PRINT "Depending on your display, you may want to restart this demo"
    LOCATE 7, 5
    PRINT "with the command line parameter [/CMD /NC] or [/CMD /C]. /NC for"
    LOCATE 9, 5
    PRINT "No Color, /C for color version."
    LOCATE 13, 5
    PRINT "Tap `S' to stop the demo, any other key to continue."

    GOSUB WaitKey

    IF ky$ = "S" OR ky$ = "s" THEN
	   SYSTEM
    END IF

    '*********** get command line parms and set colors
    q% = ArgCnt

    CMode = 1                           ' assume color
    FOR x = 1 TO q
	IF UCASE$(ArgVar$(x)) = "/NC" THEN
	    CMode = 0                   ' user wants no color
	    EXIT FOR
	END IF
    NEXT x

    IF CMode THEN                       ' find out if command line wants color
	fg = 2: bg = 0                    ' general colors
	fge = 12: bge = 3                 ' err message colors
	fgw = 14: bgw = 4                 ' window colors
	fgd = 10: bgd = 0                 ' data colors
	fgh = 15: bgh = 1                 ' help colors
	fgb = 4: bgb = 0                  ' box color
	fgt = 3: bgt = 0                  ' text colors
    ELSE
	fg = 7: bg = 0
	fge = 15: bge = 0
	fgw = 0: bgw = 7
	fgd = 15: bgd = 0
	fgh = 7: bgh = 15
	fgb = 15: bgb = 0
	fgt = 7: bgt = 0
    END IF

    eattr = (bge * 16) + fge              ' error message attributes
    wattr = (bgw * 16) + fgw              ' window attributes
    hattr = (bgh * 16) + fgh              ' help window attributes

    CALL WShadow(1)

    Adding = 0

    REM $DYNAMIC
    REDIM Sarry(4000)                     ' dimension screen array for 2 screens


    DIM hlp$(10)      ' String array to hold help screen msgs for use later.
				  ' Has to be DIMmed in code prior to other references
				  ' to hlp$().

    hlp$(1) = "Home - Start of line             End - End of line"
    hlp$(2) = "  "
    hlp$(3) = "Ctrl-X  Clear Field      Ctrl-End  Clear to end of line"
    hlp$(4) = "Ctrl-U  Undo             <Arrows> Fwd, Bkwd 1 field "
    hlp$(5) = "  "
    hlp$(6) = "       PgUp / Ctrl PgUp - Jump to first field "
    hlp$(7) = "       PgDn / Ctrl PgDn - Jump to last field  "
    hlp$(8) = "  "
    hlp$(9) = "[Esc] or [F9] Aborts Current Edit      [F10] Save Record"

    hlp$(10) = "[ Tap any key to continue ]"



prg.start:              '*************** start of program  *****************
    GOSUB GenDisp                        ' put screen mask on screen
    CALL SaveScrn(Sarry(1))                ' save it - RSTSCRN is quicker next time

    GOSUB OpenFil                        ' open the file

    IF hi = 0 THEN                       ' in case you lost the EMP.DAT file
	   GOSUB newfil
    END IF
    recno = hi                           ' get the top rec no

    GOSUB RecDisp                        ' display given record


'----------------------------------------------------------------------------
'  This is one big loop with several SELECT CASE constructs in it.
'
'  One CASE construct sets the level or a pointer to the field that we
'  are currently editing.
'
'  Based on that level, another CASE construct sets the FED parameters
'  for the next call.  ie if we are on level 2 (phone), then we need to
'  set nums ON.
'
'  One other CASE block intercepts those fields that need further data
'  verification and perfomrs that check.
'
'  The data is read from file into the TYPE structure and then stored
'  in a string array for the level pointer indexing, then stored BACK
'  to the TYPE structure for saving to disk.  You should not perform
'  I/O directly on TYPE elements.

'  The random access file code contained here is pretty minimal - just
'  enough to be able to demo FED.    In a "real" random file application,
'  there are a number of things that should be done in the way of checking
'  for valid data, also, there are  functions missing like to delete a
'  record (missing because it does not lend itself to demoing FED or GLIB
'  - this is not a QB tutor!).
'  There ARE several other GLIB functions used:
'  ERRMSG, DLRFRMAT, NFRMAT, WDW and a few others.
'---------------------------------------------------------------------------

    level = 1                           ' indicates active FIELD in record
    fsiz = 25                 ' first field siz
    rx = 4                    ' input location
    ry = 10
    Alarm = 1                 ' beeper on
    done = 0
    REDIM Macro$(1)

    DO
	LOCATE rx, ry                   ' locate current location
	PRINT a$(level)                 ' print string
	LOCATE rx, ry                   ' reset to SOS

	FCode = MFed(a$(level), fsiz, Macro$())
	' first, we want to intercept the 2 numeric inputs and
	' check them.  All validity checking would go here.

	SELECT CASE level
	    CASE 2                    ' check the phone
		temp$ = a$(2)

		DO
		    m = 1: p = 0          ' m sets NFRMAT mode, p is useless here
		    errc = NFrmat(temp$, m, p)
		    IF m <> 1 THEN         '  something went wrong !!
			' tell them of error
			CALL ERRMSG(temp$, 24, eattr%, 2)
			temp$ = a$(2)
			LOCATE rx, ry
			FCode = MFed(a$(level), fsiz, Macro$())
		    END IF
		LOOP UNTIL m = 1
		a$(2) = temp$

	    CASE 9
		IF INSTR("HS", a$(9)) = 0 THEN
		    CALL ERRMSG("Pay Frequency code must be H or S only.", 24, eattr%, 2)
		    ret$ = " "
		    CALL GetCH("HS", ret$)   ' mask the input
		    a$(9) = ret$
		END IF

	    CASE 10
		temp$ = a$(10)
		DO
		    m = 0: p = 2        ' set up for dollar formatting call
		    errc = DlrFrmat(temp$, m%, p%)

		    IF m <> 0 THEN                   ' if m is changed
			CALL ERRMSG(temp$, 24, eattr, 2)
			temp$ = a$(10)
			LOCATE rx, ry
			FCode = MFed(temp$, fsiz, Macro$())
		    END IF
		LOOP UNTIL m = 0

	    CASE ELSE
	END SELECT



	SELECT CASE FCode                ' handle the exit return first
	    CASE 0, 2                    ' down = enter for this
		level = level + 1

		' "wrap" from last to first field
		IF level > UBOUND(a$) THEN level = 1


	    CASE 1                       ' UP
		IF level - 1 > 0 THEN
		    level = level - 1
		END IF

	    CASE 11                        ' F1 key pressed (HELP)
		CALL SaveScrn(Sarry(2001))         ' save screen as is
		CALL wdw(7, 12, 17, 72, 1, 1, 2, hattr, "Editting Help")

		FOR x = 1 TO 9                   ' pop help window up
		    CALL QPrint(hlp$(x), 7 + x, 14, hattr%)
		NEXT x                           ' QUIKPRT help msgs
		LOCATE 18, 30: COLOR fgh, bgh: PRINT hlp$(10)

		GOSUB WaitKey                    ' wait for any key
		CALL RestScrn(Sarry(2001))        ' restore pre help screen


	    CASE 13, 14                          ' F3 page back a record. F$ = FORWARD
		IF editted THEN                  ' they have changed something
		    CALL ERRMSG("You cannot PAGE until current edit is saved.", 24, eattr%, 2)
		END IF

		IF FCode = 13 THEN
		    IF recno > 1 THEN recno = recno - 1      ' back up a record
		ELSE
		    IF recno < hi THEN recno = recno + 1     ' forward a record
		END IF

		CALL RestScrn(Sarry(1))           ' restore blank screen (bleed thru)
		GOSUB RecDisp                    ' display desired record
		level = 1                        ' set to start with name


	    CASE 17                                  ' F7 add a record
		IF editted <> 0 THEN
		    CALL ERRMSG("Cannot ADD until current EDIT is saved.", 24, eattr, 2)
		ELSE
		    IF Adding THEN           ' this is a toggle
			Adding = 0
		    ELSE
			Adding = 1
			REDIM a$(11)         ' clear out what is in there
		    END IF
		END IF

		IF Adding THEN
		    recno = hi + 1           ' increment record pointer

		    CALL RestScrn(Sarry(1))   ' show input screen mask
		    GOSUB show.rec           ' display it

		    ' change display to show how to STOP adding
		    COLOR fgt
		    LOCATE 19, 10: PRINT "[F1] - Help         [F7] - Stop Adding        [F10] - Save"
		    COLOR fg
		    SOUND 1500, .3
		    level = 1
		ELSE
		    COLOR fgt
		    LOCATE 19, 10: PRINT "[F1] - Help         [F7] - Add record         [F10] - Save"
		    COLOR fg
		    SOUND 1500, .3      ' get their attention that F7
								' function changed
		    CLOSE
		    GOSUB OpenFil       ' get top record number
		    recno = hi
		    GOSUB RecDisp       ' display highest Record
		    level = 1
		END IF


	    CASE 18                      ' F8 - quit demo
		CLOSE
		SYSTEM


	    CASE 9, 19                  ' F9, ESC
		recno = 1                   ' this should have a "ARE YOU SURE"
		level = 1
		GOSUB RecDisp               ' prompt if it was more than demo
						 
	    CASE 20                         ' F10 save record
		GOSUB closefil              ' Put rec to file and close it
		editted = 0                  ' reset the edit flag
		GOSUB show.rec              ' show the new version
		level = 1


	    CASE 3, 5                     'Pg Up or ^Pg Up
		level = 1

	    CASE 4, 6                     'Pg Dn or ^Pg Dn
		level = UBOUND(a$)         ' set to edit LAST field

	    CASE ELSE                        ' handles all other fed codes

	END SELECT

	nums = 0
	upcase = 0


	SELECT CASE level         ' now set FED variables/based on next field
	    CASE 1
		rx = 4: ry = 10: fsiz = 25: upcase = 1

	    CASE 2
		rx = 4: ry = 57: fsiz = 8: nums = 1: num$ = "1234567890-"

	    CASE 3
		rx = 6: ry = 13: Alarm = 1: fsiz = 25

	    CASE 4
		rx = 8: ry = 10: Alarm = 1: fsiz = 10

	    CASE 5
		rx = 8: ry = 42: Alarm = 0: fsiz = 2

	    CASE 6
		rx = 8: ry = 60: Alarm = 0: fsiz = 5
		nums = 1: num$ = "1234567890"

	    CASE 7
		rx = 12: ry = 16: Alarm = 1: fsiz = 6

	    CASE 8
		rx = 12: ry = 57: Alarm = 1: fsiz = 12

	    CASE 9
		rx = 14: ry = 41: Alarm = 1: fsiz = 1: nums = 1
		num$ = "1234567890"

	    CASE 10
		rx = 14: ry = 70: Alarm = 0: fsiz = 6: nums = 1
		num$ = "1234567890.$"

	    CASE 11
		rx = 16: ry = 17: Alarm = 0: fsiz = 4: nums = 1
		num$ = "1234567890"

	    CASE ELSE
	END SELECT
    LOOP UNTIL done



    SYSTEM

'================================[ SUBROUTINES ]==============================

OpenFil:         '-----------   open demo file statements  ---------
    OPEN "emp.dat" FOR RANDOM AS #1 LEN = LEN(Emp)
    sof = LOF(1) / LEN(Emp)               ' sof is number of records in file
    hi = sof                              ' hi is high record number
RETURN


closefil:       '-------------   store the record ---------------
    IF editted OR Adding THEN       'no need to save if not changed !
	   Emp.NName = a$(1)
	   Emp.Phone = a$(2)
	   Emp.Addr = a$(3)
	   Emp.City = a$(4)
	   Emp.State = a$(5)
	   Emp.Zip = a$(6)

	   Emp.Dept = a$(7)
	   Emp.Superv = a$(8)
	   Emp.PFreq = a$(9)
	   Emp.PRate = VAL(a$(10))
	   Emp.PIN = VAL(a$(11))
    END IF
    PUT #1, recno, Emp                  ' move record to buffer
    CLOSE #1                            ' actually put file to disk
    GOSUB OpenFil                       ' open file again in updated state
    editted = 0
RETURN


		 '---------- put selected record to the screen  -----------
RecDisp:
			   ' convert to memory variable to edit a COPY
			   ' of each and strip trailing blanks, assign to temp
			   ' array storage
    GET #1, recno, Emp

    a$(1) = RTRIM$(Emp.NName)
    a$(2) = RTRIM$(Emp.Phone)
    a$(3) = RTRIM$(Emp.Addr)
    a$(4) = RTRIM$(Emp.City)
    a$(5) = RTRIM$(Emp.State)
    a$(6) = RTRIM$(Emp.Zip)
    a$(7) = RTRIM$(Emp.Dept)
    a$(8) = RTRIM$(Emp.Superv)
    a$(9) = RTRIM$(Emp.PFreq)

    a$(10) = LTRIM$(RTRIM$(STR$(Emp.PRate)))
    errc = DlrFrmat(a$(10), 2, 0)

    a$(11) = LTRIM$(RTRIM$(STR$(Emp.PIN)))



show.rec:                  ' display the record
    IF editted THEN                      ' This part is not critical,
	COLOR bgb, fgb                 '  but shows user when current
	LOCATE 1, 35                   '  record is different from data
	PRINT " [ EDITING ] "          '  in file.
    ELSE
	COLOR fgb, bgb
	LOCATE 1, 35
	PRINT STRING$(15, 205);
    END IF
    COLOR fg, bg


    COLOR fg, bg
    LOCATE 4, 10: PRINT a$(1)
    LOCATE 4, 57: PRINT a$(2)
    LOCATE 6, 13: PRINT a$(3)
    LOCATE 8, 10: PRINT a$(4)
    LOCATE 8, 42: PRINT a$(5)
    LOCATE 8, 60: PRINT a$(6)
 
    LOCATE 12, 16: PRINT a$(7)
    LOCATE 12, 57: PRINT a$(8)
    LOCATE 14, 41: PRINT a$(9)
    LOCATE 14, 70: PRINT a$(10)
    LOCATE 16, 17: PRINT STRING$(4, 254)
    LOCATE 16, 71: COLOR fgw, 0: PRINT recno%
    COLOR fg, bg
    editted = 0        ' set edit flag to show that record on screen is same as file

RETURN



GenDisp:
'---------------------------------------------------------------------------
'*  Routine to put general display on the screen, this is used once.  After
'*  it is put to the screen, it is saved via SVSCRN, and restored from there
'*  rather than doing all these PRINTs again.                  
'---------------------------------------------------------------------------

    CALL boxes(1, 1, 25, 80, 1, fgb)           ' put a big box on screen
    COLOR fgt + 8
    LOCATE 2, 25: PRINT "XYZ Corporation Employee Data File"      ' a title
    COLOR fgt
    LOCATE 4, 4: PRINT "Name: "
    LOCATE 4, 50: PRINT "Phone: "
    LOCATE 6, 4: PRINT "Address: "
    LOCATE 8, 4: PRINT "City: "
    LOCATE 8, 35: PRINT "State: "
    LOCATE 8, 55: PRINT "Zip: "
    LOCATE 12, 4: PRINT "Department: "
    LOCATE 12, 45: PRINT "Supervisor: "
    LOCATE 14, 4: PRINT "Hourly / Salary Level (H or S only): "
    LOCATE 14, 60: PRINT "Pay Rate: "
    LOCATE 16, 55: PRINT "Record Number: ";


    LOCATE 16, 4: PRINT "4 Digit PIN: "
    COLOR 4, 0: LOCATE 17, 1: PRINT CHR$(199) + STRING$(78, 196) + CHR$(182)
    COLOR fgt + 8: LOCATE 18, 30: PRINT "Editing Keys:": COLOR fgt

    LOCATE 19, 10: PRINT "[F1] - Help         [F7] - Add Record         [F10] - Save"
    LOCATE 20, 10: PRINT "[F3] - Page back one record   [F4] - Page forward one record"
    LOCATE 21, 10: PRINT "       [F8] - Quit                   [F9] - Abort Edit"
    LOCATE 22, 10: PRINT "[Enter] - Advances a field.   [PgDn] - Jump to last field"
    LOCATE 23, 5: PRINT "[PgUp] - Jump to first field   <Arrow Keys> Advance or back up one field."

  RETURN



newfil:       '---------------- make a new file if demo one got lost  -------
   a$(1) = "JIM LOTUS"
   a$(2) = "555-0123"
   a$(3) = "1432 OAK STREET"
   a$(4) = "CENTERVILE"
   a$(5) = "MA"
   a$(6) = "01234"
   a$(7) = "EXEC."
   a$(8) = "NONE"
   a$(9) = "S"
   a$(10) = "900.00"
   a$(11) = "1234"

   recno = 1
   editted = 1
   GOSUB closefil
RETURN

WaitKey:             '--------loop until a key is pressed - handy to have
    ky$ = INPUT$(1)
RETURN

EditMac:
    ' sample sub routine to edit a macro defintition on the fly.
    ' Using one of the MFed 'soft keys' like a function key, open
    ' a window or otherwise ask the user to press the key combination
    ' they want to change.
    '
    ' On entry, that captured combination should be in MacEd$
    ' MacLen should be the maximum legal length of the Macro

    MacErr = 0                          ' clear any previous error
    IF LEN(MacEd$) = 2 THEN             ' check for valid extended key combo
	MacEd = ASC(RIGHT$(MacEd$, 1))

	SELECT CASE MacEd
	    CASE 1 TO 10, 15 TO 23, 29 TO 35
	    CASE ELSE
		MacErr = 1              ' unsupported extended stroke
	END SELECT
    ELSE
	MacErr = 1
    END IF

    IF MacErr THEN
	' insert your error handler here for invalid
	' key combo pressed
    END IF

    OldMac = Mac                        ' save old Mac setting
    Mac = 0                             ' disable for now
    mtemp$ = Macro$(MacEd)
    MFCode = MFed(mtemp$, MacLen, Macro$())

    IF MFCode <> 15 THEN                ' esc does not save new defintition
	Macro$(MacEd) = temp$
    END IF

    ' your real program should also ask if they want to save the new
    ' defintition, and if so, you could write back to disk using SaveMac

REM $STATIC
SUB EditMac (MacEd$, MacLen%, Macro$())
    ' sample sub routine to edit a macro defintition on the fly.
    ' Using one of the MFed 'soft keys' like a function key, open
    ' a window or otherwise ask the user to press the key combination
    ' they want to change.
    '
    ' On entry, that captured combination should be in MacEd$
    ' MacLen should be the maximum legal length of the Macro

    IF LEN(MacEd$) = 2 THEN             ' check for valid extended key combo
	MacEd = ASC(RIGHT$(MacEd$, 1))

	SELECT CASE MacEd
	    CASE 1 TO 10, 15 TO 23, 29 TO 35
		MacErr = 0              ' clear any previous error

	    CASE ELSE
		MacErr = 1              ' unsupported extended stroke
	END SELECT
    ELSE
	MacErr = 1
    END IF

    IF MacErr THEN
	' insert your error handler here for invalid
	' key combo pressed
    END IF

    OldMac = Mac                        ' save old Mac setting
    Mac = 0                             ' disable for now
    mtemp$ = Macro$(MacEd)
    MFCode = MFed(mtemp$, MacLen, Macro$())

    IF MFCode <> 15 THEN                ' esc does not save new defintition
	Macro$(MacEd) = temp$
    END IF

    ' your real program should also ask if they want to save the new
    ' defintition, and if so, you could write back to disk using SaveMac

    ' also maybe restore the screen from the Macro edit I/O


END SUB

SUB MacRead (MacFil$, Macro$())
    ' this sample sub rotuine demonstates how you can read a macro
    ' file into the Macro array.
    '
    ' Enter with MacFil$ holding the name of the disk file holding the
    ' macro defintitions.  Of course, the macros could be hard coded
    ' into the program but flexibility to allow the user to unload and
    ' reload new defintitions is lost (as might be required in sophisticated
    ' database programs where common city names can be loaded for specific
    ' states).

    m = FREEFILE                        ' request a file number
    REDIM Macro$(1 TO 35)               ' set up array, removing old defs
    OPEN MacFil$ FOR INPUT AS #m

    FOR x = 1 TO 10                     ' read defs for Alt-Q to Alt-P
	LINE INPUT #m, Macro$(x)
    NEXT x

    FOR x = 15 TO 23                     ' read defs for Alt-A to Alt-L
	LINE INPUT #m, Macro$(x)
    NEXT x

    FOR x = 29 TO 35                     ' read defs for Alt-Z to Alt-M
	LINE INPUT #m, Macro$(x)
    NEXT x

    CLOSE #m

END SUB

SUB MacWrite (Macro$(), MacFil$)
    ' this sample sub rotuine demonstates how you can write a macro array
    ' to a disk file.  This may be needed after editting a macro on the fly.
    '
    ' Enter with MacFil$ holding the name of the disk file to write to,

    m = FREEFILE                        ' request a file number
    OPEN MacFil$ FOR OUTPUT AS #m

    FOR x = 1 TO 10                     ' write defs for Alt-Q to Alt-P
	PRINT #m, Macro$(x)
    NEXT x

    FOR x = 15 TO 23                    ' write defs for Alt-A to Alt-L
	PRINT #m, Macro$(x)
    NEXT x

    FOR x = 29 TO 35                    ' write defs for Alt-Z to Alt-M
	PRINT #m, Macro$(x)
    NEXT x

    CLOSE #m


END SUB

