{  PRTSCR.PAS - Unit to allow programs to 'see' Print Screen key   }
{  Copyright 1990 S/Wizardry, Ltd.                                 }
UNIT PrtScr;

INTERFACE

CONST
   PrtScrKey = $3700;


IMPLEMENTATION

USES DOS;

VAR
   SaveInt5 : POINTER;
   SaveExitProc : POINTER;

CONST
   Int5Installed : BOOLEAN = FALSE;


PROCEDURE Int5; INTERRUPT;
VAR
   Regs : REGISTERS;
BEGIN
   Regs.AH := $5;
   Regs.CX := PrtScrKey;
   INTR($16,Regs);
END;

PROCEDURE InstallInt5;
BEGIN
   IF NOT Int5Installed THEN BEGIN
      GetIntVec($5, SaveInt5);
      SetIntVec($5, @Int5);
      Int5Installed := TRUE;
   END;
END;

PROCEDURE RestoreInt5;
BEGIN
   IF Int5Installed THEN BEGIN
      SetIntVec($5,SaveInt5);
      Int5Installed := FALSE;
   END;
END;

{$F+}
PROCEDURE NewExitProc;
BEGIN
   ExitProc := SaveExitProc;
   RestoreInt5;
END;
{$F-}

BEGIN {UNIT initialization}
   InstallInt5;
   SaveExitProc := ExitProc;
   ExitProc := @NewExitProc;
END.
