// Listing 1: bitvect.h
// Header file for the bit vector class.
// Copyright (C) 1991 by Nicholas Wilt.  All rights reserved.

class BitVect {
  unsigned char *vect;		// Vector that contains the bits
  int numbytes; 		// Number of bytes in vect
  long numbits; 		// Number of bits in vector

public:
  // Copy constructor.
  BitVect(const BitVect&);

  // Constructor takes the number of elements in the bit vector.
  BitVect(long n);

  // Constructor takes the number of elements in the bit vector
  // and the initial value to give all the bits.
  BitVect(long n, int val);

  ~BitVect();

  // Functions to extract bits out of the vector.
  int operator[] (long);	// Subscripts into the bit vector
  int GetBit(long);		// Same as overloaded [].

  // Sets bit to 1 or 0 (1 if val is nonzero, 0 otherwise).
  void SetBit(long inx, int val);
  void SetRange(long min, long max, int val);

  // Boolean operations on bit vectors using overloaded operators.
  BitVect operator~ ();
  BitVect& operator|= (BitVect& x);
  BitVect& operator&= (BitVect& x);
  BitVect& operator-= (BitVect& x);
  friend BitVect operator| (BitVect& x, BitVect& y);
  friend BitVect operator& (BitVect& x, BitVect& y);
  friend BitVect operator- (BitVect& x, BitVect& y);
};
