{ adunit.pas -- After Dark TPW support unit by Tom Swan }

unit ADUnit;

interface

uses WinTypes;

const

{- Control messages }
  initialize     = 0;
  blank          = 1;
  drawFrame      = 2;
  adClose        = 3;
  moduleSelected = 5;
  about          = 6;
  buttonMessage  = 7;
  preInitialize  = 12;

{- Error return codes }
  noError        = 0;
  mem_Error      = 1;
  restart_me     = 3;
  wake_up        = 5;
  user_error     = 7;

{- Palette request return codes }
  hsv_Pal        = 10;
  rgb_Pal        = 11;
  white_Pal      = 12;
  primary_Pal    = 13;

{- Screen saver mode }
  saver          = 0;
  demo           = 1;

{- Processor type }
  cpu_086        = 0;
  cpu_186        = 1;
  cpu_286        = 2;
  cpu_386        = 3;
  cpu_486        = 4;

{- Operating mode }
  realMode       = 0;
  standard       = 1;
  enhanced       = 2;

{- Module being run by: }
  afterDark      = 0;
  randomizer     = 1;

type
  Pad_System = ^Tad_System;   { Pointer to following record }
  Tad_System = record
    iOperatingMode: Integer;  { Real, standard, enhanced mode }
    iProcessorType: Integer;  { 8086, 80186, 80286, 80386, 80486}
    bCoProcessor: Bool;       { True if coprocessor present }
    ptScreenSize: TPoint;     { Screen resolution in pixels }
    iBitsPerPixel: Integer;   { Color resolution (pixel depth) }
    ptAspect: TPoint;         { Monitor aspect ratio (X / Y) }
    ptDotsPerInch: TPoint;    { Number of pixels per inch }
    iADVersion: Integer;      { After Dark version number }
    rDemoRect: TRect;         { Control panel rect in demo mode }
    iSaverMode: Integer;      { AD mode: "saver" or "demo" }
    hModuleInfo: THandle;     { Module-specified record handle }
    lpszErrorMessage: PChar;  { Pointer to custom error string }
    hADWnd: HWnd;             { Control panel window handle }
    iRunner: Integer;         { Controller: AD or Randomizer }
  end;

  Pad_Module = ^Tad_Module;   { Pointer to following record }
  Tad_Module = record
    hDrawRgn: HRGN;           { Region in which to draw }
    ptRgnSize: TPoint;        { Region drawing size }
    iControlValue: array[0 .. 3] of Integer; { Control settings }
    iControlID:    array[0 .. 3] of Integer; { Control IDs }
    hModule: THandle;         { DLL module's handle }
    hPalette: HPalette;       { Handle to palette (if used) }
    lpLogPalette: PLogPalette;{ Pointer to palette (if used) }
  end;

var
  HLibInst: THandle;    { Handle to DLL instance }
  DC: HDC;              { Display context }
  HSystem: THandle;     { Handle to system parameters }
  LpSystem: Pad_System; { Pointer to system parameters }
  LpModule: Pad_Module; { Pointer to module parameters }

implementation

end.


{--------------------------------------------------------------
  Copyright (c) 1991 by Tom Swan. All rights reserved.
  Revision 1.00    Date: 6/12/1991
---------------------------------------------------------------}
