/* TESTHP.C
   test huge pointers for "normalization"
   and correct comparison.

   by Terrence Vaughn  */

#include <stdio.h>
void huge *normalize(void huge *);

main() {

 char far *cp;
 char huge *hp, huge *hp1;
 long l;

 cp = (char far *)0x2FFF00F2L; /* An easily visible addresss */
 hp = (char huge *)cp;         /* Normalized * = 300E:0002   */
 /* Did the cast have any effect? */
 printf("far * =  %Fp\n",cp);
 printf("huge * = %Fp\n",hp);
 hp1 = hp;
 hp1+=0;                      /* This works with TurboC */
 printf("huge * +0 = %Fp\n",hp1);
 hp1 = normalize(hp);         /* Force normalization  */
 printf("Normalized * = %Fp\n",hp1);
 if(hp == hp1) printf("Pointers equal.\n");
 else printf("Pointers not equal.\n");
 l = (long)(hp1 - hp);        /* Test pointer subtraction */
 printf("%s subtraction= %li\n\n", (l) ? "Incorrect":"Correct", l);
}

void huge *normalize(void huge *hp) {

 unsigned long base, para;

 base = (unsigned long) hp&0xFFFF000FL;
 para = (unsigned long) hp&0x0000FFF0L;
 para <<= 12;
 return(void huge *)(base + para);
}
