; Listing 1: cputype.asm
; Copyright (C) 1990 Nicholas Wilt.  All rights reserved.

.MODEL LARGE,C

.386

.CODE

; cputype: function returns 0 if 8088 family,
;			    1 if 80286 family,
;			    2 if 80386 or better.
; No arguments.
; Returns value in AX.

	PUBLIC	cputype

cputype PROC
	xor	dx,dx		; Assume 8086 for now
	push	dx		; flags <- 0
	popf			;
	pushf			; Get flags back
	pop	ax		;
	and	ax,0f000h	; If the top 4 bits are set,
	cmp	ax,0f000h	;
	je	quitcputype	; return.  It's an 8086.
	inc	dx		; It's at least an 80286.
	push	0F000h		; flags <- 0F000h
	popf			;
	pushf			; Get flags back
	pop	ax		;
	and	ax,0F000h	; If the top 4 bits aren't set,
	jz	quitcputype	; it's an 80286
	inc	dx		; Otherwise it's a 386 or better
quitcputype:
	xchg	ax,dx		; Return value in AX
	ret			; Return
cputype ENDP

	END
