

XSUM			User's Manual			XSUM


NNAAMMEE
	crc, mdx - generate checksums of a file or files

SSYYNNOOPPSSIISS
	ccrrcc _f_i_l_e_s_p_e_c _._._.
	mmddxx [--44] [--55] _f_i_l_e_s_p_e_c _._._.

VVEERRSSIIOONN
	_c_r_c version 11..0066
	_m_d_x version 11..0033

DDEESSCCRRIIPPTTIIOONN
	_c_r_c and _m_d_x compute the checksum of a file or a set of files.
	_c_r_c computes the 32-bit Cyclical Redundacy Check (CCRRCC--3322) and
	_m_d_x computes the 128-bit Message Digest (MMDD44 or MMDD55).
	Running either one with no parameters will give a quick
	summary of function and options.

OOUUTTPPUUTT
	The output of both programs is written to standard output
	(ssttddoouutt), and can be redirected to a file.  The title and
	any error messages will be sent to standard error (ssttddeerrrr).

	The output of _c_r_c is formatted as:

		e0c8a642 : filename

	and the output of _m_d_x is formatted as:

		e0c8a642e0c8a642e0c8a642e0c8a642  MD_x  filename

	where _x is replaced by 5 or 4 to indicate MMDD55 or MMDD44.

OOPPTTIIOONNSS
	_f_i_l_e_s_p_e_c	The name of a file or a pattern which matches
			several files.  The drive and path may be
			specified, and there is no limit to the number
			of files matched.  Also, as many filenames or
			patterns as will fit on the command line may
			be given.

	The following options apply only to _m_d_x.

	_-_4		Use the MD4 algorithm.

	_-_5		Use the MD5 algorithm (default).

	The _-_4 and _-_5 options may be used more than once on the command
	line.  Whichever was last given affects which algorithm is used,
	is used, so MMDD44 and MMDD55 message digests can be computed on the
	same run.  For example,

		mmddxx --44 **..eexxee **..ccoomm **..ssyyss --55 **..ttxxtt **..ddoocc **..mmaann

	would calculate the MMDD44 digests of all the programs in the
	current directory, and the MMDD55 digests of all the text.  Or,


								1




XSUM			User's Manual			XSUM



		mmddxx ffoooo..bbaarr --44 ffoooo..bbaarr

	would calculate both numbers for the file ffoooo..bbaarr.

EERRRROORRSS
	All errors are of the form pprrgg:: mmeessssaaggee where pprrgg is either
	_c_r_c or _m_d_x.

	pprrgg: error opening file nnaammee

		The file nnaammee could not be opened for reading.  It
		may be locked by another application.

	pprrgg: error reading file nnaammee

		An error occurred while reading file nnaammee.  The
		disk may be damaged.

	pprrgg: no files found to process

		None of the _f_i_l_e_s_p_e_c's given on the command line
		matched any files.

	pprrgg: program has been modified

		On startup, the program checks itself to see if it
		has been modified.  This provides some protection
		against viruses however it will not detect stealth
		viruses.

		If the self-check fails, the program displays this
		message and exits.

	pprrgg: integrity cannot be verified

		If the self-check cannot be performed then this message
		is displayed, and the program continues.  This could
		happen if the self-checking information is tampered
		with, or if the program is run under DOS 2.x.


















								2




XSUM			User's Manual			XSUM


AAUUTTHHOORR
	crc and mdx were written by David R. Conrad, who can be reached
	in the following ways, in order of preference:

		Internet	David_Conrad@mts.cc.wayne.edu
		UUCP		tygra.michigan.com!dave
		Mail		432 Alter Rd.
				Detroit, MI 48215-3105 USA

LLEEGGAALLIITTIIEESS
	_c_r_c and _m_d_x are Copyright 1993 David R. Conrad.
	All rights reserved.

	The CCRRCC--3322 implementation used was extracted from the source
	of bbrriikk by Rahul Dhesi, and is from the zzmmooddeemm source code,
	and is Copyright 1986 Gary S. Brown.  Used with permission.

	MMDD44 is the RSA Data Security, Inc. MD4 Message-Digest Algorithm,
	Copyright 1990 RSA Data Security, Inc.  Used with permission.

	MMDD55 is the RSA Data Security, Inc. MD5 Message-Digest Algorithm,
	Copyright 1991 RSA Data Security, Inc.  Used with permission.

	David R. Conrad hereby disclaims all warranties relating to
	this software, whether express or implied, including without
	limitation any implied warranties of merchantability or fitness
	for a particular purpose.  I will not be liable for any special,
	incidental, consequential, indirect or similar damages due to
	loss of data or any other reason.  In no case can Rahul Dhesi,
	Gary S. Brown, or RSA Data Security, Inc. be held liable in any
	way for damages resulting from the use of this software or
	otherwise related to this software.

	_c_r_c and _m_d_x are freeware, meaning that they are copyrighted
	but can be used and distributed free of charge, as long as they
	are distributed in an unmodified form.






















								3


