#include "calc.h"

#define TABLE_SIZE  256

static unsigned int crc16tab[TABLE_SIZE];
static unsigned long crc32tab[TABLE_SIZE];

void make_table(void)
{
  int i, inx;
  int carry16, carry32;
  unsigned int entry16;
  unsigned long entry32;

  for (inx = 0; inx < TABLE_SIZE; ++inx) {
    entry16 = inx;
    entry32 = inx;

    for (i = 0; i < 8; ++i) {
      carry16 = entry16 & 1;
      entry16 >>= 1;
      if (carry16)
        entry16 ^= 0xa001;

      carry32 = entry32 & 1;
      entry32 >>= 1;
      if (carry32)
        entry32 ^= 0xedb88320;
    }

    crc16tab[inx] = entry16;
    crc32tab[inx] = entry32;
  }
}

void update_crc(char *buf,
                int count,
                unsigned int *crc16,
                unsigned long *crc32)
{
  int i;
  unsigned char inx16, inx32;

  if (count == 0)
    return;

  for (i = 0; i < count; ++i) {
    inx16 = buf[i] ^ *crc16;
    *crc16 >>= 8;
    *crc16 ^= crc16tab[inx16];

    inx32 = buf[i] ^ *crc32;
    *crc32 >>= 8;
    *crc32 ^= crc32tab[inx32];
  }
}
