;;
;; Copyright 1991 Alexander Pruss
;;
.model tiny,C

.data
decoded_to_end db 0
file_size_mod3 db 0
public decoded_to_end, file_size_mod3

.code

CodeTop = 34
uudecode_block proc
public uudecode_block
       arg block:word,len:word
       push si
       push di
       mov si,block
       mov di,si
       mov bx,len
       add bx,si
uuTop:
       cmp si,bx
       jae uuDone
       lodsb
       or al,al
       jz uuDone
       cmp al,CodeTop-1
       jz uuEnd
       sub al,CodeTop
       jb uuTop ; Skip what we do not understand
       cmp al,64
       jae uuTop
       mov ah,al
       lodsb
       sub al,CodeTop
       rcr ah,1   ; carry clear
       rcl al,1
       rcr ah,1
       rcl al,1   ; Whee!  al is now right for byte 1
       stosb
       lodsb
       sub al,CodeTop
       rcr ah,1
       rcl al,1
       rcr ah,1
       rcl al,1   ; Whee!  al is now right for byte 2
       stosb
       lodsb
       sub al,CodeTop
       rcr ah,1
       rcl al,1
       rcr ah,1
       rcl al,1   ; Whee!  al is now right for byte 3
       stosb
       jmp uuTop
uuDone:
       mov decoded_to_end,0
uuRet:
       mov ax,di
       sub ax,block
       pop di
       pop si
       ret
uuEnd:
       mov decoded_to_end,1
       lodsb
       sub al,'0'
       mov file_size_mod3,al
       jmp uuRet
uudecode_block endp

Skip1:
       dec si
       jmp nTop
ndecode_block proc
public ndecode_block
       arg block:word,len:word
       push si
       push di
       mov si,block
       mov di,si
       mov bx,len
       add bx,si
nTop:
       cmp si,bx
       jae nDone
       lodsw
       or al,al
       jz nDone
       cmp al,'Z'
       jz nEnd
       cmp ax,0a0dh
       jz nTop
       cmp al,0dh
       jz Skip1
       cmp al,0ah
       jz Skip1
       sub ax,'AA'
       shl ah,1
       shl ah,1
       shl ah,1
       shl ah,1
       or al,ah
       stosb
       jmp nTop
nDone:
       mov decoded_to_end,0
nRet:
       mov ax,di
       sub ax,block
       pop di
       pop si
       ret
nEnd:
       mov decoded_to_end,1
       jmp nRet
ndecode_block endp

       end
