/* This program joins the smaller files created by the CHOP program
   back into the original input file

   USAGE: JOIN FILENAME [INPATH] -SWITCHES
   Version 1.02.  Written by Edgar Swank using some code by W. J. Kennamer
                  and released into the public domain.
      Note: this source is for IBM/MS C Compiler.
            Compile with HUGE memory model /AH.
     FILENAME is any valid MS-DOS filename.  Wildcards are not supported.
     This will be the single output filename.
     Input file names will be FILENAME.1, FILENAME.2, etc.
     Program will stop when FILENAME.n is not found, or when Esc is entered
     in response to prompt from -w option.
     Terminating <ctrl>Z is removed from Input files
     UNLESS -b is specified.

     Terminating <ctrl>Z is added to Output files       <11/7/91>
     ONLY if -e is specified AND -b is NOT specified.

     INPATH is an optional disk/pathname (A: or \path\ or a:\path\)
     to get input files on a different disk and/or directory from output file.
     SWITCHES must follow the FILENAME and INPATH parameters,
       and may be entered in any order.  Switches may be combined.
     Valid SWITCHES are:
       -b  binary     do not remove ^z from input files.
       -e  eof        add ^z to output file.
                      Note: may interfere with appending
                      to output file.
       -w  wait       wait before opening each input file.
                       can change input diskette if separate from output.

File pointer fp1 is the output file.  fp2 is always the input
   file, though its name changes as new input files are
   opened.

*/

#include  <fcntl.h>
#include  <dos.h>
#include  <stdio.h>
#include  <conio.h>
#include  <ctype.h>
#include  <string.h>
#include  <malloc.h>
#include  <stdlib.h>

#define VERSION "1.02"
#define PROGNAME "JOIN"
#define CTRL_Z   0x1a
#define VOID     int
#define CR       0x0d
#define LF       0x0a
#define ESC      0x1b
#define OFF   0
#define ON   1

int binary = OFF;                   /* do not remove EOF                */
int wait   = OFF;                   /* Wait before each input file open */
int weof   = OFF;                   /* Write EOF ^z to output file      */
int c;                              /* current character                */
int j;                              /* index                            */
int i,u;
long inpleft;                       /* Bytes input left to read         */
long inplimit;                      /* Bytes input left to read low lim */
long bfsiz;                         /* I/O buffer size                  */
long bread;                         /* Bytes read into buffer           */
long pbread;                        /* Bytes read this partition        */
long bwrit;                         /* Bytes written from buffer        */
long pbwrit;                        /* Bytes written this partition     */

long size = 0;                      /* partition value -- file size     */
long byte_count = 0;                /* total bytes in original file     */
long inpfz = 0;                     /* total bytes in original file     */
long out_file_size = 0;             /* total bytes in output file       */

char *bfpa[20];                     /* I/O buffer pointer array         */

FILE *fp1,*fp2;                     /* fp1=output, fp2=input            */
int derno,erno;

 int bfx;                           /* buffer array index               */
 int num_input_files = 0;           /* no of files successfully read    */
 int length;                        /* length of matching string        */
 int int_size;                      /* integer for file size            */
 int nmb;                           /* number of 16k blocks IO          */
 unsigned int  w;

 char *p;                           /* pointer to switch string         */
 char *period_p;                    /* location of period in filename   */
 char *input_file;                  /* input file name                  */
 char filename[80];                 /* original file name               */
 char fnwork[80];                   /* workarea for file name           */
 char outfilename[80];              /* output file name                 */

 char inpath[64];                   /* optional input disk/path         */
 char line1[80];                    /* data buffer                      */
 char line2[30];                    /* data buffer                      */
 char *switches;                    /* string to hold switches          */

 VOID help();
 VOID close_out();
 VOID delete_files();
 VOID block_read();
 VOID block_write();
 VOID copy_to_eol();
 VOID construct_input_filename();
 VOID Open_Next_Input_File();
 VOID set_switches();

main(argc,argv)
int argc;
char *argv[];
   {


   /* test code to prints args **********
   printf("ARGC=%d\n",argc);
   for (j=0;j<argc ;j++ )
   {
   printf("ARGV[%d]=%s\n",j,argv[j]);
   }
   ***************************************/
   bfsiz=0;
   for (nmb=1;nmb<=20 ;nmb++ )
   {
   bfpa[nmb-1]=malloc(16384);
   if (bfpa[nmb-1]==NULL)
    {
   break;
    }
    else
    {
   bfsiz=(long)nmb*16384;
    }
   } /*for (nmb=1;nmb<=10 ;nmb++ )*/
   nmb--;
   if (nmb==0)
   {
    printf ("Insufficient Memory for I/O Buffer.\n");
    exit(8);
   }
   else
    printf ("%ld (%u*16384) bytes allocated for I/O Buffers.\n",bfsiz,nmb);


   if( argc > 4 || argc < 2 || strcmp(argv[1],"-?")==0
                            || strcmp(argv[2],"-?")==0
                            || strcmp(argv[3],"-?")==0 )
      {
      help();
      exit(1);
      }

   /* see which argument is the switch */
   switches = line2;
   strcpy(switches,"");
   for (j=2;j<argc;j++)
   {
   if( argv[j][0]=='-')
      {
      strcpy(switches,argv[j]);
      break;
      }
    } /*for*/
    if (j>2)
     strcpy(inpath,argv[2]);
    else
     inpath[0]=0;

     set_switches();

     strcpy(filename,argv[1]);
     strcpy(outfilename,argv[1]);

     period_p = strchr(filename,'.');         /* locate the period, if any */

     if( period_p != NULL )
        *period_p = '\0';                     /* chop off the period  */

     if (inpath[0]!=0)                       /* if inpath specified */
       construct_input_filename();

     Open_Next_Input_File();

     if( (fp1 = fopen(argv[1],"wb") ) == NULL)
        {
        printf("Cannot open %s for output.\n",argv[1]);
        printf("Exiting the program.\n");
        exit(1);
        }
      else
       printf ("Output file Open\n");


   if (binary==ON)
    inplimit=0;
   else
    inplimit=3;
   bread=0;pbread=0;w=16384;
   bwrit=0;pbwrit=0;bfx=0;
   while (1)
   {
   while (inpleft>inplimit)
    {
      block_read();

      block_write();

         if( inpleft == 0 )
            {
            Open_Next_Input_File();
            }
       bfx=0;bread=0;w=16384;
       bwrit=0;
      } /*while (inpleft>inplimit)*/
   while(1)
    {
      c = getc(fp2);

      if( c == EOF )
         {
         fclose(fp2);
         break;
         }
     inpleft--;
     if (binary==ON || c != CTRL_Z)
     {
      putc(c,fp1);
     }
    } /*while(1)*/
   Open_Next_Input_File();
   } /*while (1) (Exits thru Open-Next_Input_File)*/
   } /*main(argc,argv)*/
/***************************************************************************/
  VOID Open_Next_Input_File()
     {
      (num_input_files)++;
      if(num_input_files > 999)
         {
         printf("Too many files--%d.\nExiting program\n.",num_input_files);
         exit(1);
         }

      input_file = line1;                /* initialize input_file pointer */

      /* create the next filename */
      sprintf(input_file,"%s.%-d",filename,num_input_files);
      while (1)
      {
      if (wait==ON)
       {
       while (1)
        {
         printf("Ready to read File %s. \n\
Press Return to continue or Esc to Stop\n",input_file);
         c=getch();
         if (c==ESC)
          {
           close_out(fp1,outfilename);
           printf("%d files joined.\n",(num_input_files) - 1 );
           delete_files();
           exit(1);
          } /* if (c==ESC)*/
         if (c==CR) break;
        } /* while (1)*/
       } /* if (wait==ON)*/

      fp2 = fopen(input_file,"rb");
      if (fp2 == NULL)
         {
          printf("Cannot open %s for input\n",input_file);
          if (wait==OFF)
           {
            printf("Exiting the program.\n");
            close_out(fp1,outfilename);
            printf("%d files joined.\n",(num_input_files) - 1 );
            delete_files();
            exit(1);
           } /* if (wait==OFF) */
          else continue;
         } /* if (fp2 == NULL) */
      if( fseek(fp2,0L,2) == -1)            /* position at EOF */
         {
          printf("Error seeking end of input file %s.\n",input_file);
          exit(1);
         }
      break;
      } /* while (1) */

      inpfz = ftell(fp2);                   /* tell EOF  */
      inpleft=inpfz;
      rewind(fp2);                          /* back to beginning of file */
      printf("  Input file %s size = %ld bytes\n",input_file,inpfz);
     } /*VOID Open_Next_Input_File()*/
/***************************************************************************/
 VOID set_switches()
  {
   for( p = switches ; (p - switches) < strlen(switches)  ; p++ )
      {
       if( *p == 'b' )
         {
         binary = ON;
         weof   = OFF;
         }
      else if ( *p == 'w')
         {
         wait = ON;
         }
      else if ( *p == 'e' && binary == OFF)
         {
         weof = ON;
         }
      } /*for( p = switches ...*/
  } /*VOID set_switches()*/
/***************************************************************************/
 VOID construct_input_filename()
    {
     p=inpath+strlen(inpath)-1;           /* ensure inpath properly terminated*/
     if (*p!='\\' && *p!=':')
      {
       *(p+1)='\\';
       *(p+2)=0;
      }

     if (filename[1]==':')                  /* strip disk/path from input filename*/
      {
      strcpy(fnwork,(filename+2));
      strcpy(filename,fnwork);
      }
    for (p=filename+strlen(filename);p>=filename;p--)
     {
      if (*p=='\\')
       {
       strcpy(fnwork,p+1);
       strcpy(filename,fnwork);
       break;
       } /*if*/
     } /* for (p=filename+strlen(filename),p>=filename,p--)*/
     if (strlen(inpath)+strlen(filename)<75)
     {
     strcpy(fnwork,inpath);
     strcat(fnwork,filename);
     strcpy(filename,fnwork);
     }
     else
      {
      printf("Syntax Error generating input filename\n");
      exit(8);
      }
    } /*VOID construct_input_filename()*/
/***************************************************************************/
VOID block_read()
   {
      while (bread<bfsiz && inpleft>inplimit && w==16384)
      {
       if (bfsiz>=bread+16384 && inpleft>inplimit+16384)
        {
        w=fread(bfpa[bfx],1,16384,fp2);
        }
       else
       if (inpleft-inplimit>bfsiz-bread)
       {
        w=fread(bfpa[bfx],1,(int)(bfsiz-bread),fp2);
       }
       else
       {
        w=fread(bfpa[bfx],1,(int)(inpleft-inplimit),fp2);
       }
       if (ferror(fp2))
        {
         printf("File read error.\n");
         exit(8);
        }
       bfx++;
       bread+=(long)w;
       pbread+=(long)w;
       inpleft-=(long)w;
      } /* while (pbread<size && bread<bfsiz && inpleft>inplimit && w==16384)*/
   }/* VOID block_read()*/
/***************************************************************************/
 VOID block_write()
  {
      bfx=0;w=16384;
      bwrit=0;
      while (bwrit<bread && w==16384)
      {
       if (bread>=bwrit+16384)
       {
        w=fwrite(bfpa[bfx],1,16384,fp1);
       }
       else
        {
        w=fwrite(bfpa[bfx],1,(int)(bread-bwrit),fp1);
        }
       if (ferror(fp1))
        {
         printf("File write error.\n");
         exit(8);
        } /*ferror(fp2)*/
       bfx++;
       bwrit+=(long)w;
       pbwrit+=(long)w;
       byte_count+=(long)w;
      } /*while (bwrit<bread && w==16384)*/
  } /*VOID block_write()*/
/***************************************************************************/
VOID help()
   {
   printf("Version %s -- 12/18/92\n",VERSION);
   printf("\n");
   printf("USAGE: JOIN FILENAME [INPATH] -SWITCHES\n");
   printf("Written by Edgar Swank using some code by W. J. Kennamer\n");
   printf("and released into the public domain.\n");
   printf("  FILENAME is any valid MS-DOS filename.  Wildcards are not supported.\n");
   printf("  This will be the single output filename.\n");
   printf("  Input file names will be FILENAME.1, FILENAME.2, etc.\n");
   printf("  Program will stop when FILENAME.n is not found, or when Esc is entered\n");
   printf("  in response to prompt from -w option.\n");
   printf("  Terminating <ctrl>Z is removed from Input files\n");
   printf("  UNLESS -b is specified.\n");
   printf("  Terminating <ctrl>Z is added to Output files\n");
   printf("  ONLY if -e is specified AND -b is NOT specified.\n");
   printf("  INPATH is an optional disk/pathname (A: or \\path\\ or a:\\path\\)\n");
   printf("  to get input files on a different disk and/or directory from output file.\n");
   printf("  SWITCHES must follow the FILENAME and INPATH parameters,\n");
   printf("  and may be entered in any order.  Switches may be combined.\n");
   printf("Press any key to continue:\n");
    getchar();
   printf("  Valid SWITCHES are:\n");
   printf("ͻ\n");
   printf("   -b  binary     do not remove ^z from input files.            \n");
   printf("Ķ\n");
   printf("   -e  eof        add ^z to output file.                        \n");
   printf("                  Note: may interfere with appending            \n");
   printf("                  to output file later.                         \n");
   printf("Ķ\n");
   printf("   -w  wait       wait before opening each input file.          \n");
   printf("                   can change input diskette if separate from   \n");
   printf("                   output.                                      \n");
   printf("ͼ\n");
   }

/***************************************************************************/

VOID close_out(fp,filename)

FILE *fp;
char *filename;                    /* output file name                 */

   {
   long file_size;

   if (binary==OFF && weof==ON)
   {
   putc(CTRL_Z,fp);                /* terminate file with EOF mark    */
   byte_count++;
   }

   if( fseek(fp,0L,2) == -1 )         /* position at EOF                 */
                {
                printf("Error seeking end of output file.\n");
                exit(1);
                }
   file_size = ftell(fp);          /* report EOF position             */
   fclose(fp);
   printf("Created %s -- %ld bytes\n" , filename , file_size);
   if (binary==OFF && weof==ON)
   {
   printf("Warning: EOF added to output file. May interfere with appending.\n");
   }
   }

/***************************************************************************/
VOID delete_files()
 {
  if (!wait)
   {
    Printf("Delete Input Files?(y/n)\n");
    c=getche();
    printf("\n");
    if (c=='y' || c=='Y')
     {
      for (i=1;i<num_input_files;i++)
       {
        sprintf(input_file,"%s.%-d",filename,i);
        u=unlink(input_file);
        if (u==0)
         {
          printf("%s Deleted.\n",input_file);
         }
        else
         {
          derno=_doserrno;erno=errno;
          printf("Error Deleting %s.\n",input_file);
          printf ("DOS ERROR %4X errno %d %s\n",derno,erno,sys_errlist[erno]);
         } /* endif */

       } /* endfor */
     }
    else
     {
     } /* endif */

   }
 }
