#
#	ufgate.ctl
#
#	Author:  John Galvin
#	Date:    22-May-1987
#	Purpose: configuration file for ufgate.
#
#	$Id: ufgate.ctl 1.6 88/09/22 16:45:12 galvin Exp $
#
#	$Log:	ufgate.ctl $
#	Revision 1.6  88/09/22  16:45:12  galvin
#	Removed remaining documentation as the latest version of
#	the manual now includes equivalent information.
#	
#	Revision 1.5  88/07/18  11:31:42  galvin
#	Removed extraneous documentation, since we now have a manual.
#	
#	Revision 1.2  88/07/05  03:51:12  galvin
#	Added documentation for Forward.  Removed UUCPAlias.
#	
#	Revision 1.1  88/07/04  10:38:43  galvin
#	Initial revision
#
#
#	These programs support UUCP/Usenet to FidoNet gateways for IBM PC
#	compatible computers running one or more of the following FidoNet
#	compatible mail systems: Fido, Opus, and/or SEAdog.
#
#	Fido and FidoNet are trademarks of Tom Jennings.  Thanks TJ!
#	SEA and SEAdog are trademarks of System Enhancement Associates, Inc.
#	IBM is a trademark of International Business Machines, Inc.
#
#----------------------------------------------------------------------------


#	Node information:
#	~~~~~~~~~~~~~~~~
#	System <system type>
#
#System		SEAdog		# SEAdog v4 Mail node, no BBS available
System		Opus_v0.00	# Opus v0.00 - v1.03b BBS
#System		Opus		# Opus version 1.10 BBS
#System		Fido_v11w	# Fido BBS up to version 11w
#System		Fido_v12e	# Fido v12e BBS
#System		Fido		# Fido v12g BBS
#System		TBBS		# not yet supported

#
#	Baud <baud rate>
#
Baud		1200	# baud rate of the host FidoNet mail system


#
#	Node [[<zone>:]<net>/]<node>[.<point>]
#
Node		1:121/1	# net/node number of Fido, Opus, or SEAdog node


#
#	Aka [[<zone>:]<net>/]<node>[.<point>]
#
Aka		0	# alternate net/node numbers...


#
#	DomainName <domain name>
#
DomainName	FIDONET.ORG


#
#	NodeName <uucp name> [FULLNAME <domain name>] [[ALIAS <name>]...]
#
NodeName	circle  Alias circle.UUCP  Alias circle.IFNA.ORG


#
#	Organization <organization name and info>
#
Organization	"The First Circle BBS, Madison WI (608) 249-0275"


#
#	BangPath <uucp path to get here>
#
BangPath	...!uwvax!geowhiz!circle


#
#	SMailPath <bang path to smart mailer>
#
SMailPath	geowhiz!uwvax


#
#	UucpHost <uucp name> [FULLNAME <domain name>] [[ALIAS <name>]...] \
#		 [SMAIL] [NEWS] [BATCH] [<COMPRESS12>|<COMPRESS16>]
#
UucpHost	geowhiz	 NEWS SMAIL  # uucp name of my mail/news feed
UucpHost	uwspan


#
#	Send <uucp name> <newsgroup> [<newsgroup>...]
#
Send geowhiz all


#
#	ModemInit <initialization string>
#
ModemInit ATS0=1|


#
#	ModemEnd <de-initialization string>
#
ModemEnd ATS0=0|


#
#	DialPrefix <modem dial command>
#
DialPrefix ATDT


#
#	DialSuffix <end of modem dial command>
#
DialSuffix |


#
#	User Information:
#	~~~~~~~~~~~~~~~~
#
#	FidoAlias <name> <user name> <fido address> [signature file]
#
FidoAlias  sysop  	Sysop			local	c:/etc/galvin.sig
FidoAlias  postmaster	"John Galvin"		local	c:/etc/galvin.sig
FidoAlias  galvin 	"John Galvin"		local	c:/etc/galvin.sig
FidoAlias  plocher 	"John Plocher"		local
FidoAlias  pax		"Garry Paxinos"		369/6
FidoAlias  pozar 	"Tim Pozar"		125/406
FidoAlias  rat		"David Douthitt"	local	c:/etc/douthitt.sig
FidoAlias  almasy	"Ed Almasy"		local	c:/etc/almasy.sig


#
#	Forward <user name> <address> [<address> ...]
#
Forward	"John Plocher"	plocher@uport.UUCP
Forward "Rich Fritzson"	fritzson@prc.unisys.com
Forward ufgate		"John Plocher" "Rich Fritzson" ufgate ben@geowhiz yoyo
Forward yoyo		ttang@puff.UUCP ufgate plocher@puff.UUCP yoyo2
Forward yoyo2		ufgate yoyo "John Plocher"


#
#	Gateway Information:
#	~~~~~~~~~~~~~~~~~~~
#
#	Gateway [user]
#
Gateway		"Uucp"	# user to debit for outgoing mail/news


#
#	Files:
#	~~~~~
#	Debug <file>
#
#Debug		c:/seadog/debug.log	# name of the debugging log file


#
#	Log <file>
#
Log		c:/seadog/ufgate.log	# name of log file


#
#	Signature <file>
#
Signature	c:/etc/default.sig	# signature file appended to all
					#   outgoing news and mail

#
#	Directories:
#	~~~~~~~~~~~ 
#	The directories for the Spool, Save, and Orphans commands
#	should all be different, otherwise problems occurr.
#
#	Mail <dir>
#
Mail	c:/bbs/messages/e-mail


#
#	Files <dir>
#
Files	c:/bbs/files/e-mail


#
#	Attach <directory> [<directory>...]
#
Attach	c:/bbs/files/uploads


#
#	Spool <dir>
#
Spool		c:/usr/spool/uucp


#
#	Save <dir> [MAILIN] [NEWSIN] [ALL]
#
Save  		c:/usr/spool/save MAILIN


#
#	Orphans <dir> [MAILIN] [NEWSIN]
#
Orphans		c:/usr/spool/orphans	# where to save orphans


#
#	BBSFiles <dir>
#
BBSFiles	c:/bbs/system	# where the fido/opus/SEAdog system files are

#
#
#	Arcing:	(Buerg's ARCA required)
#	~~~~~~
#	Arc { [Save] [Orphans] [Fido] [Text] [All] }
#
#Arc		Text Save Orphans	# arc the dir types specified


#
#	Expiration of News Articles:
#	~~~~~~~~~~~~~~~~~~~~~~~~~~~
#	Expire <daysold> [KEEP <number of messages>] <dir1> [<dir>...]
#
Expire 30 KEEP 10 \
	c:/bbs/news/comp/newprod \
	c:/bbs/news/misc/jobs/misc \
	c:/bbs/news/misc/jobs/offered \
	c:/bbs/news/news/announce/important \
	c:/bbs/news/news/announce/newusers \
	c:/bbs/news/news/groups
Expire 5  KEEP 10 \
	c:/bbs/news/general/na \
	c:/bbs/news/general/wi \
	c:/bbs/news/general/usa \
	c:/bbs/news/general/uw \
	c:/bbs/news/news/admin \
	c:/bbs/news/news/lists \
	c:/bbs/news/news/misc \
	c:/bbs/news/news/newsites \
	c:/bbs/news/news/sysadmin
Expire 5  KEEP 25 \
	c:/bbs/news/comp/lang/ada \
	c:/bbs/news/comp/lang/cplus \
	c:/bbs/news/comp/lang/forth \
	c:/bbs/news/comp/lang/lisp \
	c:/bbs/news/comp/lang/modula2 \
	c:/bbs/news/comp/lang/pascal \
	c:/bbs/news/comp/lang/prolog \
	c:/bbs/news/comp/mail/headers \
	c:/bbs/news/comp/mail/uucp \
	c:/bbs/news/comp/std/c
Expire 3  KEEP 25 \
	c:/bbs/news/comp/arch \
	c:/bbs/news/comp/dcom/lans \
	c:/bbs/news/comp/dcom/modems \
	c:/bbs/news/comp/lang/c \
	c:/bbs/news/comp/os/minix \
	c:/bbs/news/comp/softeng \
	c:/bbs/news/comp/sources/bugs \
	c:/bbs/news/comp/sources/wanted \
	c:/bbs/news/misc/forsale \
	c:/bbs/news/misc/headline \
	c:/bbs/news/sci/crypt \
	c:/bbs/news/sci/space \
	c:/bbs/news/sci/space/shuttle
Expire 2  KEEP 20 \
	c:/bbs/news/comp/sys/amiga \
	c:/bbs/news/comp/sys/apple \
	c:/bbs/news/comp/sys/atarist \
	c:/bbs/news/comp/sys/ibmpc \
	c:/bbs/news/comp/sys/mac \
	c:/bbs/news/comp/unix \
	c:/bbs/news/comp/unix/uport \
	c:/bbs/news/comp/unix/question \
	c:/bbs/news/comp/unix/wizards \
	c:/bbs/news/comp/unix/xenix \
	c:/bbs/news/comp/windows/x \
	c:/bbs/news/rec/games/hack \
	c:/bbs/news/rec/games/misc \
	c:/bbs/news/rec/games/rogue \
	c:/bbs/news/rec/humor/funny \
	c:/bbs/news/rec/nude \
	c:/bbs/news/soc/college \
	c:/bbs/news/soc/politics \
	c:/bbs/news/soc/politics/arms-d \
	c:/bbs/news/soc/singles


#
#	News Article Handling:
#	~~~~~~~~~~~~~~~~~~~~~
#
#	HistCycle <days>
#
HistCycle 3


#
#	Text <dir> <newsgroup1> [[group]...]
#
Text c:/bbs/news/comp/binaries/ibmpc		comp.binaries.ibm.pc
Text c:/bbs/news/comp/sources/games		comp.sources.games
Text c:/bbs/news/comp/sources/misc		comp.sources.misc
Text c:/bbs/news/comp/sources/unix		comp.sources.unix
Text c:/bbs/news/comp/mail/maps			comp.mail.maps


#
#	Fido <dir> <newsgroup1> [[group]...]
#
Fido c:/bbs/news/general/na			na.general
Fido c:/bbs/news/general/wi			wi.general
Fido c:/bbs/news/general/usa			usa.general
Fido c:/bbs/news/general/uw			uw.general

Fido c:/bbs/news/comp/arch			comp.arch
Fido c:/bbs/news/comp/dcom/lans			comp.dcom.lans
Fido c:/bbs/news/comp/dcom/modems		comp.dcom.modems
Fido c:/bbs/news/comp/lang/ada			comp.lang.ada
Fido c:/bbs/news/comp/lang/c			comp.lang.c
Fido c:/bbs/news/comp/lang/cplus		comp.lang.c++
Fido c:/bbs/news/comp/lang/forth		comp.lang.forth
Fido c:/bbs/news/comp/lang/lisp			comp.lang.lisp
Fido c:/bbs/news/comp/lang/modula2		comp.lang.modula2
Fido c:/bbs/news/comp/lang/pascal		comp.lang.pascal
Fido c:/bbs/news/comp/lang/prolog		comp.lang.prolog
Fido c:/bbs/news/comp/mail/headers		comp.mail.headers
Fido c:/bbs/news/comp/mail/uucp			comp.mail.uucp
Fido c:/bbs/news/comp/newprod			comp.newprod
Fido c:/bbs/news/comp/os/minix			comp.os.minix
Fido c:/bbs/news/comp/softeng			comp.software-eng
Fido c:/bbs/news/comp/sources/bugs		comp.sources.bugs
Fido c:/bbs/news/comp/sources/wanted		comp.sources.wanted
Fido c:/bbs/news/comp/std/c			comp.std.c
Fido c:/bbs/news/comp/sys/amiga			comp.sys.amiga
Fido c:/bbs/news/comp/sys/apple			comp.sys.apple
Fido c:/bbs/news/comp/sys/atarist		comp.sys.atari.st
Fido c:/bbs/news/comp/sys/ibmpc			comp.sys.ibm.pc
Fido c:/bbs/news/comp/sys/mac			comp.sys.mac
Fido c:/bbs/news/comp/unix			comp.unix
Fido c:/bbs/news/comp/unix/uport		comp.unix.uport
Fido c:/bbs/news/comp/unix/question		comp.unix.questions
Fido c:/bbs/news/comp/unix/wizards		comp.unix.wizards
Fido c:/bbs/news/comp/unix/xenix		comp.unix.xenix
Fido c:/bbs/news/comp/windows/x			comp.windows.x
Fido c:/bbs/news/misc/forsale			misc.forsale
Fido c:/bbs/news/misc/headline			misc.headlines
Fido c:/bbs/news/misc/jobs/misc			misc.jobs.misc
Fido c:/bbs/news/misc/jobs/offered		misc.jobs.offered
Fido c:/bbs/news/news/admin			news.admin
Fido c:/bbs/news/news/announce/important	news.announce.important
Fido c:/bbs/news/news/announce/newusers		news.announce.newusers
Fido c:/bbs/news/news/groups			news.groups
Fido c:/bbs/news/news/lists			news.lists
Fido c:/bbs/news/news/misc			news.misc
Fido c:/bbs/news/news/newsites			news.newsites
Fido c:/bbs/news/news/sysadmin			news.sysadmin
Fido c:/bbs/news/rec/games/hack			rec.games.hack
Fido c:/bbs/news/rec/games/misc			rec.games.misc
Fido c:/bbs/news/rec/games/rogue		rec.games.rogue
Fido c:/bbs/news/rec/humor/funny		rec.humor.funny
Fido c:/bbs/news/rec/nude			rec.nude
Fido c:/bbs/news/sci/crypt			sci.crypt
Fido c:/bbs/news/sci/space			sci.space
Fido c:/bbs/news/sci/space/shuttle		sci.space.shuttle
Fido c:/bbs/news/soc/college			soc.college
Fido c:/bbs/news/soc/politics			soc.politics
Fido c:/bbs/news/soc/politics/arms-d		soc.politics.arms-d
Fido c:/bbs/news/soc/singles			soc.singles


#
#	Trash <newsgroup1> [[group]...]
#
Trash	comp.ai comp.ai.digest comp.ai.neural-nets comp.ai.nlang-know-rep \
	comp.binaries.amiga comp.binaries.atari.st comp.binaries.mac \
	comp.bugs.2bsd comp.bugs.4bsd comp.bugs.4bsd.ucb-fixes \
	comp.bugs.misc comp.bugs.sys5 comp.cog-eng comp.compilers \
	comp.databases comp.dcom.telecom comp.doc comp.doc.techreports \
	comp.edu comp.emacs comp.graphics comp.graphics.digest \
	comp.hypercube comp.lang.apl comp.lang.fortran comp.lang.misc \
	comp.lang.postscript comp.lang.scheme comp.lang.smalltalk \
	comp.laser-printers comp.lsi comp.mail.elm comp.mail.mh \
	comp.mail.misc comp.misc comp.org.decus comp.org.fidonet \
	comp.org.usenix comp.os.cpm comp.os.eunice comp.os.misc comp.os.os9 \
	comp.os.research comp.os.vms comp.os.xinu comp.periphs \
	comp.protocols.appletalk comp.protocols.ibm comp.protocols.iso \
	comp.protocols.kermit comp.protocols.misc comp.protocols.tcp-ip \
	comp.protocols.tcp-ip.ibmpc comp.risks comp.society \
	comp.society.futures comp.sources.amiga comp.sources.atari.st \
	comp.sources.d comp.sources.mac comp.std.internat comp.std.misc \
	comp.std.mumps comp.std.unix comp.sys.apollo comp.sys.atari.8bit \
	comp.sys.att comp.sys.cbm comp.sys.celerity comp.sys.dec \
	comp.sys.dec.micro comp.sys.encore comp.sys.hp \
	comp.sys.ibm.pc.digest comp.sys.ibm.pc.rt comp.sys.intel \
	comp.sys.m6809 comp.sys.m68k comp.sys.m68k.pc comp.sys.mac.digest \
	comp.sys.mac.hypercard comp.sys.masscomp comp.sys.misc \
	comp.sys.nsc.32k comp.sys.proteon comp.sys.pyramid comp.sys.ridge \
	comp.sys.sequent comp.sys.sgi comp.sys.sun comp.sys.tahoe \
	comp.sys.tandy comp.sys.ti comp.sys.transputer comp.sys.workstations \
	comp.sys.xerox comp.sys.zenith.z100 comp.terminals comp.text \
	comp.text.desktop comp.theory.info-retrieval comp.unix.ultrix \
	comp.windows.misc comp.windows.news misc.consumers \
	misc.consumers.house misc.handicap misc.invest misc.jobs.resumes \
	misc.kids misc.legal misc.misc misc.psi misc.security misc.taxes \
	misc.test misc.wanted news.announce.conferences news.config \
	news.software.b news.software.notes news.stargate rec.arts.anime \
	rec.arts.books rec.arts.comics rec.arts.drwho rec.arts.int-fiction \
	rec.arts.movies rec.arts.movies.reviews rec.arts.poems \
	rec.arts.sf-lovers rec.arts.startrek rec.arts.tv rec.arts.tv.soaps \
	rec.arts.wobegon rec.audio rec.autos rec.autos.tech rec.aviation \
	rec.bicycles rec.birds rec.boats rec.equestrian rec.food.cooking \
	rec.food.drink rec.food.recipes rec.food.veg rec.games.board \
	rec.games.bridge rec.games.chess rec.games.empire rec.games.frp \
	rec.games.go rec.games.pbm rec.games.programmer rec.games.trivia \
	rec.games.video rec.gardens rec.guns rec.ham-radio \
	rec.ham-radio.packet rec.humor rec.humor.d rec.humor.spc rec.mag \
	rec.mag.otherrealms rec.misc rec.models.rc rec.motorcycles \
	rec.music.beatles rec.music.classical rec.music.folk rec.music.gaffa \
	rec.music.gdead rec.music.makers rec.music.misc rec.music.synth \
	rec.pets rec.photo rec.puzzles rec.railroad rec.scuba rec.skiing \
	rec.skydiving rec.sport.baseball rec.sport.basketball \
	rec.sport.football rec.sport.hockey rec.sport.misc rec.travel \
	rec.video rec.woodworking sci.astro sci.bio sci.electronics sci.lang \
	sci.lang.japan sci.math sci.math.stat sci.math.symbolic sci.med \
	sci.med.aids sci.misc sci.philosophy.tech sci.physics sci.research \
	soc.culture.african soc.culture.china soc.culture.celtic \
	soc.culture.greek soc.culture.indian soc.culture.japan \
	soc.culture.jewish soc.culture.misc soc.human-nets soc.men soc.misc \
	soc.motss soc.net-people soc.religion.christian soc.roots soc.women \
	talk.abortion talk.bizarre talk.origins talk.philosophy.misc \
	talk.politics.misc talk.politics.theory talk.religion.misc \
	talk.religion.newage talk.rumors 
