/*
	Big Fido include file
	T. Jennings 15 Oct 90

"Fido" is a trademark of Tom Jennings
"FidoNet" is a trademark of Tom Jennings

All rights reserved.

The contents of this file copyright Tom Jennings 1989.

	Fido Software
	P.O. Box 77731
	San Francisco CA 94107
	(415)-764-1688
*/

#define FIDOVER 12		/* Fido version */
#define FILEVER ('t' - 'a' + 1)	/* FIDO.SYS version letter */

/*




IMPORTANT NOTES:

"OBSO" means "Obsolete"; they may exist currently, but will not 
in the future. Please use only structures defined as "PUBLIC".

-- IMPORTANT! -- IMPORTANT! -- IMPORTANT! -- IMPORTANT! -- IMPORTANT! --
Structures, structure elements, and structure element order, or
other data items not marked "PUBLIC" may change at any time. YOU HAVE 
BEEN WARNED!!!!
-- IMPORTANT! -- IMPORTANT! -- IMPORTANT! -- IMPORTANT! -- IMPORTANT! --

"RESERVED" means exactly that: using such fields will damage future
versions of Fido and will certainly tick off your customers when 
nothing works right. Please see the warning above on PUBLIC items.

"VERSION" bytes, usually at the beginning of a file or record, is
the current version or format for this file. This value is defined by
Fido Software, and your program should monitor it before operating
on the file. It will be changed only when some incompatible change is 
made, such as the major shuffling done between versions 11 and 12. The
safest route to take is to display a warning "WRONG VERSION PROGRAM"
and halt.

*/

/* Absolute Truths (current version ...) */

#define TSYNC (0xae)			/* FidoNet sync character */
#define YOOHOO (0xf1)			/* WAZOO sync character */

#define SS 80				/* standard, universal, string size */
#define PS 64				/* maximum MSDOS pathname length */
#define SF (sizeof("FILENAME.EXT")+1)
#define same(s1,s2) (strcmp(s1,s2)==0)
#define NULL 0				/* nothing */
#define MAXAREA 200			/* maximum message/file areas */

#define MINS_HR	60			/* minutes in an hour */
#define DAYS_WK 7			/* days in a week */
#define MINS_DAY (24 * 60)		/* minutes in an hour */
#define MINS_WK (MINS_DAY * DAYS_WK)

/* Standard node structure used throughout Fido. This is buried within all
the other major structures. */

struct _node {
	int zone;		/* zone number */
	int net;		/* net number */
	int number;		/* node number */
	int point;		/* point number */
};

#define FLAG char		/* define 1/0 type flags */

char *str_node();
char *skip_delim();
char *next_arg();		/* must declare non-INT functions */
char *strip_path();		/* might as well in the global include ... */
char *getarg();
int *msg_highest();
int *msg_total();
char *string();

long _fsize();
long lseek();
long sizmem();
char *getmem();

/* Callers record. A major functional change for v12 is the name
checksum; the checksum (merely the arithmetic sum of all ASCII characters
in the name, including the spaces, masked to 8 bits) is used as a fast
initial name compare; if the checksums don't match, no sense in
doing a (slow) string compare. if (sum1 == sum2) is a machine instruction
and fast as hell. Cache caller records too and you have a fast logon 
procedure ... 

LATE NOTE: The above checksum process is stupid. It doesn't help anything.
Next time think before you code... */

#define MAXLREAD 20

#define CLRVER 5		/* caller file version, */

/* PUBLIC */
struct  _clr {
	char version;		/* caller record version, above */
	char name[36];		/* callers ASCII name, */
	char city[36];		/* city and state, */
	char pwd[16];		/* what else, */
	char date[20];
	char sum;		/* name checksum (for fast compare) */

/* NOTE: At some point in the "near" future, the last-message-read junk
is going to be moved out of this file into a linked-list database that
will keep track of every new message addressed to each caller, by
number and area, and it will keep track of renumbered, killed and reply-to
messages. The size of each caller-record will not change; the position of
and uses for other fields will not change. Only the lastmsg[] struct
will be affected; it will be zero'd and part of it used to reference the 
external database. (this note written Aug 89) */

	struct {		/* last message read: */
		char area;	/* message area */
		unsigned msg;	/* last msg read */
	} lastmsg[MAXLREAD];

/* Runtime statistics */

	char msg,files;		/* last selected message/file area */
	unsigned times;		/* total times called, */
	unsigned time;		/* total time on system in 1 day, */
	unsigned upld;		/* total K byte uploaded, */
	unsigned dnld;		/* total K bytes downloaded, */
	unsigned dnldl;		/* total downloaded, for limiting, */

	unsigned tleft;		/* time limit left at logoff */
	unsigned baud;		/* last used baud rate */

/* Other stuff, settable by SYSOP.EXE */

	unsigned credit;	/* credit, in cents, */
	unsigned debit;		/* debit, in cents, */
	long keys;		/* caller keys to system locks (below) */
	long extra;		/* RESERVED */

/* Settings from the C)hange command. These are packed for space:

d 0 0 g g g k p p p l l l l l l l w w w w w w w n n n n h h 0 0 (32 bits)

		range		# bits		shifter
-----------------------------------------------------------
d deleted	0 - 1		1		31 	see note below
0 extra		0 - 7		3		29	RESERVED
g language	0 - 7		3		26
k keep recd	0 - 1		1		25	see note below
p privilege	0 - 7		3		22
l screen length	0 - 127		7		15
w screen width	0 - 127		7		8
n nulls		0 - 15		4		4
h help		0 - 3		2		2
0 more		0 - 1		1		1	DO NOT USE!!! (use lines = 0)
0 tabs		0 - 1		1		0	DO NOT USE!!!

DELETED is for SYSOP.EXE's use. (Mark for DELETED) Aftermarket
programs may use the DELETED BIT. It is not used in any way 
within Fido.

is used by SYSOP.EXE to flag records that should never be
deleted; it is not used by Fido, and new records created by
Fido have this bit clear (like all other bits) to zero.
*/
	long stuff;		/* the bits above */

/* caller stuff field bits access. */

#define CLR_DEL 1		/* delete -- used by sysop/msgmgr */
#define CLR_DELS 31

#define CLR_EXT 7		/* extra -- not used */
#define CLR_EXTS 29

#define CLR_KEP 1		/* keep -- used by sysop/msgmgr */
#define CLR_KEPS 25

#define CLR_LAN 7		/* language selection */
#define CLR_LANS 26

#define CLR_PRV 7		/* privilege bit mask/maximum value */
#define CLR_PRVS 22		/* privilege bit shift */

#define CLR_LEN	127		/* mask and max value */
#define CLR_LENS 15		/* shift value */

#define CLR_WID 127
#define CLR_WIDS 8
#define CLR_NUL 15
#define CLR_NULS 4
#define CLR_HLP 3
#define CLR_HLPS 2
#define CLR_MOR 1
#define CLR_MORS 1
#define CLR_TAB 1
#define CLR_TABS 0
};

/* caller privileges */

/* PUBLIC */
#define TWIT 0			/* total asshole */
#define DISGRACE 1		/* disgraced caller, */
#define NORMAL 2		/* normal caller, */
#define PRIVEL 3		/* privileged caller, */
#define EXTRA 4			/* extra priveleges, */
#define SYSOP 7			/* SYSOP priveleges, */

/* caller help levels */

/* PUBLIC */
#define EXPERT 0		/* caller help level: expert */
#define REGULAR 1		/* experienced */
#define NOVICE 2		/* new caller */

/* Locks and keys for the access control stuff. These are basically bits
in the LOCK and KEY fields. */

/* PUBLIC */
#define K1	1
#define K2	(K1<<1)
#define K3	(K2<<1)
#define K4	(K3<<1)
#define K5	(K4<<1)
#define K6	(K5<<1)
#define K7	(K6<<1)
#define K8	(K7<<1)
#define K9	(K8<<1)
#define K10	(K9<<1)
#define K11	(K10<<1)
#define K12	(K11<<1)
#define K13	(K12<<1)
#define K14	(K13<<1)
#define K15	(K14<<1)
#define K16	(K15<<1)
#define K17	(K16<<1)
#define K18	(K17<<1)
#define K19	(K18<<1)
#define K20	(K19<<1)
#define K21	(K20<<1)
#define K22	(K21<<1)
#define K23	(K22<<1)
#define K24	(K23<<1)
#define K25	(K24<<1)
#define K26	(K25<<1)
#define K27	(K26<<1)
#define K28	(K27<<1)
#define K29	(K28<<1)
#define K30	(K29<<1)
#define K31	(K30<<1)
#define K32	(K31<<1)

#define KALL	(-1L)
#define KNONE	(0)

#define L1	K1
#define L2	K2
#define L3	K3
#define L4	K4
#define L5	K5
#define L6	K6
#define L7	K7
#define L8	K8
#define L9	K9
#define L10	K10
#define L11	K11
#define L12	K12
#define L13	K13
#define L14	K14
#define L15	K15
#define L16	K16
#define L17	K17
#define L18	K18
#define L19	K19
#define L20	K20
#define L21	K21
#define L22	K22
#define L23	K23
#define L24	K24
#define L25	K25
#define L26	K26
#define L27	K27
#define L28	K28
#define L29	K29
#define L30	K30
#define L31	K31
#define L32	K32

#define LALL	KALL
#define LNONE	KNONE


/* Structure for the time log: first access, last access, and an integer
counter for each hour of each day of the week. */

/* PUBLIC */
struct _tlog {
	int calls;		/* # calls in log, */
	char fdate[20];		/* logging started, */
	char ldate[20];		/* logging ended, */
	int log[7][24];		/* the counters, */
};

/* Tables of command names and privelege levels for each. */

struct _cmd {
	char name[20];		/* command name, */
	char priv;		/* its priv, */
	long locks;		/* lock bits */
};

/* Message header structure. The message text is just a long string. The
zone:net/node of course do not conform to the new (v12) standard. */

/* PUBLIC */
struct _msg {
	char from[36];		/* who from, */
	char to[36];		/* who to, */
	char subj[72];		/* message subject, */
	char date[20];		/* creation date, */
	int times;		/* number of times read, */
	int dest_node;		/* destination node, */
	int orig_node;		/* originating node */
	int cost;		/* actual cost of this msg */
	int orig_net;		/* v10 originating net */
	int dest_net;		/* v10 destination net */
	int dest_zone;		/* v12 originating zone */
	int orig_zone;		/* v12 destination zone */
	int dest_point;
	int orig_point;
	unsigned reply;		/* thread to previous msg. (reply-to) */
	unsigned attr;		/* message type, see below */
	unsigned up;		/* thread to next msg. (replied-to) */

/* NOTE: The date[20] field is another historical embarrasment. The
format is, exactly:

	"dd Mon yy  hh:mm:ss"

where dd, yy, hh, mm, and ss are two digit numbers, zero filled where
necessary, and Mon is the first three letters of the month, in English,
lower case with the first letter upper case. There are TWO SPACES between
yy and hh.

	This format is very important (this is the embarrasing part) because
Fido since v3 has done arithmetic on the string itself. Please preserve this
EXACT FORMAT if you wish things like RENUM and PURGE to work correctly. 
*/
};

/* Message attribute bits */

/* PUBLIC */
#define MSGPRIVATE 1		/* private message, */
#define MSGCRASH 2		/* NOT USED */
#define MSGREAD 4		/* read by addressee */
#define MSGSENT 8		/* sent OK (remote) */
#define MSGFILE 16		/* file(s) attached to msg */
#define MSGFWD 32		/* message in transit */
#define MSGORPHAN 64		/* unknown dest node this sched */
#define MSGKILL 128		/* kill after mailing */
#define MSGLOCAL 256		/* was generated locally */
#define MSGHFP 512		/* Hold For Pickup NOT USED */
#define MSGUNUSED 1024		/* NOT USED */
#define MSGFREQ 2048		/* file(s) requested */
#define MSGRRR 4096		/* Return Receipt Requested NOT USED */
#define MSGIRR 8192		/* Is Return Receipt NOT USED */
#define MSGAR 16384		/* Audit Request NOT USED */
#define MSGFUR 32768		/* File Update Request NOT USED */

/* Bits allowed in packets and after unpacking, ie. this mask is used to
strip off message attribute bits. */

#define MSGMASK (MSGPRIVATE | MSGCRASH | MSGFILE | MSGUNUSED | MSGRRR | MSGIRR | MSGAR)

/* Modem type values */

#define NOMODEM 0		/* no modem */
#define HAYES 1			/* DC Hayes and clones */
#define DIRECT 2		/* direct connection */
#define USR 5			/* US Robotics */
#define POPCOM 7		/* Popcom */
#define POP24 8			/* POPCOM 2400 */
#define GDC 10			/* General Data Comm */
#define HAYES24 11		/* Hayes 2400 */
#define USR24 12		/* USR 2400 */
#define MT24 13			/* Multi Tech 2400 */
#define HST 14			/* US Robotics Courier HST, variable rate */
#define HAYES3 15		/* SmartModem 300 */
#define HST2 16			/* HST, fixed at 9600 */
#define HST3 17			/* HST, fixed at 19200 */
#define TBT 18			/* Telebit TrailBlazer, variable rate */
#define TBT2 19			/* Telebit, fixed at 9600 */
#define TBT3 20			/* Telebit, fixed at 19200 */
#define SMV1 21			/* Hayes V-series SmartModem 9600, no ASB */
#define SMV2 22			/* Hayes V-series SmartModem 9600, with ASB */
#define SMV3 23			/* Hayes V-series SmartModem 19200, with ASB */
#define HST4 24			/* HST, fixed at 38400 */
#define USR24H 25		/* USR 2400, hardware handshake */
#define VARF 26			/* fixed rate modem, X1 init */
#define DST1 27			/* Dual Standard HST, fixed at 9600 */
#define DST2 28			/* Dual Standard HST, fixed at 19200 */

/* List of message, download and upload areas, as contained in the
big system file. */

/* PUBLIC */
struct _area {
	char number;		/* this areas number (in-memory use only) */
	char priv;		/* minimum privilege, */
	long locks;		/* locks needed, */
	char taskid;		/* taskID this is for else 0 */
	char extra;		/* RESERVED */
	char reserved[6];	/* RESERVED */
	char name[16];		/* area name */
	char path[PS];		/* the path string, */
	char upath[PS];		/* alternate (upload) path (RESERVED in msg areas) */
	char desc[PS];		/* the description */
	char flags;		/* bit flags, see below */
};

#define AREA_OVW 1		/* allow overwriting in this area */
#define AREA_UPLD 2		/* allow uploading to this area */
#define AREA_ANON 4		/* all messages are from: Anon */
#define AREA_NPVT 8		/* no private messages */
#define AREA_PVT 16		/* all are private messages */
#define AREA_SHARED 32		/* this directory shared with other programs */
#define AREA_RO 64		/* this area is read-only */
#define AREA_ECHO 128		/* this area is an echo area (for 'emit-v11') */

/* Internal structure containing stats on the message areas in the system. */

struct _msgstat {
	FLAG checked;		/* 1 == checked for mail & counted here */
	unsigned highest;	/* highest msg this area, */
	unsigned total;		/* total messages this area */
};

#define SCHEDS 100		/* size of scheduler event table */

/* Scheduler event structure within FIDO.SYS. Tags defined:

' ' (ASCII 20h)	disabled event
NUL		disabled event
A - W		FIDONET events
X		ERRORLEVEL event
Y		YELL (P)age) command enable
Z		FREQ (file request) enable
!		IDLE event
all others	RESERVED
*/

/* PUBLIC */
struct _sched {
	char bits;		/* see below */
	char tag;		/* event type, above, */
	char daywk;		/* event start time: day of the week, */
	char hr;		/*   hour, */
	char min;		/*   minute, */
	int len;		/* event length, in minutes */
	char result;		/* errorlevel */
	char swtch;		/* event enable switch */
	char taskid;		/* which taskID else 0 */
};

#define SCHED_OPTIONAL 1	/* this event may be skipped */
#define SCHED_COMPLETE 2	/* this event already run */
#define SCHED_RUSH 4		/* this event is a RUSH event */
#define SCHED_QUICK 8		/* this event is a QUICK (fidonet) event */
#define SCHED_CNT 16		/* this event is CONTINUOUS (fidonet) event */

/* FIDO.SYS: This is where Fido keeps global things. External programs
should use FIDO.SYS, not MAIL.SYS or any of the OBSO structures. This file 
is created by Fido when it does not exist or the version is wrong, and
is written out when a session ends. */

/* PUBLIC */
struct _fido {

	char fido_version;	/* FIDO.EXE version number */
	char file_version;	/* FIDO.SYS version */

	long quote_pos;		/* quote file position */
	long callers;		/* number of callers */

/* If autolog is not -1 then this record number in the caller file is
logged on, bypassing the usual signon logic, and setting the baud rate
and time limit remaining from the caller record. When a caller is 
logged off, this is cleared to zero. */

	unsigned caller;	/* current caller recd # logged in */
	unsigned autolog;	/* log this caller on if not -1 */

/* Since we expanded the _node definition to include point, it doesn't
fit; unravel it here, and expand at runtime. (Yuck.) */

	int zone;		/* zone number */
	int net;		/* net number */
	int number;		/* node number */

	int altzone;		/* zone number */
	int altnet;		/* net number */
	int altnumber;		/* node number */

/* File and message area structures are stored in FIDO.SYS, by simply appending
them to the end of the file. To read them, you have to calculate their
position in the file as follows: (code below is exact)


    msg area #N structure is at:

long offset;
	offset= fido.areaoff + (N * sizeof(struct _area))


    file area #N structure is at:

long offset;
	offset= fido.areaoff + (fido.marea_max * sizeof(struct _area))
	    + (N * sizeof(struct _area)

You then seek to the correct position and load the structure:

	lseek(file,offset,0);			/* seek to correct position */
	read(file,&area,sizeof(struct _area));	/* load it */


NOTE: fido.areaoff is the size of the FIDO.SYS structure itself, starting
with version 12n. Before that it was zero; substitute XXXX as the size
of FIDO.SYS. 

	The file area stuff tacked onto the end is PUBLIC.
*/
	unsigned marea_max;	/* number of message areas */
	unsigned farea_max;	/* number of file areas */

	char bucks;		/* monetary character */
	char sep_char;		/* 1000's separator character, */
	char dec_char;		/* decimal point character */

	unsigned mdmtype;	/* type of modem */
	unsigned maxbaud;	/* 0, or override maximum baud rate */
	char mdmstr[40];	/* modem initialization string */
	char extra12[40];	/* RESERVED */

	unsigned connect_tries;	/* attempt with connect limit */
	unsigned dial_tries;	/* dial attempts */
	char nodepath[PS];	/* nodelist work area */
	char rings;		/* number of rings to answer the phone */
	char extra8[16];	/* RESERVED */
	char netmarea;		/* FidoNet msg area number */
	char netfarea;		/* FidoNet file area number */

	unsigned cd_bit;	/* bit to test for Carrier Detect, */
	unsigned iodev;		/* default serial channel number */	

	struct _sched sched[SCHEDS]; /* the schedulers event table */
	unsigned event;		/* currently running event or -1 */
	char tag;		/* current event tag */

	char termcode;		/* return code for E)xitDOS */
	char outcode;		/* code to return for O)utside */
	char byecode;		/* code to return for normal logoff */
	char mailcode;		/* code to return after incoming mail */

	unsigned textlines;	/* max lines for the msg editor */
	char dial_interval;	/* how often to dial */
	char cont_interval;	/* how often to reenable CONT events */
	char filecode;		/* code to return after incoming files */

	unsigned slimit;	/* logon time limit, */
	unsigned nlimit;	/* normal callers limit, */
	unsigned first_limit;	/* limit for 1st time callers, */
	unsigned dlimit;	/* daily maximum time limit, */
	unsigned klimit;	/* 48 hr K byte limit, */

	char defmnbr;		/* caller default msg area number */
	char deffnbr;		/* caller default file area number */
	char logonbr;		/* caller logoff comment msg area number */
	char def_priv;		/* default privelege for new callers, */
	long def_keys;		/* caller default keys for new callers */

/* Late additions */

	char mtasker;		/* multitasker program type */
	unsigned extra15;	/* RESERVED (was modem fixed link rate) */
	char fbits[40];		/* FBIT enables, see below */
	char dial_pref[30];	/* FidoNet dial string prefix */
	char syspath[50];	/* system file path */
	unsigned zmttype;	/* Zmodem Tx behaviour */
	unsigned zmrtype;	/* Zmodem Rx behaviour */
	char switches;		/* event toggle switches */
	char oneshots;		/* event one shot switches */
	char name[60];		/* system name */
	char extra13;		/* RESERVED */

/* THINGS BEYOND THIS POINT ARE NOT WRITTEN OUT BY FIDO!!!! Runtime
statistics must be stored before this. */

/* The command table stuff is gross. The tables are fixed size, and hard
coded here and in SET-FIDO, where they are loaded. The number is the
number of commands + 1 (for the null name). */

	struct _cmdtable {		/* table of Fido commands */
		struct _cmd    main[14];/* main section */
		struct _cmd     chg[10];/* C)hange */
		struct _cmd     msg[16];/* message section */
		struct _cmd    file[13];/* file section */
		struct _cmd    edit[10];/* edit msg */
		struct _cmd  trigger[4];/* T)rigger command */
		struct _cmd  fileatt[4];/* file attach/request */
		struct _cmd bulletin[1];/* bulletins */
		struct _cmd    extra[8];/* unused */
/*			---------------
			total:   80
*/
	} cmd;

	char extra14[8];	/* RESERVED */
	char ext_logins[10];	/* "External Login" <X> ERRORLEVELs */
	unsigned zmtstart;	/* Zmodem starting Tx block size */
	unsigned zmblkmax;	/* Zmodem maximum block size and allocation */

	int point;		/* our point address */
	int altpoint;
	char textpath[PS];	/* path to .HLP, text .BBS files */

	char extra6[108];	/* RESERVED */

/* This is the size of FIDO.SYS. It was 0000h before version 12n. The idea
is that you read in XXXX bytes (the complete basic FIDO.SYS file) which gets
you all of the above fields. If areaoff is larger than what you just read,
read some more; it is an extended FIDO.SYS file. (Not yet used.) */

	unsigned areaoff;	/* size of main FIDO.SYS file -- offset to areas */
};

/* Bits for fido.fbits; these are converted into byte/bit. */

#define FBIT_QUICK 0		/* Q)uick login enable */
#define FBIT_SEENBY 1		/* dont display SEEN-BYs */
/* #define FBIT_ZMODE 2	*/	/* enable kludgey 12i "Zmode" */
#define FBIT_TSYNC 3		/* enable multiple TSYNCs */
#define FBIT_WAZOO 4		/* enable Wazoo */
#define FBIT_FSC001 5		/* force pure FSC001 protocols */
#define FBIT_FREQ 6		/* File Request enable */
#define FBIT_NEWCLR 7		/* Accept new callers */
#define FBIT_XFERDISP 8		/* Display file transfer status */
#define FBIT_NOMAIL 9		/* Do not run mail (huh?) */
#define FBIT_PATHDISP 10	/* Display File Area pathnames */
#define FBIT_KEEPNMP 11		/* keep .NMP files between events */
#define FBIT_DIETIFNA 12	/* enable Bob Hartman's DIETIFNA spoof */
#define FBIT_KPACKET 13		/* keep packets around after terminate */
#define FBIT_TLG 14		/* generate timelogs */
#define FBIT_NLG 15		/* generate net logs */
#define FBIT_LINGUAL 16		/* requires multiple COMMAND.SYS's / .INI's */
#define FBIT_YNAME 17		/* suppress "Y" as last name */
#define FBIT_V11 18		/* generate version 11 type files also */
#define FBIT_FNAME 19		/* allow free-format caller names */


/* This structure used to be stored on disk as NODELIST.SYS, but is now
filled in when needed, from the text file NODELIST.BBS. (Saves TONS of 
space). */

#define NODEVERS 8		/* nodelist version */

struct _ndat {
	struct _node node;	/* read from .IDX */
	int cost;		/* cost per call */
	int rate;		/* baud rate */
	char name[40];		/* node name */
	char phone[40];		/* phone number */
	char city[40];		/* city and state, */
	char pwd[9];		/* per-node password */
};

/* Node map; NODELIST.NMP. This is the N x N matrix that does the routing.
It is implemented as a reentrant table; look up NODE, then lookup the
ROUTE-TO node in the table, and use the NODE there. The bits determine
various other things.

The 0th record is special; see the _rptrcd structure definition below.

Note that this is no longer a very self-explantory structure; it is stored
in an extremely compact form. Instead of a simple 2 column table with each 
column a _node address, the first column is actually the .IDX index (since
it is read-only), and the second column is the record number that points
to the appropriate node address in the .IDX file again. Plus there's bits
in there. 

(Thanks Laeeth Isaacs for pointing out the redundant _node struct in NODEVER 5!) */

struct _nmp {
	unsigned route_recd;	/* route-to address record number */
	char bits;		/* see NMAP_ defs below */
	char attr;		/* see NMAP_ defs below */
};

/* This is the in-memory structure, built from the _node address contained
in the .IDX index file, and the _nmp data structure above. */

struct _nmap {			/* refer to NODELIST.SYS file for the version */
	struct _node node;	/* actual address (-1 for regions, etc) */
	unsigned route_recd;	/* route-to addresses record number */
	char bits;		/* see below */
	char attr;		/* see below */
};
#define NMAP_ACCEPT 1		/* ACCEPT-FROM this node */
#define NMAP_PU 2		/* PICKUP from this node */
#define NMAP_POLL 4		/* POLL this node */
#define NMAP_ALIAS 8		/* ALIAS these nodes */
#define NMAP_SEND 16		/* is marked as SEND-TO */
#define NMAP_HOLD 32		/* HOLD mail for this node */
#define NMAP_UPDATE 64		/* re-create the packet to this node */

/* These are nmap.attr defs. We distinguish between HOST and REGION by the 
node number; 0 means a HOST, and -1 means a REGION host. 125/0 is a net host 
and we do default host-routing; 10/0 is a region host and does not get default 
host routing; it is stored internally as 10/-1. */

#define NMAP_REGION 128		/* this (/0) node is a region host; no default host routing */

/* Nodelist index file; NODELIST.IDX and NODELIST.NDX. For .IDX, 'pos' is 
the actual NODELIST.BBS text record file position; for .NDX it is the 
record number of the index and nodelist entry. Since this file is public,
we simulate the original _node definition. */

struct _idx {
	int zone;		/* zone number */
	int net;		/* net number */
	int number;		/* node number */
	long pos;		/* record or position */
};

/* NODELIST.NTC file: this is an index to NODELIST.NMP entries that
have messages to them; it is created and used only during FidoNet time */

struct _ntc {
	struct _node node;	/* node address */
	unsigned recd;		/* recd # in .NMP, .IDX */
	unsigned time;		/* total connect time, seconds, */
	unsigned xfer_time;	/* file transfer time only, seconds, */
	long bytes;		/* total bytes transferred, */
	char msgs;		/* number of messages in the packet, */
	char files;		/* files in the packet, */
	char tries;		/* number of attempts to send, */
	char connects;		/* number of actual connections */
	char bits;		/* see below */
	char totl_tries;	/* total number of tries this event */
	char extra[4];		/* RESERVED */
};
#define NTC_SUCCESS 1		/* Status: sucessful transmission */
#define NTC_PD 2		/* Status: mail was picked up, dont send */
#define NTC_KILLED 4		/* Status: packets etc killed */
#define NTC_REPACKET 8		/* Status: recreate packet please (msg changed) */

#define NTC_PU 64		/* Attribute: attempt pickup */
#define NTC_HOLD 128		/* Attribute: do not call, hold for pickup */

/* Message packet header. */

#define PKTVER 2		/* v10 = 1, v11 = 2 ... */

/* PUBLIC */
struct _pkthdr {
	int orig_number;	/* v9 originating Node # */
	int dest_number;	/* v9 destination node */
	int year,month,day,hour,minute,second;
	int rate;		/* v9 OBSO RESERVED baud rate */
	int ver;		/* packet version */

	int orig_net;		/* v11 originating net number */
	int dest_net;		/* v11 destination net number */

	char product1;		/* v11 product type */
	char product2;		/* v11 extra byte */
	char pwd[8];		/* password */

	int orig_zone;		/* originating zone */
	int dest_zone;		/* destination zone */

	char extra[16];		/* extra bytes */
	long prod;		/* product dependent */
};

/* Wazoo hello packet. */

struct _wazoo {
	int signal;		/* always 0x006f */
	int version;
	int product;
	int rev;		/* major rev number */
	int ver;		/* letter code */
	char name[60];		/* system name */
	char sysop[20];		/* sysop name */
	unsigned zone;
	unsigned net;
	unsigned node;
	unsigned point;
	char password[8];
	char reserved[8];	/* Opus reserved */
	unsigned bits;		/* see below */
	char proprietary[12];
};

/* Capability bits for above. */

#define WAZ_DIETIFNA	1	/* can do DIETIFNA (not SEALINK!) */
#define WAZ_ZMODEM	8	/* can do ZMODEM */
#define WAZ_FREQ	32768	/* can do file requests */

/* This is the structure prepended to the nodemaps; it contains
information on the contents of the route file used to generate the
NMP file. To avoid storing FIDO.SYS data in here (which would remain
unchanged if SET-FIDO /K were used) variables are stored such that we
detect which ones are specified in the route file; only those are 
set at run time. (Very Icky.) */

struct _rptrcd {
	char revision;		/* nodelist file revision */
	char tag;		/* current schedule */
	char bits;		/* (see below) */
	char extra;

/* These are all int's, so that we can test for un-set as < 0. */

	int dial_interval;	/* how often to dial */
	int cont_interval;	/* how often to reenable CONT events */

	int rings;		/* number of rings to answer the phone */
	int connect_tries;	/* attempt with connect limit */
	int dial_tries;		/* dial attempts */

	int mailcode;		/* exit to DOS when msgs received */
	int filecode;		/* exit to DOS when files received */

	int iodev;		/* default serial channel number */
	int mdmtype;		/* type of modem (see fido.linkrate) */
	int maxbaud;		/* maximum baud rate */
	int cd_bit;		/* bit to test for Carrier Detect, */

	char mdmstr[40];	/* modem initialization string */
	char dial_pref[30];	/* FidoNet dial string prefix */
};

#define RPT_EXT 0		/* external mail flag shift value */
#define RPT_SO 1		/* send-only shift */
#define RPT_RO 2		/* recv-only shift */

#include <\fido\text.h>		/* path so's can be @include'd from \FIDO\TOOLS */
