/********************************************************************
**  YRCLANN.C v0.17T  Copyright (c) 1987, 1988, 1989 by Paul M. Sittler.
**
**  Produces Annual and Fiscal Year calendars for YEARCAL.
**
**  All rights reserved.  The copyright owner hereby authorizes the
**  no-charge, noncommercial making and/or distribution of copies of
**  the entirety of this work unchanged and unincorporated in any
**  other work (except "LiBRary" or "ARChive" disk files for the sole
**  purpose of no-charge noncommercial distribution).  No other
**  reproduction or use is authorized without the express prior
**  written consent of the copyright owner.
**
**************************************************************/

/* ANSI header files included:  */
#include <stdio.h>	/* fclose, fopen, fp, fprintf, fputs, */
			/* gets, printf, rename, sprintf, stderr */
#include <stdlib.h>	/* exit */
#include <string.h>	/* strcat, strcmp, strcpy, strlen */

#include "yearcal.def"

/* External variables and structures declared in YEARCAL.C */
extern struct month mon[];		/* Month's lengths array */
extern char *lingo[];			/* Names of languages array */
extern char *mnam[][12];		/* Names of months array */
extern char *wkday[][7];		/* Names of days array */
extern int yr[][12][6][7];		/* Array for 3 yrs, 4-D, */
					/* 3 years,      12 months/year, */
					/* 6 weeks/month, 7 days/week */
extern char *new_file;
extern char *file;
extern FILE *fp;



void cal_printer(int year, char out,  int bm,   char fy,
		 int bd,   char base, int lang, char pause)
/* char base;	Number base used, 0 = Decimal, H = Hex, O = Octal */
/* int lang;	Language used 1=Danish, 2=Dutch, 3=English etc. */
/* char pause;	Page pause True/False */
{
    char hdr1[] = {" Su Mo Tu We Th Fr Sa"},
	 hdr2[] = {" -- -- -- -- -- -- --"};

    int y,
	month,
	week,
	day,
	count,
	stat;
    char  linbuf[BUF],
	  temp[BUF];

    char *off = (out == 'V') ?
			 " " :
		   "       "  ;

    y = 1;				/* Make year this year */

    sprintf(hdr1, " %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s %2.2s",
	   wkday[lang - 1][0], wkday[lang - 1][1], wkday[lang - 1][2],
	   wkday[lang - 1][3], wkday[lang - 1][4], wkday[lang - 1][5],
	   wkday[lang - 1][6] );

    if (out == 'F')			/* Setup for file output */
    {
	sprintf(file, fy ? "%dFY%c" :
			   "%d%c",    year, base);
	strcpy(new_file, file);
	strcat(file, ".$$$");
	sprintf(temp, ".%3.3s", lingo[lang - 1]);
	strcat(new_file, temp);
	fp = fopen(file, "w");
    }

    if (pause     &&			/* User wants time after each page */
	out == 'P' )			/* Gets printed to add paper etc... */
	hold();				/* Wait for keystroke */

    fputs("\n\n\n", fp);
    sprintf(temp, fy ? "%s%s%s Calendar for Fiscal Year %d-%d":
		       "%s%s%s Calendar for %d",
		 base ? "Programmer's " :
			"" ,
		 base ? ( (base == 'O') ? "Octal "      :
					  "Hexadecimal " ) :
					  "",
		 lingo[lang - 1],
		 year, year + 1);

    fputs(center(temp, (out == 'V') ?
				 75 :
				 89 ), fp);
    fputs("\n\n\n", fp);

    if (bd == 1)			/* If fy month starts on 1st, */
	fy = FALSE;			/*   treat like ordinary month */

    for (month = bm;			/* Start at beginning Month for FY */
	 month < (12 + bm + fy);
	 month += 3)
    {					/* 4 sets of months */
					/* 3 months across */
	sprintf(linbuf,
	     "%s%s    ",
	      off,
		center(mnam[lang - 1][month % 12], 21));

	if (month != (bm + 12))		/* NOT FY and 13th month */
	{
	    sprintf(temp,
		"%s    ",
		 center(mnam[lang - 1][(month + 1) % 12], 21));
	    strcat(linbuf, temp);
	    sprintf(temp,
		"%s"    ,
		 center(mnam[lang - 1][(month + 2) % 12], 21));
	    strcat(linbuf, temp);
	}

	strcat(linbuf, "\n");		/* Add a newline */
	fputs(linbuf, fp);		/* Names of three Months */
	linbuf[0] = '\0';

	if (month != (bm + 12))		/* NOT FY and 13th month */
	{
	    fprintf(fp, "%s%s    %s    %s\n",
			off, hdr1, hdr1, hdr1);
	    fprintf(fp, "%s%s    %s    %s\n",
			off, hdr2, hdr2, hdr2);
	}
	else				/* FY and 13th month */
	if (bd != 1)			/* Beginning after the 1st */
	{
	    fprintf(fp, "%s%s\n",	/* Names of weekdays */
			off, hdr1);
	    fprintf(fp, "%s%s\n",	/* Lines of dashes */
			off, hdr2);
	}

	for (week = 0;			/* One line per week */
	     week < 6;			/* 6 wks/month possible */
	     week++)
	{
	    sprintf(linbuf, off);

	    for (count = 0;		/* 3 months/line ordinarily */
		 count < ((month == (bm + 12)) ?
					    1 : /* FY 13th month alone */
					    3); /* Ordinary line */
		 count++)
	    {
		for (day = 0;
		     day < 7;		/* 7 days/week */
		     day++)
		{
		    if (((month + count) == bm) &&  /* FY 1st month */
			(yr[y][month + count][week][day] < bd))
			 sprintf(temp, "   ");
		    else
		    if (((month + count) == (bm + 12)) &&
			(yr[y][month + count][week][day] >= bd))
			 sprintf(temp, "   ");
		    else
		    sprintf(temp,
			yr[y][month + count][week][day] ?
			    (base ?
				((base == 'O') ?
					 "%3o" :
					 "%3X" ) :
					 "%3d" ) :
					 "   ",
			yr[y][month + count][week][day]);

		    strcat(linbuf, temp);
		}

		strcat(linbuf,
		count < ((month < (bm + 12)) ?
					  2 : 0) ?
					   "    ":
					   "\n"  );
	    }

	    fputs(linbuf, fp);
	    linbuf[0] = '\0';
	}
	fputs("\n\n", fp);
    }
    if (out != 'V')
	fputs("\f\r", fp);		/* No FF for screen */

    if (out == 'F')			/* Setup for file output */
	if ((stat = fclose(fp)) == ERROR)
	    printf("\nCan't close %s.\n", file);

    if (out == 'F')
    {
	if ((stat = rename(file, new_file)) == ERROR)
	{
	    printf(
	    "\nCan't rename %s to %s.  %s may already exist.\n",
			    file, new_file,
				       new_file);
	}
    }
}
