(*--------------------------------------------------------------------------*)
(*                      SetBase --- Set default base                        *)
(*--------------------------------------------------------------------------*)

PROCEDURE SetBase( b: basety );

BEGIN  (* SetBase *)

   CheckEol;

   base := b;

END    (* SetBase *);

(*--------------------------------------------------------------------------*)
(*                     SetAngle --- Set units for trig functions            *)
(*--------------------------------------------------------------------------*)

PROCEDURE SetAngle( a: anglety );

BEGIN  (* SetAngle *)

   CheckEol;
   angle := a;

END    (* SetAngle *);

(*--------------------------------------------------------------------------*)
(*        SetFrac --- Set no. of digits to display after dec. pt.           *)
(*--------------------------------------------------------------------------*)

PROCEDURE SetFrac;

LABEL
   99  (* ERROR EXIT *);

BEGIN  (* SetFrac *)

   NextTok;
                                   (* Look for equal sign *)
   IF Token <> equalssy THEN
      BEGIN
         SynErr;
         GOTO 99;
      END;

   NextTok;
                                   (* Look for constant *)
   IF Token <> constsy THEN
      BEGIN
         SynErr;
         GOTO 99;
      END;
                                   (* Check for garbage after constant *)
   CheckEol;
   IF ErrorFlag THEN GOTO 99;
                                   (* Must have integer constant *)
   WITH constval DO
   BEGIN

      IF typ <> INT THEN
         BEGIN
            SynErr;
            GOTO 99;
         END;
                                   (* Must have <= 15 decimal places *)
      IF i > 15 THEN
         BEGIN
            Error('FRAC must be <= 15');
            GOTO 99;
         END;

      FRAC := i;

   END;

99:
END  (* SetFrac *);
