#define HEADER "C++ Problem 4.4 by Rick Conn using Borland C++"

#include <stdio.h>
#include <time.h>

class time_stamp {
  time_t stamp;
public:
  time_stamp();
  ~time_stamp();
  void showtime(void);
};

time_stamp::time_stamp() {
  time (&stamp);
  printf("  Time_Stamp constructor called\n");
}

time_stamp::~time_stamp() {
  printf("  Time_Stamp destructor called\n");
}
void time_stamp::showtime(void) {
  printf("Time Stamp: %s", ctime (&stamp));
}

class message : private time_stamp {
  char *msg;
public:
  message (char *);
  ~message();
  void print(void);
};

message::message (char *m) {
  msg = m;
  printf("  Message constructor called\n");
}
message::~message() {
  printf("  Message destructor called\n");
}
void message::print(void) {
  printf("Message \"%s\"  ", msg);
  showtime();
}

class message2 : public time_stamp {
protected:
  char *msg;
public:
  message2 (char *);
  ~message2();
  void print(void);
};

message2::message2 (char *m) {
  msg = m;
  printf("  Message2 constructor called\n");
}
message2::~message2() {
  printf("  Message2 destructor called\n");
}
void message2::print(void) {
  printf("Message2 \"%s\"  ", msg);
  showtime();
}

class priority_message : public message2 {
  char *urgency;
public:
  priority_message (char *m, char *u);
  ~priority_message();
  void print(void);  // includes urgency info
};

priority_message::priority_message (char *m, char *u) :
  message2(m) {
    urgency = u;
    printf("  Priority_Message constructor called\n");
}
priority_message::~priority_message() {
  printf("  Priority_Message destructor called\n");
}
void priority_message::print(void) {
  printf("Urgency %s: %s  -- ", urgency, msg);
  showtime();
}

void main(void)
{
  printf("%s\n", HEADER);

  priority_message pm1("This is a test", "Routine");
  priority_message pm2("Em Situation", "Emergency");

  pm1.print();
  pm2.print();
}
