-- Problem 4.1
-- by Rick Conn
with Text_IO;
procedure Main is

  type COMPLEX_NUMBER is record
    RP : FLOAT := 0.0;  -- initialize to 0,0
    IP : FLOAT := 0.0;
  end record;

  N1, N2, N3 : COMPLEX_NUMBER;

  package Float_IO is new Text_IO.Float_IO (FLOAT);

  function "+" (Left, Right : in COMPLEX_NUMBER)
      return COMPLEX_NUMBER is
  begin
    return (Left.RP + Right.RP, Left.IP + Right.IP);
  end "+";

  function "-" (Left, Right : in COMPLEX_NUMBER)
      return COMPLEX_NUMBER is
  begin
    return (Left.RP - Right.RP, Left.IP - Right.IP);
  end "-";

  function "*" (Left, Right : in COMPLEX_NUMBER)
      return COMPLEX_NUMBER is
  begin
    return (Left.RP * Left.RP - Right.RP * Right.RP,
            Left.RP * Right.IP + Left.IP * Right.RP);
  end "*";

  procedure Print (Item : in COMPLEX_NUMBER) is
  begin
    Float_IO.Put (Item.RP, 5, 5, 0);
    Text_IO.Put (" + ");
    Float_IO.Put (Item.IP, 5, 5, 0);
    Text_IO.Put ("j");
  end Print;

  procedure Print_All is
  begin
    Text_IO.Put ("N1   = "); Print (N1); Text_IO.New_Line;
    Text_IO.Put ("  N2 = "); Print (N2); Text_IO.New_Line;
    Text_IO.Put ("  N3 = "); Print (N3); Text_IO.New_Line;
  end Print_All;

begin -- Main

  Print_All;
  N1 := (2.2, 4.4);
  N2 := (1.0, 12.2);
  N3 := N1 + N2;
  Text_IO.Put_Line ("Sum:");
  Print_All;
  N3 := N1 - N2;
  Text_IO.Put_Line ("Difference:");
  Print_All;
  N3 := N1 * N2;
  Text_IO.Put_Line ("Product:");
  Print_All;

end Main;
