-- Problem 2.7
-- by Rick Conn
with Text_IO;
procedure Main is

  type BOOK is record
    Title       : STRING(1..80);
    Title_Last  : NATURAL;
    Author      : STRING(1..80);
    Author_Last : NATURAL;
    Price       : FLOAT;
    Year        : INTEGER;
  end record;

  package Float_IO is new Text_IO.Float_IO (FLOAT);
  package Int_IO is new Text_IO.Integer_IO (INTEGER);

  function Setup (Title  : in STRING;
                  Author : in STRING;
                  Price  : in FLOAT;
                  Year   : in INTEGER) return BOOK is
    Local_Book : BOOK;
  begin
    Local_Book.Title(1..Title'LENGTH) := Title;
    Local_Book.Title_Last := Title'LENGTH;
    Local_Book.Author(1..Author'LENGTH) := Author;
    Local_Book.Author_Last := Author'LENGTH;
    Local_Book.Price := Price;
    Local_Book.Year  := Year;
    return Local_Book;
  end Setup;

  procedure Display (Item : in BOOK) is
  begin
    Text_IO.Put_Line ("Title: " & Item.Title(1..Item.Title_Last));
    Text_IO.Put_Line ("  Author: " & Item.Author(1..Item.Author_Last));
    Text_IO.Put ("  Price: $");
      Float_IO.Put (Item.Price, 2, 2, 0);
      Text_IO.New_Line;
    Text_IO.Put ("  Year: ");
      Int_IO.Put (Item.Year, 4);
      Text_IO.New_Line;
  end Display;

begin -- Main

  declare
    My_Book   : BOOK;
    His_Book  : BOOK;
    Your_Book : BOOK;
  begin  -- block
    My_Book   := Setup ("War and Peace",
                        "Tolstoy",
                        39.95,
                        1912);
    His_Book  := Setup ("Software Engineering with Ada",
                        "Booch",
                        19.95,
                        1987);
    Your_Book := Setup ("Fun and Games",
                        "Dick and Jane",
                        5.95,
                        1990);

    Display (My_Book);
    Display (His_Book);
    Display (Your_Book);
  end;

end Main;
