-- Problem 2.1
-- by Rick Conn
package Colors is

  type COLOR is (RED, GREEN, BLUE, YELLOW, ORANGE,
                 TURQUOISE, MAGENTA, VIOLET);

  procedure Display (Last_Color : in COLOR);

end Colors;

with Text_IO;  -- context clause
package body Colors is

  procedure Display (Last_Color : in COLOR) is
  begin
    Text_IO.Put_Line ("Color Display:");
    for C in COLOR'FIRST .. Last_Color loop
      Text_IO.Put_Line ("   " & COLOR'IMAGE(C));
        -- string concatenation is used to offset the image
    end loop;
  end Display;

end Colors;

with Colors;
procedure Main is
begin
  Colors.Display(Colors.ORANGE);
  Colors.Display(Colors.RED);
  Colors.Display(Colors.VIOLET);
end Main;
