--***************************************************************--
--                                                               --
--  TITLE:          AN ADA SOFTWARE METRIC                       --
--                                                               --   
--  MODULE NAME:    PACKAGE SPECIFICATION PARSE_2B               --
--  FILE NAME:      PARSE_2B.ADS                                 --
--                                                               --
--  LAST MODIFIED:  02 MAR 90                                    --
--                                                               --
--  DESCRIPTION:  This package contains thirty-three functions   --
--       that are the middle level productions for our top-down, --
--       recursive descent parser.  Each function is preceded    --
--       by the grammar productions they are implementing.       --
--                                                               --  
--  CHANGE LOG:                                                  --
--              - added the check for a semicolon in function    --
--                RECORD_REPRESENTATION_CLAUSE (bug fix).        --
--                                                               --  
--  COPYRIGHT:  The Ada source code in this file is Copyright    --
--              1990 by Source Translation & Optimization. There --
--              are no restrictions to the use of this source    --
--              code in any product or system that is released   --
--              in non-source code form. Resale of this source   --
--              code, without permission of STO, is a violation  --
--              of our Copyright.                                --
--                                                               --
--                                                               --
--  HELP:       For more information contact: Gregory Aharonian  --
--              Source Translation & Optimization, P.O. Box 404  --
--              Belmont, MA, 02178-0404            617-489-3727  --
--***************************************************************--

package PARSE_2B is

  function GENERIC_ASSOCIATION            return boolean;
  function GENERIC_FORMAL_PARAMETER       return boolean;
  function TYPE_DEFINITION                return boolean;
  function RECORD_TYPE_DEFINITION         return boolean;
  function COMPONENT_LIST                 return boolean;
  function COMPONENT_DECLARATION          return boolean;
  function VARIANT_PART                   return boolean;
  function VARIANT                        return boolean;
  function IDENTIFIER_DECLARATION_TAIL    return boolean;
  function EXCEPTION_TAIL                 return boolean;
  function CONSTANT_TERM                  return boolean;
  function IDENTIFIER_TAIL                return boolean;
  function ASSIGNMENT_OR_PROCEDURE_CALL   return boolean;
  function RECORD_REPRESENTATION_CLAUSE   return boolean;

--
-- The following procedures are declared locally in the package body
--
--    function IDENTIFIER_LIST_B return boolean;


end PARSE_2B;
