#ifndef __EMU_WRAPPER_H
#define __EMU_WRAPPER_H

#include <linux/version.h>

#define UP_INODE_SEM(a)
#define DOWN_INODE_SEM(a)

#define GET_INODE_STRUCT()

#define vma_get_pgoff(v)	((v)->vm_pgoff)

#define compat_request_region request_region

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
static inline void *pci_get_drvdata (struct pci_dev *pdev)
{
        return pdev->driver_data;
}

static inline void pci_set_drvdata (struct pci_dev *pdev, void *data)
{
        pdev->driver_data = data;
}
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,3)
int pci_set_dma_mask(struct pci_dev *dev, dma_addr_t mask);
#endif

#undef MOD_INC_USE_COUNT
#define MOD_INC_USE_COUNT

#undef MOD_DEC_USE_COUNT
#define MOD_DEC_USE_COUNT

#endif
