#include "vidconf.h"
#include "vidcapreg.h"
#include "codecconf.h"

#include <fourcc.h>
#include <cpuinfo.h>

#include <qlineedit.h>
#include <qfiledialog.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qspinbox.h>



/*
 *  Constructs a VidConfig which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
VidConfig::VidConfig( QWidget* parent, v4lxif*& v4l )
    : VidcapConfigDialog( parent, "Configure QtVidcap", true, 0 )
{
    char str[256];//any integers longer than this out there?

    _CapDevice->setText(RS("CapDev", "/dev/video").c_str());
    //ask hw
    //fixme

    int resolution=384;
    _Resolution->insertItem("160x120");
    _Resolution->insertItem("192x144");
    _Resolution->insertItem("320x240");
    _Resolution->insertItem("384x288");
    _Resolution->insertItem("400x300");
    _Resolution->insertItem("512x384");
    _Resolution->insertItem("576x432");
    _Resolution->insertItem("640x480");
    _Resolution->insertItem("768x576");

    _Resolution->setCurrentItem(RI("Resolution", 0));

    _VideoColorMode->insertItem("PAL");
    _VideoColorMode->insertItem("NTSC");
    _VideoColorMode->insertItem("SECAM");
    _VideoColorMode->insertItem("Auto");
    _VideoColorMode->setCurrentItem(RI("ColorMode", 0));

    _VideoChannel->clear();
    if(v4l)
        for(int i=0; i<v4l->capCapChannelC(); i++)
	    _VideoChannel->insertItem(v4l->capChannelName(i));
    _VideoChannel->setCurrentItem(RI("Channel", 1));
    
    _Colorspace->insertItem("RGB24");
    _Colorspace->insertItem("YUY2");
    _Colorspace->insertItem("YV12");
    _Colorspace->setCurrentItem(RI("Colorspace", 0));

    _FileName->setText(RS("FileName", "./movie.avi").c_str());

    sprintf(str, "%d", RI("SegmentSize", 1000*1000));
    _SegmentSize->setText(str);

    _HaveSegmented->setChecked(RI("IsSegmented", 1));

    _HaveAudio->setChecked(RI("HaveAudio", 1));

    _listChan->insertItem( tr( "Mono" ) );
    _listChan->insertItem( tr( "Stereo" ) );
    _listChan->setCurrentItem(RI("SndChannels", 0));

    _listFreq->insertItem( tr( "48000 Hz" ) );
    _listFreq->insertItem( tr( "44100 Hz" ) );
    _listFreq->insertItem( tr( "22050 Hz" ) );
    _listFreq->insertItem( tr( "11025 Hz" ) );
    _listFreq->setCurrentItem(RI("Frequency", 0));

    _listSamp->insertItem( tr( "16 bit" ) );
    _listSamp->insertItem( tr( "8 bit" ) );
    _listSamp->setCurrentItem(RI("SampleSize", 0));

    _info.compressor=RI("Compressor", fccIV50);
    _info.quality=RI("Quality", 9500);
    _info.keyfreq=RI("Keyframe", 15);

    sprintf(str, "%.4s / %d", (char*) &_info.compressor,
	    _info.quality/100);
    _codecName->setText(str);

    _chkTime->setChecked(RI("LimitTime", 0));
    _chkFileSize->setChecked(RI("LimitSize", 0));

    sprintf(str, "%d", RI("SizeLimit", 2000000));
    _sizeLimit->setText(str);
    sprintf(str, "%d", RI("TimeLimit", 3600));
    _timeLimit->setText(str);

    _fps->setValue((int)RF("FPS", 25.));

    connect(buttonApply, SIGNAL(clicked()), this, SLOT(apply()));
}

/*
 *  Destroys the object and frees any allocated resources
 */
VidConfig::~VidConfig()
{
    // no need to delete child widgets, Qt does it all for us
}

void VidConfig::accept()
{
    savePage(0);
    savePage(1);
    savePage(2);
    savePage(3);
    QDialog::accept();
}

void VidConfig::apply()
{
#if QT_VERSION>=219
    savePage(tabWidget->currentPageIndex());
#else
    savePage(0);
    savePage(1);
    savePage(2);
    savePage(3);
#endif
}

void VidConfig::savePage(int page)
{
    switch(page)
    {
    case 0:
	WS("CapDev", _CapDevice->text());
	WI("Resolution", _Resolution->currentItem());
	WI("Channel", _VideoChannel->currentItem());
	WI("ColorMode", _VideoColorMode->currentItem());
	WI("Colorspace", _Colorspace->currentItem());
	break;
    case 1:
	WS("FileName", _FileName->text());
	WI("SegmentSize", _SegmentSize->text());
	WI("IsSegmented", _HaveSegmented->isChecked());
	WF("FPS", (float)_fps->value());
	break;

    case 2:
	WI("Compressor", _info.compressor);
	WI("Quality", _info.quality);
	WI("Keyframe", _info.keyfreq);
	WI("HaveAudio", _HaveAudio->isChecked());
	WI("SampleSize", _listSamp->currentItem());
	WI("Frequency", _listFreq->currentItem());
	WI("SndChannels", _listChan->currentItem());
	break;
    case 3:
	WI("TimeLimit", _timeLimit->text());
	WI("SizeLimit", _sizeLimit->text());
	WI("LimitTime", _chkTime->isChecked());
	WI("LimitSize", _chkFileSize->isChecked());
	break;
    }
}
/*
 * public slot
 */
void VidConfig::change_filename()
{
    QString str=QFileDialog::getOpenFileName(_FileName->text(), QString("*.avi;*.AVI"));
    if(!str.isNull())
	_FileName->setText(str);
}
/*
 * public slot
 */
void VidConfig::change_codec()
{
    EncoderParam ep;
    switch(_Colorspace->currentItem())
    {
    case 0:
	ep.fourcc=24;
	break;
    case 1:
	ep.fourcc=fccYUY2;
	break;
    case 2:
	ep.fourcc=fccYV12;
	break;
    }
    switch(_Resolution->currentItem())
    {
    case 0:
	ep.xdim=160;
	ep.ydim=120;
	break;
    case 1:
	ep.xdim=192;
	ep.ydim=144;
	break;
    case 2:
	ep.xdim=320;
	ep.ydim=240;
	break;
    case 3:
	ep.xdim=384;
	ep.ydim=288;
	break;
    case 4:
	ep.xdim=400;
	ep.ydim=300;
	break;
    case 5:
	ep.xdim=512;
	ep.ydim=384;
	break;
    case 6:
	ep.xdim=576;
	ep.ydim=432;
	break;
    case 7:
	ep.xdim=640;
	ep.ydim=480;
	break;
    default:
	ep.xdim=768;
	ep.ydim=576;
	break;
    }
    CodecConfig conf(this, _info, ep);
    if(conf.exec()==QDialog::Accepted)
    {
	_info=conf.GetInfo();
	char str[256];
	sprintf(str, "%.4s/%d", (char*) &_info.compressor, _info.quality/100);
	_codecName->setText(str);
    }
}
/*
 * public slot
 */
void VidConfig::toggle_audio(bool res)
{
    _listSamp->setEnabled(res);
    _listFreq->setEnabled(res);
    _listChan->setEnabled(res);
}
/*
 * public slot
 */
void VidConfig::toggle_segmented(bool res)
{
    _SegmentSize->setEnabled(res);
}

void VidConfig::toggle_limitsize(bool res)
{
    _sizeLimit->setEnabled(res);
}

void VidConfig::toggle_limittime(bool res)
{
    _timeLimit->setEnabled(res);
}


#include "vidconf.moc"
#include "vidconf_p.moc"
