#ifndef _VIDCAPREG_H
#define _VIDCAPREG_H
#include <configfile.h>

using namespace Registry;

static const avm::string Module = "QtVidcap";

inline int RI(const avm::string& name, int def)
{
    return ReadInt(Module, name, def);
}

inline avm::string RS(const avm::string& name, const avm::string& def)
{
    return ReadString(Module, name, def);
}

inline float RF(const avm::string& name, float def)
{
    return ReadFloat(Module, name, def);
}

inline void WI(const avm::string& name, int def)
{
    WriteInt(Module, name, def);
}
inline void WS(const avm::string& name, const avm::string& def)
{
    WriteString(Module, name, def);
}

inline void WF(const avm::string& name, float def)
{
    WriteFloat(Module, name, def);
}
#ifdef QSTRING_H

#include <stdlib.h>

inline void WI(const avm::string& name, const QString& def)
{
    WriteInt(Module, name, atoi(def.ascii()));
}

inline void WS(const avm::string& name, const QString& def)
{
    WriteString(Module, name, def.ascii());
}

inline void WF(const avm::string& name, const QString& def)
{
    WriteFloat(Module, name, atof(def.ascii()));
}
#endif

#endif
