#include <qwidget.h>
#include <qtimer.h>
#include <Locker.h>
class ShmRenderer;
class QPopupMenu;
class v4lxif;
class PicturePropDialog;
class AviCapDialog;
class ClosedCaption;
class QLabel;
class V4LWindow: public QWidget
{
    Q_OBJECT
friend class AviCapDialog;
public:
    enum Modes { Overlay, Preview, DeinterlacedPreview };
protected:
    Modes m_eMode;
public:
    Modes getMode() const { return m_eMode; }
    void setMode(Modes m);
protected:    
    v4lxif* m_pDev;
    ShmRenderer* m_pRenderer;
private:    
    PthreadMutex m_Mutex;
    QPopupMenu* m_pPopup;
    PicturePropDialog* m_pPicConfig;
    AviCapDialog* m_pCapDialog;
    ClosedCaption* m_pCC;
    bool m_bForce4x3;
    bool m_bSubtitles;
    bool known_pos;
    bool m_bAutoRecord;
    QTimer m_timer;
    QTimer m_cctimer;
    QTimer m_CaptureTimer;
    QLabel* m_pLabel;
public:
    V4LWindow(v4lxif * pDev, QWidget * pParent=0);
    void setupDevice();
    void setAutoRecord() { m_bAutoRecord = true; }
    void unregisterCapDialog() { m_pCapDialog = 0; }
protected:
    virtual void moveEvent( QMoveEvent * );
    virtual void showEvent( QShowEvent * );
    virtual void hideEvent( QHideEvent * );
    virtual void focusInEvent( QFocusEvent * );
    virtual void focusOutEvent( QFocusEvent * );
    virtual void enterEvent( QEvent * );
    virtual void leaveEvent( QEvent * );    
    virtual void resizeEvent( QResizeEvent * );
    virtual void mouseReleaseEvent( QMouseEvent * );
    virtual void keyPressEvent( QKeyEvent * );
    virtual bool x11Event( XEvent * );    
public slots:
    void config();
    void hidePopup();
    void force4x3();
    void captureAVI();
    void captureBMP();
    void captureJPG();
    void picprop();
    void timerStop();
    void showsub();
    void updatesub();
    void overlay();
    void preview();
    void deinterlaced_preview();
    void preview_display();
public:
    void get_clips();
    ClosedCaption* getcc() { return m_pCC; }
protected: // x11 stuff for handling overlay clipping
    void add_clip(int x1, int y1, int x2, int y2);

    int wmap;    
    /*
	case MapNotify:
	    wmap=1;
	case UnmapNotify:
	    wmap=0;
*/
    int  visibility;
/*
	case VisibilityNotify:
	    if (event->xvisibility.window == WINDOW(video)) {
		visibility = event->xvisibility.state;
*/

    int oc_count;
    int conf;
    struct OVERLAY_CLIP
    {
	int x1, y1, x2, y2;
    };
    OVERLAY_CLIP   oc[32];
protected:
    void setupPicDimensions(int* =0, int* =0);
    void getOverlaySizeAndOffset(int *pw, int *ph, int* pdx=0, int* pdy=0);
};
