extern "C" {
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/XShm.h>
};

class QWidget;
class QPaintDevice;
class ShmRenderer
{
    bool	       xshminit;
    XShmSegmentInfo xshminfo;
    XImage	      *xshmimg;
    Pixmap	       xshmpm;
    GC 			gc;
    pthread_mutex_t mutex;
    int xpos, ypos;
    int m_w, m_h, pic_w, pic_h;
    QPaintDevice* dev;
    void alloc();
    int free();
public:
    ShmRenderer(QWidget* w, int x, int y, int xpos=0, int ypos=0);
    int resize(int& new_w, int& new_h);
    int draw(QPainter* pm, const void* data, bool deinterlace=false);
    int getWidth() const {return m_w;}
    int getHeight() const {return m_h;}
    int sync();
    ~ShmRenderer();
};
