#include "picprop.h"
#include "vidcapreg.h"
#include "v4lxif.h"
#include <stdio.h>
#include <qlabel.h>
#include <qslider.h>
/* 
 *  Constructs a PicturePropDialog which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
PicturePropDialog::PicturePropDialog(v4lxif* pDev)
    : PicPropDialog( 0, 0, FALSE, 0), m_pDev(pDev)
{
    connect(BrightnessSlider, SIGNAL(valueChanged(int)), this, SLOT(change_brightness(int)));
    connect(ContrastSlider, SIGNAL(valueChanged(int)), this, SLOT(change_contrast(int)));
    connect(HueSlider, SIGNAL(valueChanged(int)), this, SLOT(change_hue(int)));
    connect(SaturationSlider, SIGNAL(valueChanged(int)), this, SLOT(change_saturation(int)));

    BrightnessSlider->setValue(RI("Image\\Brightness", 0));
    ContrastSlider->setValue((RI("Image\\Contrast", 255)-255)/2);
    SaturationSlider->setValue((RI("Image\\Color", 255)-255)/2);
    HueSlider->setValue(RI("Image\\Hue", 0));    
//    printf("Reading: %d %d %d %d\n",
//	RI("Image\\Brighness", 0),
//	RI("Image\\Contrast", 255),
//	RI("Image\\Color", 255),
//	RI("Image\\Hue", 0)
//	);
    m_pDev->setPicBrightness(RI("Image\\Brightness", 0));
    m_pDev->setPicConstrast(RI("Image\\Contrast", 255));
    m_pDev->setPicColor(RI("Image\\Color", 255));
    m_pDev->setPicHue(RI("Image\\Hue", 0));
}

void PicturePropDialog::change_brightness(int val)
{
    if(val<-127)
	val=-127;
    if(val>127)
	val=127;
    char s[128];
    sprintf(s, "Brightness: %d", val);
    BrightnessText->setText(s);
    m_pDev->setPicBrightness(val);
}
void PicturePropDialog::change_contrast(int val)
{
    char s[128];
    sprintf(s, "Contrast: %d", val);
    ContrastText->setText(s);
    val=2*(val+128);
    if(val>511)
	val=511;
    m_pDev->setPicConstrast(val);
}
void PicturePropDialog::change_hue(int val)
{
    if(val<-127)
	val=-127;
    if(val>127)
	val=127;
    m_pDev->setPicHue(val);
    char s[128];
    sprintf(s, "Hue: %d", val);
    HueText->setText(s);
}
void PicturePropDialog::change_saturation(int val)
{
    char s[128];
    sprintf(s, "Saturation: %d", val);
    SaturationText->setText(s);
    val=2*(val+128);
    if(val>511)
	val=511;
    m_pDev->setPicColor(val);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
PicturePropDialog::~PicturePropDialog()
{
    // no need to delete child widgets, Qt does it all for us
}

void PicturePropDialog::accept()
{
    WI("Image\\Brightness", BrightnessSlider->value());
    WI("Image\\Color", 256+2*SaturationSlider->value());
    WI("Image\\Contrast", 256+2*ContrastSlider->value());
    WI("Image\\Hue", HueSlider->value());
//    printf("Writing: %d %d %d %d\n",
//	BrightnessSlider->value(),
//	256+2*ContrastSlider->value(),
//	256+2*SaturationSlider->value(),
//	HueSlider->value()
//	);	
    return QDialog::accept();
}

#include "picprop_p.moc"
#include "picprop.moc"
