#ifndef CODECCONFIG_H
#define CODECCONFIG_H
#include "codecconf_p.h"
#include <infotypes.h>
#include <videoencoder.h>

struct EncoderParam
{
    fourcc_t fourcc;
    int xdim;
    int ydim;
};

class CodecConfig : public CodecConfigDialog
{ 
    Q_OBJECT
    avm::vector<CodecInfo> private_list;
public:
    CodecConfig( QWidget*, const VideoEncoderInfo& info, const EncoderParam& req);
    ~CodecConfig();
    VideoEncoderInfo GetInfo();    
public slots:
    virtual void SelectCodec();    
    virtual void accept();
    virtual void change_attr(QListViewItem* item);
    virtual void about_clicked();
};

#endif // CODECCONFIG_H
