#include "v4lxif.h"
#include <default.h>
#include <avm_stl.h>
class ClosedCaption
{
    int m_iRefcnt;
public:
//    ClosedCaption(const char* pcDevName="/dev/vbi");
    ClosedCaption(v4lxif* pv4l);
    ~ClosedCaption();
    
    void lock() { pthread_mutex_lock(&m_mutex); }
    const char* getBuffer() { return storage; }
    void unlock() { pthread_mutex_unlock(&m_mutex); }

    typedef void (*callbackproc) (void*, const char*);
    void add_callback(callbackproc p, void* arg);
    void remove_callback(callbackproc p, void* arg);
    
    void addref(){ m_iRefcnt++; }
    void release(){ m_iRefcnt--; if(m_iRefcnt==0) delete this; }
private:    
    struct callback_info
    {
	callbackproc proc;
	void* arg;
	void exec(const char* p) { return proc(arg, p); }	
    };
    avm::vector<callback_info> m_callbacks;
    
    void* mainloop();
    static void* threadstarter(void*);
    
    int CCdecode(int data);
    int decode(unsigned char *vbiline);

// Member variables
    int m_iDev;
    v4lxif* m_pV4l;
    int m_iQuit;
    pthread_t m_thread;
    pthread_mutex_t m_mutex;
    int	lastcode;
    int	ccmode;		//cc1 or cc2
    char plain;
    char ccbuf[3][256];		//cc is 32 columns per row, this allows for extra characters
    
    char storage[256];    
/*
  meaning unclear    
    int	keywords=0;
    char *keyword[32];
*/
// Global constants
    static const char* const ratings[];
    static const int rowdata[];
    static const char* const specialchar[];
    static const char* const modes[];
};
