#ifndef REGACCESS_H
#define REGACCESS_H

#include <qfont.h>
#include <registry.h>
#include <wine/winreg.h>
#include <stdio.h>

class RegAccess
{ 
protected:
    static const float g_fAsync=.5f;
    QFont m_defFont;
public:    
    static QFont ReadFont()
    {
	int result, status, newkey;
	result=RegCreateKeyExA(HKEY_CURRENT_USER, "Software\\AviPlayer\\Font", 0, 0, 0, 0, 0,
			&newkey, &status);
	if(result!=0)
	    return QFont("Helvetica", 10);
	if(status==REG_CREATED_NEW_KEY)
	{
	    RegCloseKey(newkey);
	    WriteFont();
	    return QFont("Helvetica", 10);
	}
	char name[50];
	int size;
	int bold;
	int italic;
	int charset;
	
	int count=50;
	result=RegQueryValueExA(newkey, "Family", 0, 0, (int*)&name, &count)
;
	if(result!=0)strcpy(name, "Helvetica");
	
	count=4;
	result=RegQueryValueExA(newkey, "Size", 0, 0, (int*)&size, &count)
;
	if(result!=0)size=10;

	count=4;
	result=RegQueryValueExA(newkey, "Bold", 0, 0, (int*)&bold, &count)
;
	if(result!=0)bold=QFont::Normal;
	
	count=4;
	result=RegQueryValueExA(newkey, "Italic", 0, 0, (int*)&italic, &count)
;
	if(result!=0)italic=0;
	
	count=4;
	result=RegQueryValueExA(newkey, "Charset", 0, 0, (int*)&charset, &count)
;
	if(result!=0)charset=QFont::ISO_8859_1;

	return QFont(QString(name), size, bold, (bool)italic, (QFont::CharSet)charset);
    }
    static void WriteFont(const QFont& font=QFont("Helvetica", 10))
    {
	int result, status, newkey;
	result=RegCreateKeyExA(HKEY_CURRENT_USER, "Software\\AviPlayer\\Font", 0, 0, 0, 0, 0,
			&newkey, &status);
	if(result!=0)
	    return;

        result=RegSetValueExA(newkey, "Family", 0, REG_SZ, 
	    (int*)font.family().ascii(), font.family().length()+1);
	int val=font.pointSize();
        result=RegSetValueExA(newkey, "Size", 0, REG_DWORD, &val, 4);
	val=font.weight();
        result=RegSetValueExA(newkey, "Bold", 0, REG_DWORD, &val, 4);
	val=font.italic();
        result=RegSetValueExA(newkey, "Italic", 0, REG_DWORD, &val, 4);
	val=font.charSet();
        result=RegSetValueExA(newkey, "Charset", 0, REG_DWORD, &val, 4);
    }
    static float ReadAsync()
    {
	int result, status, newkey;
	result=RegCreateKeyExA(HKEY_CURRENT_USER, "Software\\AviPlayer", 0, 0, 0, 0, 0,
			&newkey, &status);
	if(result!=0)
	    return g_fAsync;
	if(status==REG_CREATED_NEW_KEY)
	{
	    RegCloseKey(newkey);
	    WriteAsync();
	    return g_fAsync;
	}
	float answer=g_fAsync;
	int count=4;
	result=RegQueryValueExA(newkey, "Async", 0, 0, (int*)&answer, &count)
;
	RegCloseKey(newkey);
	return answer;
    }
    static void WriteAsync(float async=g_fAsync)
    {
	int result, status, newkey;
	result=RegCreateKeyExA(HKEY_CURRENT_USER, "Software\\AviPlayer", 0, 0, 0, 0, 0,
			&newkey, &status);
	if(result!=0)
	    return;
        result=RegSetValueExA(newkey, "Async", 0, REG_DWORD, (int*)&async, 4);
	RegCloseKey(newkey);    
    }
    static float ReadSubAsync()
    {
	int result, status, newkey;
	result=RegCreateKeyExA(HKEY_CURRENT_USER, "Software\\AviPlayer", 0, 0, 0, 0, 0,
			&newkey, &status);
	if(result!=0)
	    return 0;
	if(status==REG_CREATED_NEW_KEY)
	{
	    RegCloseKey(newkey);
	    WriteAsync();
	    return 0;
	}
	float answer=0;
	int count=4;
	result=RegQueryValueExA(newkey, "SubAsync", 0, 0, (int*)&answer, &count)
;
	RegCloseKey(newkey);
	return answer;
    }
    static void WriteSubAsync(float async=0)
    {
	int result, status, newkey;
	result=RegCreateKeyExA(HKEY_CURRENT_USER, "Software\\AviPlayer", 0, 0, 0, 0, 0,
			&newkey, &status);
	if(result!=0)
	    return;
        result=RegSetValueExA(newkey, "SubAsync", 0, REG_DWORD, (int*)&async, 4);
	RegCloseKey(newkey);    
    }
};

#endif // REGACCESS_H
