#include <qslider.h>
#include <qlabel.h>

#include "srcctl.h"
#include <cstdio>

/*
 *  Constructs a SourceControlWnd which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
SourceControlWnd::SourceControlWnd( QWidget* parent, RecKernel* kern )
    : SourceControl( parent, "Source control", false, 0 ),
    scale(1), btn_press(0), kernel(kern)
{
    update_size();
    Slider1->setTracking(false);
}

void SourceControlWnd::update_size()
{
    int len=kernel->getVideoLength();
    if(len<1000)
	scale=1;
    else
	scale=len/1000;
    Slider1->setRange(0, len/scale);
    Slider1->setValue(0);
    update_pos();
}
/*
 *  Destroys the object and frees any allocated resources
 */
SourceControlWnd::~SourceControlWnd()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 * public slot
 */
void SourceControlWnd::left_five_frames()
{
    kernel->seek(-5);
    update_pos();
}
/*
 * public slot
 */
void SourceControlWnd::left_frame()
{
    kernel->seek(-1);
    update_pos();
}
/*
 * public slot
 */
void SourceControlWnd::left_twenty_frames()
{
    kernel->seek(-20);
    update_pos();
}
/*
 * public slot
 */
void SourceControlWnd::pos_changed()
{
    framepos_t pos=Slider1->value() * scale;
    framepos_t c = kernel->pos();

    //cout << "poschane " << c << "    " << pos << endl;
    //if (!btn_press)

    if (pos != c)
    {
	pos=kernel->seek_pos(pos);
    }
    update_pos();
}
void SourceControlWnd::moved_func(int value)
{
    pos_changed();
}
/*
 * public slot
 */
void SourceControlWnd::right_five_frames()
{
    kernel->seek(5);
    update_pos();
}
/*
 * public slot
 */
void SourceControlWnd::right_frame()
{
    kernel->seek(1);
    update_pos();
}
/*
 * public slot
 */
void SourceControlWnd::right_twenty_frames()
{
    kernel->seek(20);
    update_pos();
}

void SourceControlWnd::next_key_frame()
{
    kernel->seekNextKeyFrame();
    update_pos();
}

void SourceControlWnd::prev_key_frame()
{
    kernel->seekPrevKeyFrame();
    update_pos();
}

void SourceControlWnd::update_pos()
{
    char s[256];
    double t = kernel->getTime((streamid_t)0);
    int sti = int(t);

    sprintf(s, "frame %6d  %.2d:%.2d:%.2d.%.3d", kernel->pos(),
	    sti/3600, (sti/60) % 60, sti % 60, int((t - sti) * 1000));

    //cout << s << endl;
    TextLabel3->setText(s);
}

#include "srcctl.moc"
#include "srcctl_p.moc"
