#include "recwnd_p.h"

#include <qlabel.h>
#include <qprogressbar.h>
#include <qpushbutton.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qgroupbox.h>
#include <qvariant.h>
#include <qtabwidget.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

class MainTabWidget: public QWidget
{
public:
    MainTabWidget(RecWnd_p& rec, QWidget* parent) : QWidget(parent)
    {
	static const char* labels[] =
	{
	    "Current video frame:",
	    "Current audio sample:",
	    "Video data:",
	    "Audio data:",
	    "Current file size:",
	    "Projected file size:",
	    "Video rendering rate:",
	    "Time elapsed:",
	    "Total time (estimated):"
	};

	QGridLayout* qgbl = new QGridLayout(this);
	qgbl->setMargin(5);
	qgbl->setSpacing(4);

	int i = -1;
	while (++i < RecWnd_p::LAST_LABEL)
	{
	    QLabel* l = new QLabel( this, "recwnd_label" );
	    l->setText( tr( labels[i] ));
	    qgbl->addWidget(l, i, 0);

	    l = rec.m_pText[i] = new QLabel( this, "recwnd_text" );
	    l->setFrameStyle( QFrame::StyledPanel | QFrame::Sunken );
	    l->setLineWidth( 1 );
	    l->setIndent( 5 );
	    if (i == 0)
                // some reasonable width - is there a better way ???
		l->setText("####################");
	    l->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	    qgbl->addWidget(l, i, 1);
	}
    }
};

/*
 *  Constructs a RecWnd_p which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
RecWnd_p::RecWnd_p( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "RecWnd_p" );
    //resize( 292, 184 );
    setCaption( tr( "Recompression progress"  ) );

    QGridLayout* qgl = new QGridLayout(this);
    qgl->setMargin(5);
    qgl->setSpacing(5);

    m_pTabWidget = new QTabWidget(this, "recwndTabWidget");

    m_pTabWidget->insertTab(new MainTabWidget(*this, m_pTabWidget),
			 tr( "&Main" ) );

    m_pTabWidget->insertTab(new QWidget(m_pTabWidget), tr( "&Video" ) );

    qgl->addMultiCellWidget( m_pTabWidget, 0, 0, 0, 2 );

    QLabel* l = new QLabel( this, "recwndProgressLabel" );
    l->setText( tr( "Progress:" ) );
    qgl->addWidget( l, 1, 0 );

    m_pProgress = new QProgressBar( this, "recwndProgressBar" );
    m_pProgress->setProgress( -1 );
    m_pProgress->setTotalSteps( 1000 );
    m_pProgress->setFrameShadow( QProgressBar::Sunken );
    m_pProgress->setFrameShape( QProgressBar::StyledPanel );
    m_pProgress->setIndicatorFollowsStyle( TRUE );
    qgl->addMultiCellWidget( m_pProgress, 1, 1, 1, 2 );

    QHBox* hb =  new QHBox( this );
    m_pPause = new QPushButton( hb, "recwndPause" );
    m_pPause->setText( tr( "Pause" ) );

    m_pStop = new QPushButton( hb, "recwndStop" );
    m_pStop->setText( tr( "Stop" ) );
    qgl->addWidget( hb, 2, 2 );

    // signals and slots connections
    connect( m_pPause, SIGNAL( clicked() ), this, SLOT( pauseProcess() ) );
    connect( m_pStop, SIGNAL( clicked() ), this, SLOT( cancelProcess() ) );
    connect( m_pTabWidget, SIGNAL( currentChanged(QWidget*) ), this,
	     SLOT( currentChanged(QWidget*) ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
RecWnd_p::~RecWnd_p()
{
    // no need to delete child widgets, Qt does it all for us
}

void RecWnd_p::cancelProcess()
{
    qWarning( "RecWnd_p::cancelProcess(): Not implemented yet!" );
}

void RecWnd_p::pauseProcess()
{
    qWarning( "RecWnd_p::pauseProcess(): Not implemented yet!" );
}

void RecWnd_p::currentChanged(QWidget* w)
{
    qWarning( "RecWnd_p::currentWidget(): Not implemented yet!" );
}
