#ifndef FILTERS_H
#define FILTERS_H

#include <qobjectdefs.h>
#include <qobject.h>

class GammaFilter:  public QObject, public Filter
{
    Q_OBJECT

    double _gamma;
    RecKernel* kernel;
public:
    GammaFilter(RecKernel* k):_gamma(1),kernel(k){}
    virtual avm::string name();
    virtual avm::string fullname();
    virtual CImage* process(CImage* im, int pos);
    virtual void about();
    virtual void config();
    virtual avm::string save();
    virtual void load(avm::string);
    virtual int id() const {return 0;}
public slots:
    void valueChanged(int new_val);
};

class BlurFilter:  public QObject, public Filter
{
    Q_OBJECT

    int _range;
    RecKernel* kernel;
public:
    BlurFilter(RecKernel* k):_range(3),kernel(k){}
    virtual avm::string name();
    virtual avm::string fullname();
    virtual CImage* process(CImage* im, int pos);
    virtual void about();
    virtual void config();
    virtual avm::string save();
    virtual void load(avm::string);
    virtual int id() const {return 1;}
public slots:
    void valueChanged(int new_val);
};
class RefractFilter:  public QObject, public Filter
{
    Q_OBJECT

    unsigned int _dist;
    double _power;
    RecKernel* kernel;
public:
    RefractFilter(RecKernel* k):_dist(5),_power(.1),kernel(k){}
    virtual avm::string name();
    virtual avm::string fullname();
    virtual CImage* process(CImage* im, int pos);
    virtual void about();
    virtual void config();
    virtual avm::string save();
    virtual void load(avm::string);
    virtual int id() const {return 2;}
public slots:
    void valueChanged1(int new_val);
    void valueChanged2(int new_val);
};
class NoiseFilter:  public QObject, public Filter
{
    Q_OBJECT

    int _qual;
    int _edge;
    int _zz;
    RecKernel* kernel;
public:
    NoiseFilter(RecKernel* k):_qual(940),_edge(2),_zz(4),kernel(k){}
    virtual avm::string name();
    virtual avm::string fullname();
    virtual CImage* process(CImage* im, int pos);
    virtual void about();
    virtual void config();
    virtual avm::string save();
    virtual void load(avm::string);
    virtual int id() const {return 3;}
public slots:
    void valueChanged1(int new_val);
    void valueChanged2(int new_val);
    void valueChanged3(int new_val);
};
class MoveFilter:  public QObject, public Filter
{
    Q_OBJECT

    int _delta;
    RecKernel* kernel;
public:
    MoveFilter(RecKernel* k):_delta(0),kernel(k){}
    virtual avm::string name();
    virtual avm::string fullname();
    virtual CImage* process(CImage* im, int pos);
    virtual void about();
    virtual void config();
    virtual avm::string save();
    virtual void load(avm::string);
    virtual int id() const {return 4;}
public slots:
    void valueChanged(int new_val);
};
/*
class SwapFilter: public QObject, public Filter
{
    RecKernel* kernel;
    Q_OBJECT
    double _c1, _c2, _c3, _c4;    
public:
    SwapFilter(RecKernel* k):kernel(k), _c1(1), _c2(0), _c3(0), _c4(1){}
    virtual string name(){return "Swap";}
    virtual string fullname(){return "Swap";}
    virtual CImage* process(CImage* im, int pos);
    virtual void about(){}
    virtual void config();
    virtual string save(){}
    virtual void load(string){}    
    virtual int id() const {return 5;}
public slots:
    void valueChanged1(int new_val);
    void valueChanged2(int new_val);
    void valueChanged3(int new_val);
    void valueChanged4(int new_val);
};
*/

class QLineEdit;
class ScaleFilter: public QObject, public Filter, public FormatChanger
{
    Q_OBJECT
    RecKernel* kernel;
    double m_dWidth, m_dHeight;
    bool m_bAspect;
    bool m_bPercent;
    enum ScaleType { FAST, RESAMPLE } type;
    QLineEdit* m_pLew;
    QLineEdit* m_pLeh;

public:
    ScaleFilter(RecKernel* k):kernel(k){}
    virtual avm::string name(){return "Scale";}
    virtual avm::string fullname(){return "Scale to specified size";}
    virtual CImage* process(CImage* im, int pos);
    virtual void about(){}
    virtual void config();
    virtual avm::string save() {return "";}
    virtual void load(avm::string){}
    virtual int id() const {return 5;}
    virtual void adjust(BITMAPINFOHEADER&);
public slots:
    void onAspectToggle();
    void onPercentToggle();
    void valueChangedW();
    void valueChangedH();
};

#endif // FILTERS_H
