#ifndef CONF_H
#define CONF_H

#include <fstream>
#include <map>
#include "default.h"
#include "avm_stl.h"
#include "avm_map.h"

class ReadConfig
{
    avm::avm_map<avm::string, avm::string> _map;
public:
    ReadConfig(const char* fn);
    const avm::string& String(avm::string key) {return *(_map.find_default(key));}
    int Int(avm::string key) {return strtol(_map.find_default(key)->c_str(), 0, 16);}
    double Double(avm::string key) {return atof(_map.find_default(key)->c_str());}
    ~ReadConfig(){}
};    

class WriteConfig
{
    avm::avm_map<avm::string, avm::string> _map;
    std::ofstream _of;
    avm::string _fn;
public:
    WriteConfig(const char* fn);
    void Add(avm::string key, avm::string value) { _map.insert(key, value); }
//    void Add(const char* key, string value){string s(key);Add(s, value);}
    void Add(avm::string key, int value);
//    void Add(const char* key, int value){string s(key);Add(s, value);}
    void Add(avm::string key, double value);
//    void Add(const char* key, double value){string s(key);Add(s, value);}
    ~WriteConfig();
};

#endif // CONF_H
