#include "conf.h"
#include "except.h"
#include <cstdio>
#include <iostream>

#define __MODULE__ "Read config"

using namespace avm;

ReadConfig::ReadConfig(const char* fn)
{
    //ifstream is;
    FILE *is = fopen(fn, "r");
    string s;
    //is.open(fn);
    //if(is.fail())
    if (!is)
	throw FATAL("Could not open file");
    //while(!is.eof())
    while (!feof(is))
    {
	char z[500];
	z[499]=0;
	//is.gets(&z);
	if (!fgets(z, 499, is))
	{
	    cerr<<"Z=0!"<<endl;
	    break;
	}    
	int endpos=strlen(z)-1;
	while((endpos>=0) && (z[endpos]=='\n'))
	{
	    z[endpos]=0;
	    endpos--;
	}
	s=string(z);
//	cerr<<s<<endl;
	string::size_type pos=s.find(':');
	if(pos==string::npos)
	{
//	    cerr<<"NO : !"<<endl;
	    break;
	}    
	string key=s;
	key.erase(pos);
	string value=s; 
	value.erase(0, pos+1);
	_map.insert(key, value);
	cerr<<"Key: "<<key<<" value: "<<std::hex<<value<<std::dec<<endl; 
	//delete z;
    }
}
#undef __MODULE__
#define __MODULE__ "Write config"
WriteConfig::WriteConfig(const char* fn):_fn(fn)
{
    _of.open(fn);
    if(_of.fail())
	throw FATAL("Could not open file");
}

WriteConfig::~WriteConfig()
{
    avm_map<string,string>::const_iterator it;
    for(it=_map.begin(); it!=_map.end(); it++)
    {
	if(it->key=="")
	    continue;
	_of<<it->key<<":"<<hex<<it->value<<dec<<endl;
    }
}

void WriteConfig::Add(string key, int value)
{
    char s[128];
    std::sprintf(s, "%x", value);
    _map.insert(key, string(s));
}

void WriteConfig::Add(string key, double value)
{
    char s[128];
    std::sprintf(s, "%f", value);
    _map.insert(key, string(s));
}
