#include "audc.h"
#include <qcombobox.h>

/* 
 *  Constructs a AudioCodecConfig which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
AudioCodecConfig::AudioCodecConfig( QWidget* parent, const AudioEncoderInfo& fmt)
    : AudioCompress( 0, "Audio codec config", TRUE, 0 ), info(fmt)
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
AudioCodecConfig::~AudioCodecConfig()
{
    // no need to delete child widgets, Qt does it all for us
}
void AudioCodecConfig::accept()
{
    if(ComboBox1->currentItem()==1)
    {
	info.fmt=85;
	info.bitrate=128000;
    }
    return QDialog::accept();
}
AudioEncoderInfo AudioCodecConfig::GetInfo()
{
    return info;
}
#include "audc.moc"
#include "audc_p.moc"
