#include "videoencoder.h"
#include "image.h"

class MJPEG_VideoEncoder: public IVideoEncoder
{
    BitmapInfo header;
    BitmapInfo of;
public:
    MJPEG_VideoEncoder(const CodecInfo& info, fourcc_t compressor, const BITMAPINFOHEADER& bh);
    ~MJPEG_VideoEncoder();
    virtual void Start();
    virtual void Stop();
    virtual int GetOutputSize() const { return header.biWidth*header.biHeight*4; }
    const BITMAPINFOHEADER& GetOutputFormat() const { return of; }
    virtual int EncodeFrame(const CImage* src, void* dest, int* is_keyframe, uint_t* size, int* lpckid=0);
    virtual int SetQuality(int quality);
    virtual int GetQuality() const;
};
