#include "fillplugins.h"
#include "plugin.h"
#include "mjpeg_decoder.h"
#include "mjpeg_encoder.h"

static avm::vector<CodecInfo> s_plugin_props;

extern "C" int GetPluginVersion()
{
    return PLUGIN_API_VERSION;
}

extern "C" const avm::vector<CodecInfo>& RegisterPlugin()
{
    if (!s_plugin_props.size())
	libosmjpeg_FillPlugins(s_plugin_props);

    return s_plugin_props;
}

extern "C" IVideoEncoder* CreateVideoEncoder(const CodecInfo& info, fourcc_t compressor, const BITMAPINFOHEADER& bh)
{
    return new MJPEG_VideoEncoder(info, compressor, bh);
}

extern "C" IVideoDecoder* CreateVideoDecoder(const CodecInfo& info, const BITMAPINFOHEADER& bh, int flip)
{
    return new MJPEG_VideoDecoder(info, bh, flip);
}
