#ifndef __VIDEOENCODER_H
#define __VIDEOENCODER_H
/********************************************************

	Video encoder interface
	Copyright 2000 Eugene Kuznetsov  (divx@euro.ru)

*********************************************************/

#include "videoencoder.h"

class VideoCodec;

class VideoEncoder: public IVideoEncoder
{
public:
    VideoEncoder(const CodecInfo& info, fourcc_t compressor, const BITMAPINFOHEADER& header);
    ~VideoEncoder();
    //
    // Encodes single frame
    // On success, is_keyframe contains 0 if frame was encoded into delta frame, otherwise AVIIF_KEYFRAME (?)
    // size receives size of compressed frame
    //
    virtual int EncodeFrame(const CImage* src, void* dest, int* is_keyframe, uint_t* size, int* lpckid = 0);
    //
    // Queries encoder about desired buffer size for compression
    // You should allocate at least this much bytes for dest ( arg for EncodeFrame )
    //
    virtual const BITMAPINFOHEADER& GetOutputFormat() const;
    virtual int GetOutputSize() const;

    virtual void Start();
    virtual void Stop();
    //
    // Quality takes values from 0 to 10000, 10000 the best
    //
    virtual int SetQuality(int quality);
    virtual int GetQuality() const { return m_iQual; }
    virtual int SetKeyFrame(int frequency);
    virtual int GetKeyFrame() const { return m_iKfFreq; }
protected:
    VideoCodec* codec;
    int m_comp_id;    
    int m_iState;
    BitmapInfo* m_bh;
    BITMAPINFOHEADER* m_obh;
    int m_iFrameNum;
    int m_iQual;
    int m_iKfFreq;
    char* m_prev;
    int m_iConfigDataSize;
    char* m_pConfigData;
};

#endif // __VIDEOENCODER_H
